/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.migration.Migrator;
import su.nightexpress.coinsengine.migration.command.MigrationCommands;
import su.nightexpress.coinsengine.migration.impl.PlayerPointsMigrator;
import su.nightexpress.coinsengine.migration.impl.VaultMigrator;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.Plugins;

public class MigrationManager
extends SimpleManager<CoinsEnginePlugin> {
    private final Map<String, Migrator> migrators = new HashMap<String, Migrator>();

    public MigrationManager(@NotNull CoinsEnginePlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.registerMigrator("PlayerPoints", () -> new PlayerPointsMigrator((CoinsEnginePlugin)this.plugin));
        this.registerMigrator("Vault", () -> new VaultMigrator((CoinsEnginePlugin)this.plugin));
        MigrationCommands.load((CoinsEnginePlugin)this.plugin, this);
    }

    protected void onShutdown() {
        this.migrators.clear();
    }

    public boolean registerMigrator(@NotNull String name, @NotNull Supplier<Migrator> supplier) {
        if (!Plugins.isInstalled((String)name)) {
            return false;
        }
        Migrator migrator = supplier.get();
        this.migrators.put(migrator.getName().toLowerCase(), migrator);
        ((CoinsEnginePlugin)this.plugin).info("Available balance data migration from " + migrator.getName() + ".");
        return true;
    }

    public boolean startMigration(@NotNull CommandSender sender, @NotNull String name, @NotNull Currency currency) {
        if (!((CoinsEnginePlugin)this.plugin).getCurrencyManager().canPerformOperations()) {
            Lang.MIGRATION_START_BLOCKED.getMessage().send(sender);
            return false;
        }
        Migrator migrator = this.getMigrator(name);
        if (migrator == null) {
            Lang.MIGRATION_START_BAD_PLUGIN.getMessage().send(sender);
            return false;
        }
        if (!migrator.canMigrate(currency)) {
            Lang.MIGRATION_START_BAD_CURRENCY.getMessage().send(sender, replacer -> replacer.replace("%name%", (Object)migrator.getName()).replace(currency.replacePlaceholders()));
            return false;
        }
        ((CoinsEnginePlugin)this.plugin).runTaskAsync(task -> {
            ((CoinsEnginePlugin)this.plugin).getCurrencyManager().disableOperations();
            Lang.MIGRATION_STARTED.getMessage().send(sender, replacer -> replacer.replace("%name%", (Object)migrator.getName()));
            this.migrate(migrator, currency);
            Lang.MIGRATION_COMPLETED.getMessage().send(sender, replacer -> replacer.replace("%name%", (Object)migrator.getName()));
            ((CoinsEnginePlugin)this.plugin).getCurrencyManager().allowOperations();
        });
        return true;
    }

    public void migrate(@NotNull Migrator migrator, @NotNull Currency currency) {
        Map<OfflinePlayer, Double> balances = migrator.getBalances(currency);
        balances.forEach((player, amount) -> {
            String name = player.getName();
            if (name == null) {
                return;
            }
            UUID uuid = player.getUniqueId();
            CoinsUser user = (CoinsUser)((CoinsEnginePlugin)this.plugin).getUserManager().getOrFetch(uuid);
            if (user == null) {
                user = CoinsUser.create(uuid, name);
                ((CoinsEnginePlugin)this.plugin).getDataHandler().insertUser(user);
            }
            user.setBalance(currency, (double)amount);
            ((CoinsEnginePlugin)this.plugin).getUserManager().save(user);
        });
    }

    @NotNull
    public List<String> getMigratorNames() {
        return new ArrayList<String>(this.migrators.keySet());
    }

    @NotNull
    public Map<String, Migrator> getMigratorMap() {
        return this.migrators;
    }

    @Nullable
    public Migrator getMigrator(@NotNull String name) {
        return this.migrators.get(name.toLowerCase());
    }
}

