/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.api;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.currency.CurrencyManager;
import su.nightexpress.coinsengine.data.UserManager;
import su.nightexpress.coinsengine.data.impl.CoinsUser;

public class CoinsEngineAPI {
    private static CoinsEnginePlugin plugin;

    public static void load(@NotNull CoinsEnginePlugin plugin) {
        CoinsEngineAPI.plugin = plugin;
    }

    public static void unload() {
        plugin = null;
    }

    @NotNull
    public static UserManager getUserManager() {
        return plugin.getUserManager();
    }

    @NotNull
    public static CurrencyManager getCurrencyManager() {
        return plugin.getCurrencyManager();
    }

    @Nullable
    public static Currency getCurrency(@NotNull String id) {
        return CoinsEngineAPI.getCurrencyManager().getCurrency(id);
    }

    public static boolean hasCurrency(@NotNull String id) {
        return CoinsEngineAPI.getCurrency(id) != null;
    }

    public static void regsiterCurrency(@NotNull Currency currency) {
        CoinsEngineAPI.getCurrencyManager().registerCurrency(currency);
    }

    public static double getBalance(@NotNull Player player, @NotNull Currency currency) {
        return CoinsEngineAPI.getUserData(player).getBalance(currency);
    }

    public static double getBalance(@NotNull UUID playerId, @NotNull Currency currency) {
        CoinsUser user = CoinsEngineAPI.getUserData(playerId);
        return user == null ? 0.0 : user.getBalance(currency);
    }

    public static double getBalance(@NotNull UUID playerId, @NotNull String currencyName) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency == null ? 0.0 : CoinsEngineAPI.getBalance(playerId, currency);
    }

    public static void addBalance(@NotNull Player player, @NotNull Currency currency, double amount) {
        CoinsEngineAPI.editBalance(() -> CoinsEngineAPI.getUserData(player), user -> user.addBalance(currency, amount));
    }

    public static void setBalance(@NotNull Player player, @NotNull Currency currency, double amount) {
        CoinsEngineAPI.editBalance(() -> CoinsEngineAPI.getUserData(player), user -> user.setBalance(currency, amount));
    }

    public static void removeBalance(@NotNull Player player, @NotNull Currency currency, double amount) {
        CoinsEngineAPI.editBalance(() -> CoinsEngineAPI.getUserData(player), user -> user.removeBalance(currency, amount));
    }

    public static boolean addBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount) {
        return CoinsEngineAPI.editBalance(() -> CoinsEngineAPI.getUserData(playerId), user -> user.addBalance(currency, amount));
    }

    public static boolean setBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount) {
        return CoinsEngineAPI.editBalance(() -> CoinsEngineAPI.getUserData(playerId), user -> user.setBalance(currency, amount));
    }

    public static boolean removeBalance(@NotNull UUID playerId, @NotNull Currency currency, double amount) {
        return CoinsEngineAPI.editBalance(() -> CoinsEngineAPI.getUserData(playerId), user -> user.removeBalance(currency, amount));
    }

    public static boolean addBalance(@NotNull UUID playerId, @NotNull String currencyName, double amount) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency != null && CoinsEngineAPI.addBalance(playerId, currency, amount);
    }

    public static boolean setBalance(@NotNull UUID playerId, @NotNull String currencyName, double amount) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency != null && CoinsEngineAPI.setBalance(playerId, currency, amount);
    }

    public static boolean removeBalance(@NotNull UUID playerId, @NotNull String currencyName, double amount) {
        Currency currency = CoinsEngineAPI.getCurrency(currencyName);
        return currency != null && CoinsEngineAPI.removeBalance(playerId, currency, amount);
    }

    private static boolean editBalance(@NotNull Supplier<CoinsUser> supplier, @NotNull Consumer<CoinsUser> consumer) {
        CoinsUser user = supplier.get();
        if (user == null) {
            return false;
        }
        consumer.accept(user);
        CoinsEngineAPI.getUserManager().save(user);
        return true;
    }

    @NotNull
    public static CoinsUser getUserData(@NotNull Player player) {
        return (CoinsUser)CoinsEngineAPI.getUserManager().getOrFetch(player);
    }

    @Nullable
    public static CoinsUser getUserData(@NotNull String name) {
        return (CoinsUser)CoinsEngineAPI.getUserManager().getOrFetch(name);
    }

    @Nullable
    public static CoinsUser getUserData(@NotNull UUID uuid) {
        return (CoinsUser)CoinsEngineAPI.getUserManager().getOrFetch(uuid);
    }

    @NotNull
    public static CompletableFuture<CoinsUser> getUserDataAsync(@NotNull String name) {
        return CoinsEngineAPI.getUserManager().getUserDataAsync(name);
    }

    @NotNull
    public static CompletableFuture<CoinsUser> getUserDataAsync(@NotNull UUID uuid) {
        return CoinsEngineAPI.getUserManager().getUserDataAsync(uuid);
    }
}

