/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.api.currency;

import java.util.Map;
import java.util.function.UnaryOperator;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.Placeholders;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.nightcore.db.sql.column.Column;
import su.nightexpress.nightcore.language.message.LangMessage;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.number.CompactNumber;

public interface Currency {
    @NotNull
    default public UnaryOperator<String> replacePlaceholders() {
        return Placeholders.forCurrency(this);
    }

    @NotNull
    default public LangMessage withPrefix(@NotNull LangMessage message) {
        if (!((Boolean)Config.CURRENCY_PREFIX_ENABLED.get()).booleanValue()) {
            return message;
        }
        String prefix = (String)this.replacePlaceholders().apply((String)Config.CURRENCY_PREFIX_FORMAT.get());
        return message.setPrefix(prefix);
    }

    default public boolean isUnlimited() {
        return this.getMaxValue() <= 0.0;
    }

    default public boolean isLimited() {
        return !this.isUnlimited();
    }

    default public boolean isInteger() {
        return !this.isDecimal();
    }

    default public boolean isUnderLimit(double value) {
        return this.isUnlimited() || value <= this.getMaxValue();
    }

    default public double fine(double amount) {
        return this.isDecimal() ? amount : Math.floor(amount);
    }

    default public double limit(double amount) {
        return this.isLimited() ? Math.min(amount, this.getMaxValue()) : amount;
    }

    default public double fineAndLimit(double amount) {
        return this.fine(this.limit(amount));
    }

    default public double getExchangeRate(@NotNull Currency currency) {
        return this.getExchangeRate(currency.getId());
    }

    default public double getExchangeRate(@NotNull String id) {
        return this.getExchangeRates().getOrDefault(id.toLowerCase(), 0.0);
    }

    @NotNull
    default public String getPermission() {
        return "coinsengine.currency." + this.getId();
    }

    @NotNull
    default public String formatValue(double balance) {
        return NumberUtil.format((double)this.fine(balance));
    }

    @NotNull
    default public String format(double balance) {
        String format = this.getFormat();
        if (Config.useCurrencyFormatPAPI()) {
            format = PlaceholderAPI.setPlaceholders(null, (String)format);
        }
        return ((String)this.replacePlaceholders().apply(format)).replace("%amount%", this.formatValue(balance));
    }

    @NotNull
    default public CompactNumber formatCompactValue(double balance) {
        return NumberUtil.asCompact((double)this.fine(balance));
    }

    @NotNull
    default public String formatCompact(double balance) {
        String format = this.getFormatShort();
        if (Config.useCurrencyFormatPAPI()) {
            format = PlaceholderAPI.setPlaceholders(null, (String)format);
        }
        CompactNumber compact = this.formatCompactValue(balance);
        return ((String)this.replacePlaceholders().apply(format)).replace("%amount%", compact.format());
    }

    @NotNull
    public String getId();

    @NotNull
    public String getName();

    public void setName(@NotNull String var1);

    @NotNull
    public String getPrefix();

    public void setPrefix(@NotNull String var1);

    @NotNull
    public String getSymbol();

    public void setSymbol(@NotNull String var1);

    @NotNull
    public String getFormat();

    public void setFormat(@NotNull String var1);

    @NotNull
    public String getFormatShort();

    public void setFormatShort(@NotNull String var1);

    @NotNull
    public String[] getCommandAliases();

    public void setCommandAliases(String ... var1);

    @NotNull
    public String getColumnName();

    public void setColumnName(@NotNull String var1);

    @NotNull
    public Column getColumn();

    @NotNull
    public ItemStack getIcon();

    public void setIcon(@NotNull ItemStack var1);

    public boolean isDecimal();

    public void setDecimal(boolean var1);

    public boolean isPermissionRequired();

    public void setPermissionRequired(boolean var1);

    public boolean isSynchronizable();

    public void setSynchronizable(boolean var1);

    public boolean isTransferAllowed();

    public void setTransferAllowed(boolean var1);

    public double getMinTransferAmount();

    public void setMinTransferAmount(double var1);

    public double getStartValue();

    public void setStartValue(double var1);

    public double getMaxValue();

    public void setMaxValue(double var1);

    public boolean isVaultEconomy();

    public void setVaultEconomy(boolean var1);

    public boolean isExchangeAllowed();

    public void setExchangeAllowed(boolean var1);

    @NotNull
    public Map<String, Double> getExchangeRates();
}

