/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.impl;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandArguments;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.migration.MigrationPlugin;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.command.experimental.CommandContext;
import su.nightexpress.nightcore.command.experimental.argument.ArgumentTypes;
import su.nightexpress.nightcore.command.experimental.argument.ParsedArguments;
import su.nightexpress.nightcore.command.experimental.builder.DirectNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.NodeBuilder;
import su.nightexpress.nightcore.command.experimental.impl.ReloadCommand;
import su.nightexpress.nightcore.command.experimental.node.ChainedNode;
import su.nightexpress.nightcore.command.experimental.node.DirectNode;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.util.wrapper.UniPermission;

public class BasicCommands {
    public static void load(@NotNull CoinsEnginePlugin plugin) {
        ChainedNode rootNode = plugin.getRootNode();
        rootNode.addChildren((NodeBuilder)ReloadCommand.builder((NightCorePlugin)plugin, (UniPermission)Perms.COMMAND_RELOAD));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"migrate"}).permission(Perms.COMMAND_MIGRATE)).description(Lang.COMMAND_MIGRATE_DESC)).withArgument(ArgumentTypes.string((String)"name").required().localized(Lang.COMMAND_ARGUMENT_NAME_PLUGIN).withSamples(context -> plugin.getMigrationManager().getMigrationPluginNames())).withArgument(CommandArguments.currency(plugin).required()).executes((context, arguments) -> BasicCommands.migrate(plugin, context, arguments)));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"reset"}).permission(Perms.COMMAND_RESET)).description(Lang.COMMAND_RESET_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).executes((context, arguments) -> BasicCommands.reset(plugin, context, arguments)));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"wipe"}).permission(Perms.COMMAND_WIPE)).description(Lang.COMMAND_WIPE_DESC)).withArgument(CommandArguments.currency(plugin).required()).executes((context, arguments) -> BasicCommands.wipe(plugin, context, arguments)));
    }

    public static boolean migrate(@NotNull CoinsEnginePlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        MigrationPlugin migrationPlugin = plugin.getMigrationManager().getPlugin(arguments.getStringArgument("name"));
        if (migrationPlugin == null) {
            Lang.COMMAND_MIGRATE_ERROR_PLUGIN.getMessage().send(context.getSender());
            return false;
        }
        Currency currency = (Currency)arguments.getArgument("currency", Currency.class);
        plugin.runTaskAsync(task -> {
            Lang.COMMAND_MIGRATE_START.getMessage().send(context.getSender(), replacer -> replacer.replace("%name%", (Object)migrationPlugin.getPluginName()));
            plugin.getMigrationManager().migrate(migrationPlugin, currency);
            Lang.COMMAND_MIGRATE_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace("%name%", (Object)migrationPlugin.getPluginName()));
        });
        return true;
    }

    public static boolean reset(@NotNull CoinsEnginePlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            user.resetBalance();
            plugin.getUserManager().save((AbstractUser)user);
            Lang.COMMAND_RESET_DONE.getMessage().send(context.getSender(), replacer -> replacer.replace("%player_name%", (Object)user.getName()));
        });
        return true;
    }

    public static boolean wipe(@NotNull CoinsEnginePlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Currency currency = (Currency)arguments.getArgument("currency", Currency.class);
        Lang.COMMAND_WIPE_START.getMessage().send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()));
        plugin.runTaskAsync(task -> {
            plugin.getData().resetBalances(currency);
            plugin.getUserManager().getLoaded().forEach(user -> user.resetBalance(currency));
            Lang.COMMAND_WIPE_FINISH.getMessage().send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()));
        });
        return true;
    }
}

