/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandArguments;
import su.nightexpress.coinsengine.command.CommandFlags;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.data.impl.CurrencySettings;
import su.nightexpress.coinsengine.util.TopEntry;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.command.experimental.CommandContext;
import su.nightexpress.nightcore.command.experimental.RootCommand;
import su.nightexpress.nightcore.command.experimental.ServerCommand;
import su.nightexpress.nightcore.command.experimental.argument.ArgumentTypes;
import su.nightexpress.nightcore.command.experimental.argument.ParsedArguments;
import su.nightexpress.nightcore.command.experimental.builder.ChainedNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.DirectNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.FlagBuilder;
import su.nightexpress.nightcore.command.experimental.builder.NodeBuilder;
import su.nightexpress.nightcore.command.experimental.node.ChainedNode;
import su.nightexpress.nightcore.command.experimental.node.CommandNode;
import su.nightexpress.nightcore.command.experimental.node.DirectNode;
import su.nightexpress.nightcore.command.experimental.node.NodeExecutor;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;

public class CurrencyCommands {
    public static void loadForCurrency(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency) {
        RootCommand command = RootCommand.chained((NightCorePlugin)plugin, (String[])currency.getCommandAliases(), builder -> ((ChainedNodeBuilder)builder.permission(currency.isPermissionRequired() ? currency.getPermission() : null)).description((String)currency.replacePlaceholders().apply(Lang.COMMAND_CURRENCY_ROOT_DESC.getString())));
        ChainedNode rootNode = (ChainedNode)command.getNode();
        DirectNode balanceNode = CurrencyCommands.balanceBuilder(plugin, currency, "balance").build();
        if (((Boolean)Config.CURRENCY_COMMAND_DEFAULT_TO_BALANCE.get()).booleanValue()) {
            rootNode.setFallback((NodeExecutor)balanceNode);
        }
        rootNode.addChildren((CommandNode)balanceNode);
        rootNode.addChildren((NodeBuilder)CurrencyCommands.topBuilder(plugin, currency, "top"));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"giveall"}).permission(Perms.COMMAND_CURRENCY_GIVE_ALL)).description(Lang.COMMAND_CURRENCY_GIVE_ALL_DESC)).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.giveAll(plugin, currency, context, arguments)));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"give"}).permission(Perms.COMMAND_CURRENCY_GIVE)).description(Lang.COMMAND_CURRENCY_GIVE_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.give(plugin, currency, context, arguments)));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"set"}).permission(Perms.COMMAND_CURRENCY_SET)).description(Lang.COMMAND_CURRENCY_SET_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.set(plugin, currency, context, arguments)));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"take"}).permission(Perms.COMMAND_CURRENCY_TAKE)).description(Lang.COMMAND_CURRENCY_TAKE_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.remove(plugin, currency, context, arguments)));
        if (currency.isTransferAllowed()) {
            rootNode.addChildren((NodeBuilder)CurrencyCommands.payBuilder(plugin, currency, "pay", "send"));
            rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"payments"}).permission(Perms.COMMAND_CURRENCY_PAYMENTS)).description(Lang.COMMAND_CURRENCY_PAYMENTS_DESC)).withArgument(ArgumentTypes.playerName((String)"player").permission(Perms.COMMAND_CURRENCY_PAYMENTS_OTHERS)).withFlag(CommandFlags.silent().permission(Perms.COMMAND_CURRENCY_PAYMENTS_OTHERS)).executes((context, arguments) -> CurrencyCommands.togglePayments(plugin, currency, context, arguments)));
        }
        if (currency.isExchangeAllowed()) {
            rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"exchange"}).playerOnly()).permission(Perms.COMMAND_CURRENCY_EXCHANGE)).description(Lang.COMMAND_CURRENCY_EXCHANGE_DESC)).withArgument(CommandArguments.currency(plugin).required().withSamples(context -> plugin.getCurrencyManager().getCurrencies().stream().filter(other -> currency.getExchangeRate((Currency)other) > 0.0).map(Currency::getId).toList())).withArgument(CommandArguments.amount().required()).executes((context, arguments) -> CurrencyCommands.exchange(plugin, currency, context, arguments)));
        }
        plugin.getCommandManager().registerCommand((ServerCommand)command);
    }

    public static void loadForEconomy(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency) {
        RootCommand balanceCommand = RootCommand.build((NightCorePlugin)plugin, (NodeBuilder)CurrencyCommands.balanceBuilder(plugin, currency, "balance", "bal"));
        RootCommand payCommand = RootCommand.build((NightCorePlugin)plugin, (NodeBuilder)CurrencyCommands.payBuilder(plugin, currency, "pay"));
        RootCommand topCommand = RootCommand.build((NightCorePlugin)plugin, (NodeBuilder)CurrencyCommands.topBuilder(plugin, currency, "balancetop", "baltop"));
        plugin.getCommandManager().registerCommand((ServerCommand)balanceCommand);
        plugin.getCommandManager().registerCommand((ServerCommand)payCommand);
        plugin.getCommandManager().registerCommand((ServerCommand)topCommand);
    }

    public static void unloadForCurrency(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency) {
        plugin.getCommandManager().unregisterServerCommand(currency.getCommandAliases()[0]);
    }

    public static void unloadForEconomy(@NotNull CoinsEnginePlugin plugin) {
        plugin.getCommandManager().unregisterServerCommand("balance");
        plugin.getCommandManager().unregisterServerCommand("pay");
        plugin.getCommandManager().unregisterServerCommand("balancetop");
    }

    private static DirectNodeBuilder balanceBuilder(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, String ... aliases) {
        return ((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])aliases).permission(Perms.COMMAND_CURRENCY_BALANCE)).description(Lang.COMMAND_CURRENCY_BALANCE_DESC)).withArgument(ArgumentTypes.playerName((String)"player").permission(Perms.COMMAND_CURRENCY_BALANCE_OTHERS)).executes((context, arguments) -> CurrencyCommands.showBalance(plugin, currency, context, arguments));
    }

    private static DirectNodeBuilder payBuilder(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, String ... aliases) {
        return ((DirectNodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])aliases).playerOnly()).permission(Perms.COMMAND_CURRENCY_SEND)).description(Lang.COMMAND_CURRENCY_SEND_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).executes((context, arguments) -> CurrencyCommands.send(plugin, currency, context, arguments));
    }

    private static DirectNodeBuilder topBuilder(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, String ... aliases) {
        return ((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])aliases).permission(Perms.COMMAND_CURRENCY_TOP)).description(Lang.COMMAND_CURRENCY_TOP_DESC)).withArgument(ArgumentTypes.integerAbs((String)"amount").localized(Lang.COMMAND_ARGUMENT_NAME_PAGE).withSamples(context -> IntStream.range(1, 11).boxed().map(String::valueOf).toList())).executes((context, arguments) -> CurrencyCommands.showTop(plugin, currency, context, arguments));
    }

    public static boolean showBalance(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getStringArgument("player", context.getSender().getName());
        boolean isOwn = !arguments.hasArgument("player");
        plugin.getUserManager().manageUser(name, user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            currency.withPrefix((isOwn ? Lang.CURRENCY_BALANCE_DISPLAY_OWN : Lang.CURRENCY_BALANCE_DISPLAY_OTHERS).getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%player_name%", (Object)user.getName()).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
        });
        return true;
    }

    public static boolean exchange(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Currency targetCurrency = (Currency)arguments.getArgument("currency", Currency.class);
        double amount = arguments.getDoubleArgument("amount");
        if (amount <= 0.0) {
            return false;
        }
        Player player = context.getPlayerOrThrow();
        return plugin.getCurrencyManager().exchange(player, currency, targetCurrency, amount);
    }

    public static boolean giveAll(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        double amount = arguments.getDoubleArgument("amount");
        if (amount <= 0.0) {
            return false;
        }
        plugin.getServer().getOnlinePlayers().forEach(player -> {
            CoinsUser user = (CoinsUser)plugin.getUserManager().getOrFetch((Player)player);
            user.addBalance(currency, amount);
            plugin.getUserManager().save(user);
            plugin.getCoinsLogger().logGive(user, currency, amount, context.getSender());
            if (!arguments.hasFlag("s")) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_GIVE_NOTIFY.getMessage()).send((CommandSender)player, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
            }
        });
        if (!arguments.hasFlag("sf")) {
            currency.withPrefix(Lang.COMMAND_CURRENCY_GIVE_ALL_DONE.getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)));
        }
        return true;
    }

    public static boolean give(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        double amount = arguments.getDoubleArgument("amount");
        if (amount <= 0.0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            user.addBalance(currency, amount);
            plugin.getUserManager().save((AbstractUser)user);
            plugin.getCoinsLogger().logGive((CoinsUser)((Object)user), currency, amount, context.getSender());
            if (!arguments.hasFlag("sf")) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_GIVE_DONE.getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
            }
            Player target = user.getPlayer();
            if (!arguments.hasFlag("s") && target != null) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_GIVE_NOTIFY.getMessage()).send((CommandSender)target, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
            }
        });
        return true;
    }

    public static boolean togglePayments(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        boolean isOwn = !arguments.hasArgument("player");
        String name = arguments.getStringArgument("player", context.getSender().getName());
        plugin.getUserManager().manageUser(name, user -> {
            CurrencySettings settings;
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            settings.setPaymentsEnabled(!(settings = user.getSettings(currency)).isPaymentsEnabled());
            plugin.getUserManager().save((AbstractUser)user);
            if (!isOwn) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_PAYMENTS_TARGET.getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%player_name%", (Object)user.getName()).replace("%state%", (Object)Lang.getEnabledOrDisabled((boolean)settings.isPaymentsEnabled())));
            }
            Player target = user.getPlayer();
            if (!arguments.hasFlag("s") && target != null) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_PAYMENTS_TOGGLE.getMessage()).send((CommandSender)target, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%state%", (Object)Lang.getEnabledOrDisabled((boolean)settings.isPaymentsEnabled())));
            }
        });
        return true;
    }

    public static boolean send(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player from = context.getPlayerOrThrow();
        String targetName = arguments.getStringArgument("player");
        if (from.getName().equalsIgnoreCase(targetName)) {
            Lang.ERROR_COMMAND_NOT_YOURSELF.getMessage().send(context.getSender());
            return false;
        }
        double amount = currency.fine(arguments.getDoubleArgument("amount"));
        if (amount <= 0.0) {
            return false;
        }
        if (currency.getMinTransferAmount() > 0.0 && amount < currency.getMinTransferAmount()) {
            currency.withPrefix(Lang.COMMAND_CURRENCY_SEND_ERROR_TOO_LOW.getMessage()).send(context.getSender(), replacer -> replacer.replace("%amount%", (Object)currency.format(currency.getMinTransferAmount())));
            return false;
        }
        plugin.getUserManager().manageUser(targetName, targetUser -> {
            if (targetUser == null) {
                context.errorBadPlayer();
                return;
            }
            CoinsUser fromUser = (CoinsUser)plugin.getUserManager().getOrFetch(from);
            if (amount > fromUser.getBalance(currency)) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_SEND_ERROR_NOT_ENOUGH.getMessage()).send((CommandSender)from, replacer -> replacer.replace(currency.replacePlaceholders()));
                return;
            }
            CurrencySettings settings = targetUser.getSettings(currency);
            if (!settings.isPaymentsEnabled()) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_SEND_ERROR_NO_PAYMENTS.getMessage()).send((CommandSender)from, replacer -> replacer.replace("%player_name%", (Object)targetUser.getName()).replace(currency.replacePlaceholders()));
                return;
            }
            targetUser.addBalance(currency, amount);
            fromUser.removeBalance(currency, amount);
            plugin.getUserManager().save((AbstractUser)targetUser);
            plugin.getUserManager().save(fromUser);
            plugin.getCoinsLogger().logSend((CoinsUser)((Object)targetUser), currency, amount, (CommandSender)from);
            currency.withPrefix(Lang.COMMAND_CURRENCY_SEND_DONE_SENDER.getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)fromUser.getBalance(currency)).replace("%player_name%", (Object)targetUser.getName()));
            Player target = plugin.getServer().getPlayer(targetUser.getName());
            if (target != null) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_SEND_DONE_NOTIFY.getMessage()).send((CommandSender)target, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)targetUser.getBalance(currency)).replace("%player_name%", (Object)fromUser.getName()));
            }
        });
        return true;
    }

    public static boolean set(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        double amount = arguments.getDoubleArgument("amount");
        if (amount < 0.0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            user.setBalance(currency, amount);
            plugin.getUserManager().save((AbstractUser)user);
            plugin.getCoinsLogger().logSet((CoinsUser)((Object)user), currency, amount, context.getSender());
            if (!arguments.hasFlag("sf")) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_SET_DONE.getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
            }
            Player target = user.getPlayer();
            if (!arguments.hasFlag("s") && target != null) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_SET_NOTIFY.getMessage()).send((CommandSender)target, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
            }
        });
        return true;
    }

    public static boolean remove(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        double amount = arguments.getDoubleArgument("amount");
        if (amount <= 0.0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            user.removeBalance(currency, amount);
            plugin.getUserManager().save((AbstractUser)user);
            plugin.getCoinsLogger().logTake((CoinsUser)((Object)user), currency, amount, context.getSender());
            if (!arguments.hasFlag("sf")) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_TAKE_DONE.getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%player_name%", (Object)user.getName()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
            }
            Player target = user.getPlayer();
            if (!arguments.hasFlag("s") && target != null) {
                currency.withPrefix(Lang.COMMAND_CURRENCY_TAKE_NOTIFY.getMessage()).send((CommandSender)target, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
            }
        });
        return true;
    }

    public static boolean showTop(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        int perPage = (Integer)Config.TOP_ENTRIES_PER_PAGE.get();
        List<TopEntry> full = plugin.getCurrencyManager().getTopBalances(currency);
        List split = Lists.split(full, (int)perPage);
        int pages = split.size();
        int page = Math.max(0, Math.min(pages, Math.abs(arguments.getIntArgument("amount", 1))) - 1);
        List entries = pages > 0 ? (List)split.get(page) : new ArrayList();
        currency.withPrefix(Lang.COMMAND_CURRENCY_TOP_LIST.getMessage()).send(context.getSender(), replacer -> replacer.replace(currency.replacePlaceholders()).replace("%current%", (Object)(page + 1)).replace("%max%", (Object)pages).replace("%entry%", list -> {
            for (TopEntry entry : entries) {
                list.add(Lang.COMMAND_CURRENCY_TOP_ENTRY.getString().replace("%pos%", NumberUtil.format((double)entry.position())).replace("%balance%", currency.format(entry.balance())).replace("%player_name%", entry.name()));
            }
        }));
        return true;
    }
}

