/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.config;

import java.time.format.DateTimeFormatter;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class Config {
    public static final String DIR_CURRENCIES = "/currencies/";
    public static final String LOG_FILENAME = "operations.log";
    public static final ConfigValue<Boolean> GENERAL_PLACEHOLDER_API_FOR_CURRENCY_FORMAT = ConfigValue.create((String)"General.PlaceholderAPI_For_Currency_Format", (boolean)true, (String[])new String[]{"Sets whether to apply PlaceholderAPI placeholders for currency 'Format' setting.", "Allows you to use custom images from Oraxen or ItemsAdder, as well as any other player unrelated placeholders."});
    public static final ConfigValue<Boolean> CURRENCY_PREFIX_ENABLED = ConfigValue.create((String)"Currency.Prefix.Enabled", (boolean)true, (String[])new String[]{"Controls whether or not currency messages will use custom prefix instead of the plugin's one."});
    public static final ConfigValue<String> CURRENCY_PREFIX_FORMAT = ConfigValue.create((String)"Currency.Prefix.Format", (String)(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("%currency_prefix%")) + Tags.DARK_GRAY.enclose(" \u00bb ") + Tags.GRAY.getBracketsName()), (String[])new String[]{"Sets custom prefix format for currency messages.", "You can use 'Currency' placeholders: https://nightexpressdev.com/coinsengine/placeholders/"});
    public static final ConfigValue<Boolean> CURRENCY_COMMAND_DEFAULT_TO_BALANCE = ConfigValue.create((String)"Currency.Command.Default_To_Balance", (boolean)true, (String[])new String[]{"When enabled, fallbacks to the balance command when no or invalid argument(s) were provided.", "Example: /coins => /coins balance"});
    public static final ConfigValue<Boolean> ECONOMY_COMMAND_SHORTCUTS_ENABLED = ConfigValue.create((String)"Economy.Command_Shortcuts.Enabled", (boolean)true, (String[])new String[]{"Sets whether or not plugin will register shortcut versions of 'balance', 'pay' and 'top' commands for Vault-compatible currency.", "When this setting disabled, you will have to use, for example, '/money balance' command instead of just '/balance'."});
    public static final ConfigValue<Integer> TOP_ENTRIES_PER_PAGE = ConfigValue.create((String)"Top.Entries_Per_Page", (int)10, (String[])new String[]{"Sets how many entries will be displayed per page for currency top commands."});
    public static final ConfigValue<Integer> TOP_UPDATE_INTERVAL = ConfigValue.create((String)"Top.Update_Interval", (int)300, (String[])new String[]{"Sets how often (in seconds) currency top balances will be fetched & updated."});
    public static final ConfigValue<DateTimeFormatter> LOGS_DATE_FORMAT = new ConfigValue("Logs.DateFormat", (cfg, path, def) -> DateTimeFormatter.ofPattern(cfg.getString(path, "dd/MM/yyyy HH:mm:ss")), (cfg, path, formatter) -> cfg.set(path, (Object)"dd/MM/yyyy HH:mm:ss"), (Object)DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"), new String[]{"Sets logs date format."});
    public static final ConfigValue<Boolean> LOGS_TO_CONSOLE = ConfigValue.create((String)"Logs.Enabled.Console", (boolean)false, (String[])new String[]{"Sets whether or not all currency command-based balance operations will be logged to console."});
    public static final ConfigValue<Boolean> LOGS_TO_FILE = ConfigValue.create((String)"Logs.Enabled.File", (boolean)true, (String[])new String[]{"Sets whether or not all currency command-based balance operations will be logged to a file."});

    public static boolean useCurrencyFormatPAPI() {
        return (Boolean)GENERAL_PLACEHOLDER_API_FOR_CURRENCY_FORMAT.get() != false && Plugins.hasPlaceholderAPI();
    }
}

