/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.currency;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.impl.CurrencyCommands;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.currency.impl.ConfigCurrency;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.hook.vault.VaultHook;
import su.nightexpress.coinsengine.util.TopEntry;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.StringUtil;

public class CurrencyManager
extends AbstractManager<CoinsEnginePlugin> {
    private final Map<String, Currency> currencyMap = new HashMap<String, Currency>();
    private final Map<String, List<TopEntry>> totalBalanceMap = new ConcurrentHashMap<String, List<TopEntry>>();

    public CurrencyManager(@NotNull CoinsEnginePlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.createDefaults();
        for (File file : FileUtil.getConfigFiles((String)this.getDirectory())) {
            ConfigCurrency currency = new ConfigCurrency((CoinsEnginePlugin)this.plugin, file);
            if (!currency.load()) continue;
            this.registerCurrency(currency);
        }
        this.addAsyncTask(this::updateBalances, (Integer)Config.TOP_UPDATE_INTERVAL.get());
    }

    protected void onShutdown() {
        if (Plugins.hasVault()) {
            VaultHook.shutdown();
        }
        this.getCurrencies().forEach(this::unregisterCurrency);
        this.currencyMap.clear();
        this.totalBalanceMap.clear();
    }

    private void createDefaults() {
        File dir = new File(this.getDirectory());
        if (dir.exists()) {
            return;
        }
        this.createCurrency("coins", currency -> {
            currency.setSymbol("\u26c2");
            currency.setIcon(new ItemStack(Material.SUNFLOWER));
            currency.setDecimal(false);
        });
        this.createCurrency("money", currency -> {
            currency.setSymbol("$");
            currency.setIcon(new ItemStack(Material.GOLD_NUGGET));
            currency.setDecimal(true);
            currency.setVaultEconomy(true);
        });
    }

    @NotNull
    public String getDirectory() {
        return String.valueOf(((CoinsEnginePlugin)this.plugin).getDataFolder()) + "/currencies/";
    }

    @NotNull
    public Map<String, List<TopEntry>> getTotalBalanceMap() {
        return this.totalBalanceMap;
    }

    @NotNull
    public List<TopEntry> getTopBalances(@NotNull Currency currency) {
        return new ArrayList<TopEntry>(this.totalBalanceMap.getOrDefault(currency.getId(), Collections.emptyList()));
    }

    public double getTotalBalance(@NotNull Currency currency) {
        return this.getTopBalances(currency).stream().mapToDouble(TopEntry::balance).sum();
    }

    public void updateBalances() {
        this.totalBalanceMap.clear();
        Map<Currency, Map<String, Double>> balances = ((CoinsEnginePlugin)this.plugin).getData().getBalances();
        balances.forEach((currency, balanceMap) -> {
            AtomicInteger counter = new AtomicInteger(0);
            List entries = this.totalBalanceMap.computeIfAbsent(currency.getId(), k -> new ArrayList());
            Lists.sortDescent((Map)balanceMap).forEach((name, balance) -> entries.add(new TopEntry(counter.incrementAndGet(), (double)balance, (String)name)));
        });
    }

    public void registerCurrency(@NotNull Currency currency) {
        if (this.getCurrency(currency.getId()) != null) {
            ((CoinsEnginePlugin)this.plugin).error("Could not register duplicated currency: '" + currency.getId() + "'!");
            return;
        }
        ((CoinsEnginePlugin)this.plugin).getData().createCurrencyColumn(currency);
        CurrencyCommands.loadForCurrency((CoinsEnginePlugin)this.plugin, currency);
        if (currency.isVaultEconomy() && this.getVaultCurrency().isEmpty()) {
            if (Plugins.hasVault()) {
                VaultHook.setup((CoinsEnginePlugin)this.plugin, currency);
                if (((Boolean)Config.ECONOMY_COMMAND_SHORTCUTS_ENABLED.get()).booleanValue()) {
                    CurrencyCommands.loadForEconomy((CoinsEnginePlugin)this.plugin, currency);
                }
            } else {
                ((CoinsEnginePlugin)this.plugin).error("Found Vault Economy currency, but Vault is not installed!");
            }
        }
        this.currencyMap.put(currency.getId(), currency);
        ((CoinsEnginePlugin)this.plugin).info("Registered: '" + currency.getId() + "' currency!");
    }

    public boolean unregisterCurrency(@NotNull Currency currency) {
        return this.unregisterCurrency(currency.getId());
    }

    public boolean unregisterCurrency(@NotNull String id) {
        Currency currency = this.currencyMap.remove(id);
        if (currency == null) {
            return false;
        }
        CurrencyCommands.unloadForCurrency((CoinsEnginePlugin)this.plugin, currency);
        if (currency.isVaultEconomy()) {
            CurrencyCommands.unloadForEconomy((CoinsEnginePlugin)this.plugin);
        }
        this.totalBalanceMap.remove(id);
        ((CoinsEnginePlugin)this.plugin).info("Currency unregistered: '" + currency.getId() + "'!");
        return true;
    }

    @Nullable
    public Currency getCurrency(@NotNull String id) {
        return this.currencyMap.get(id.toLowerCase());
    }

    @NotNull
    public Map<String, Currency> getCurrencyMap() {
        return this.currencyMap;
    }

    @NotNull
    public List<String> getCurrencyIds() {
        return new ArrayList<String>(this.currencyMap.keySet());
    }

    @NotNull
    public Optional<Currency> getVaultCurrency() {
        return this.getCurrencies().stream().filter(Currency::isVaultEconomy).findFirst();
    }

    @NotNull
    public Collection<Currency> getCurrencies() {
        return new HashSet<Currency>(this.currencyMap.values());
    }

    public boolean createCurrency(@NotNull String id, @NotNull Consumer<ConfigCurrency> consumer) {
        if ((id = StringUtil.lowerCaseUnderscore((String)id)).isEmpty()) {
            return false;
        }
        File file = new File(this.getDirectory(), id + ".yml");
        ConfigCurrency currency = new ConfigCurrency((CoinsEnginePlugin)this.plugin, file);
        currency.setName(StringUtil.capitalizeUnderscored((String)id));
        currency.setFormat("%amount%%currency_symbol%");
        currency.setFormatShort("%currency_symbol%%amount%");
        currency.setCommandAliases(new String[]{id});
        currency.setPermissionRequired(false);
        currency.setTransferAllowed(true);
        currency.setStartValue(0.0);
        currency.setMaxValue(-1.0);
        currency.setExchangeAllowed(true);
        consumer.accept(currency);
        currency.save();
        return true;
    }

    public boolean exchange(@NotNull Player player, @NotNull Currency from, @NotNull Currency to, double initAmount) {
        if (!from.isExchangeAllowed()) {
            from.withPrefix(Lang.CURRENCY_EXCHANGE_ERROR_DISABLED.getMessage()).send((CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()));
            return false;
        }
        CoinsUser user = (CoinsUser)((CoinsEnginePlugin)this.plugin).getUserManager().getOrFetch(player);
        if (user.getBalance(from) < initAmount) {
            from.withPrefix(Lang.CURRENCY_EXCHANGE_ERROR_LOW_BALANCE.getMessage()).send((CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()).replace("%amount%", (Object)from.format(initAmount)));
            return false;
        }
        double rate = from.getExchangeRate(to);
        if (rate <= 0.0) {
            from.withPrefix(Lang.CURRENCY_EXCHANGE_ERROR_NO_RATE.getMessage()).send((CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()).replace("%name%", (Object)to.getName()));
            return false;
        }
        double amount = from.fine(initAmount);
        if (amount <= 0.0) {
            from.withPrefix(Lang.CURRENCY_EXCHANGE_ERROR_LOW_AMOUNT.getMessage()).send((CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()));
            return false;
        }
        double result = to.fine(amount * rate);
        if (result <= 0.0) {
            from.withPrefix(Lang.CURRENCY_EXCHANGE_ERROR_LOW_AMOUNT.getMessage()).send((CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()));
            return false;
        }
        double has = user.getBalance(to) + result;
        if (!to.isUnderLimit(has)) {
            to.withPrefix(Lang.CURRENCY_EXCHANGE_ERROR_LIMIT_EXCEED.getMessage()).send((CommandSender)player, replacer -> replacer.replace("%amount%", (Object)to.format(result)).replace("%max%", (Object)to.format(to.getMaxValue())));
            return false;
        }
        user.removeBalance(from, amount);
        user.addBalance(to, result);
        ((CoinsEnginePlugin)this.plugin).getUserManager().save(user);
        from.withPrefix(Lang.CURRENCY_EXCHANGE_SUCCESS.getMessage()).send((CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()).replace("%balance%", (Object)from.format(amount)).replace("%amount%", (Object)to.format(result)));
        ((CoinsEnginePlugin)this.plugin).getCoinsLogger().logExchange(user, from, to, amount, result);
        return true;
    }
}

