/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.currency.impl;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.db.sql.column.Column;
import su.nightexpress.nightcore.db.sql.column.ColumnType;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.nightcore.util.StringUtil;

public class ConfigCurrency
extends AbstractFileData<CoinsEnginePlugin>
implements Currency {
    private String name;
    private String prefix;
    private String symbol;
    private String format;
    private String formatShort;
    private String columnName;
    private String[] commandAliases;
    private ItemStack icon;
    private Column column;
    private boolean decimal;
    private boolean synchronizable;
    private boolean permissionRequired;
    private boolean transferAllowed;
    private double minTransferAmount;
    private double startValue;
    private double maxValue;
    private boolean vaultEconomy;
    private boolean exchangeAllowed;
    private final Map<String, Double> exchangeRates = new HashMap<String, Double>();

    public ConfigCurrency(@NotNull CoinsEnginePlugin plugin, @NotNull File file) {
        super((NightCorePlugin)plugin, file);
    }

    protected boolean onLoad(@NotNull FileConfig config) {
        this.setName((String)ConfigValue.create((String)"Name", (String)StringUtil.capitalizeUnderscored((String)this.getId()), (String[])new String[]{"Localized currency name.", "Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setPrefix((String)ConfigValue.create((String)"Prefix", (String)this.name, (String[])new String[]{"Sets custom currency prefix.", "Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setSymbol((String)ConfigValue.create((String)"Symbol", (String)this.getName(), (String[])new String[]{"Currency symbol, like '$'.", "Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setFormat((String)ConfigValue.create((String)"Format", (String)"%amount%%currency_symbol%", (String[])new String[]{"Currency display format.", "Use '%amount%' placeholder for amount value.", "You can use 'Currency' placeholders: https://nightexpressdev.com/coinsengine/placeholders/", "You can use PlaceholderAPI placeholders that are NOT bound to a player (e.g. Oraxen or ItemsAdder %img% placeholders)", "Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setFormatShort((String)ConfigValue.create((String)"Format_Short", (String)"%currency_symbol%%amount%", (String[])new String[]{"Currency short display format.", "Use '%amount%' placeholder for amount value.", "You can use PlaceholderAPI placeholders that are NOT bound to a player (e.g. Oraxen or ItemsAdder %img% placeholders)", "You can use 'Currency' placeholders: https://nightexpressdev.com/coinsengine/placeholders/"}).read(config));
        this.setColumnName((String)ConfigValue.create((String)"Column_Name", (String)this.getId(), (String[])new String[]{"Sets database column name for this currency.", "This might be useful for MySQL if you want to use the same currency for multiple servers, but not share their balance.", "=".repeat(15) + " WARNING " + "=".repeat(15), "When chaning this setting, all balances will retain in PREVIOUS column!"}).read(config));
        this.setCommandAliases((String[])ConfigValue.create((String)"Command_Aliases", (String[])new String[]{this.getId()}, (String[])new String[]{"Custom currency commands. Split with commas."}).read(config));
        this.setIcon((ItemStack)ConfigValue.create((String)"Icon", (ItemStack)new ItemStack(Material.GOLD_NUGGET), (String[])new String[]{"Currency icon."}).read(config));
        this.setDecimal((Boolean)ConfigValue.create((String)"Decimal", (boolean)false, (String[])new String[]{"Sets whether or not currency value can have decimals."}).read(config));
        this.setSynchronizable((Boolean)ConfigValue.create((String)"Synchronized", (boolean)true, (String[])new String[]{"Sets whether or not the currency will synchronize balance of online players from the database.", "This setting is useless for SQLite.", "You may want to disable this if you're using this currency on a single server only."}).read(config));
        this.setPermissionRequired((Boolean)ConfigValue.create((String)"Permission_Required", (boolean)false, (String[])new String[]{"Sets whether or not players must have '" + this.getPermission() + "' permission to use this currency."}).read(config));
        this.setTransferAllowed((Boolean)ConfigValue.create((String)"Transfer_Allowed", (boolean)true, (String[])new String[]{"Sets whether or not players can send this currency to other players."}).read(config));
        this.setMinTransferAmount((Double)ConfigValue.create((String)"Transfer_Min_Amount", (double)1.0, (String[])new String[]{"Sets minimal amount for sending this currency to other players.", "Set this to '-1' for no limit."}).read(config));
        this.setStartValue((Double)ConfigValue.create((String)"Start_Value", (double)0.0, (String[])new String[]{"How much of this currency new players will have on their balance?"}).read(config));
        this.setMaxValue((Double)ConfigValue.create((String)"Max_Value", (double)-1.0, (String[])new String[]{"Max. possible value that players can have on their balance.", "Set this to '-1' to disable."}).read(config));
        this.setVaultEconomy((Boolean)ConfigValue.create((String)"Economy.Vault", (boolean)false, (String[])new String[]{"When enabled, uses the Vault API to register the currency as primary server Economy."}).read(config));
        this.setExchangeAllowed((Boolean)ConfigValue.create((String)"Exchange.Allowed", (boolean)true, (String[])new String[]{"Sets whether or not this currency can be exchanged for other ones."}).read(config));
        if (config.getSection("Exchange.Rates").isEmpty()) {
            config.set("Exchange.Rates.your_currency_name", (Object)5);
            config.set("Exchange.Rates.other_currency_name", (Object)10);
        }
        config.getSection("Exchange.Rates").forEach(sId -> {
            double rate = config.getDouble("Exchange.Rates." + sId);
            this.exchangeRates.put(sId.toLowerCase(), rate);
        });
        return true;
    }

    protected void onSave(@NotNull FileConfig config) {
        config.set("Name", (Object)this.getName());
        config.set("Prefix", (Object)this.prefix);
        config.set("Symbol", (Object)this.getSymbol());
        config.set("Format", (Object)this.getFormat());
        config.set("Format_Short", (Object)this.getFormatShort());
        config.set("Column_Name", (Object)this.getColumnName());
        config.set("Command_Aliases", (Object)String.join((CharSequence)",", Arrays.asList(this.getCommandAliases())));
        config.setItem("Icon", this.getIcon());
        config.set("Decimal", (Object)this.isDecimal());
        config.set("Synchronized", (Object)this.isSynchronizable());
        config.set("Permission_Required", (Object)this.isPermissionRequired());
        config.set("Transfer_Allowed", (Object)this.isTransferAllowed());
        config.set("Transfer_Min_Amount", (Object)this.getMinTransferAmount());
        config.set("Start_Value", (Object)this.getStartValue());
        config.set("Max_Value", (Object)this.getMaxValue());
        config.set("Economy.Vault", (Object)this.isVaultEconomy());
        config.set("Exchange.Allowed", (Object)this.isExchangeAllowed());
        config.remove("Exchange.Rates");
        this.getExchangeRates().forEach((id, rate) -> config.set("Exchange.Rates." + id, rate));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(@NotNull String prefix) {
        this.prefix = prefix;
    }

    @Override
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(@NotNull String symbol) {
        this.symbol = symbol;
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@NotNull String format) {
        this.format = format;
    }

    @Override
    @NotNull
    public String getFormatShort() {
        return this.formatShort;
    }

    @Override
    public void setFormatShort(@NotNull String formatShort) {
        this.formatShort = formatShort.replace("%currency_short_symbol%", "");
    }

    @Override
    @NotNull
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void setColumnName(@NotNull String columnName) {
        this.columnName = columnName;
        this.column = Column.of((String)this.columnName, (ColumnType)ColumnType.DOUBLE);
    }

    @Override
    @NotNull
    public String[] getCommandAliases() {
        return this.commandAliases;
    }

    @Override
    public void setCommandAliases(String[] commandAliases) {
        this.commandAliases = commandAliases;
    }

    @Override
    @NotNull
    public Column getColumn() {
        return this.column;
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return new ItemStack(this.icon);
    }

    @Override
    public void setIcon(@NotNull ItemStack icon) {
        this.icon = new ItemStack(icon);
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    @Override
    public void setDecimal(boolean decimal) {
        this.decimal = decimal;
    }

    @Override
    public boolean isSynchronizable() {
        return this.synchronizable;
    }

    @Override
    public void setSynchronizable(boolean synchronizable) {
        this.synchronizable = synchronizable;
    }

    @Override
    public boolean isPermissionRequired() {
        return this.permissionRequired;
    }

    @Override
    public void setPermissionRequired(boolean permissionRequired) {
        this.permissionRequired = permissionRequired;
    }

    @Override
    public boolean isTransferAllowed() {
        return this.transferAllowed;
    }

    @Override
    public void setTransferAllowed(boolean transferAllowed) {
        this.transferAllowed = transferAllowed;
    }

    @Override
    public double getMinTransferAmount() {
        return this.minTransferAmount;
    }

    @Override
    public void setMinTransferAmount(double minTransferAmount) {
        this.minTransferAmount = minTransferAmount;
    }

    @Override
    public double getStartValue() {
        return this.startValue;
    }

    @Override
    public void setStartValue(double startValue) {
        this.startValue = startValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public boolean isVaultEconomy() {
        return this.vaultEconomy;
    }

    @Override
    public void setVaultEconomy(boolean vaultEconomy) {
        this.vaultEconomy = vaultEconomy;
    }

    @Override
    public boolean isExchangeAllowed() {
        return this.exchangeAllowed;
    }

    @Override
    public void setExchangeAllowed(boolean exchangeAllowed) {
        this.exchangeAllowed = exchangeAllowed;
    }

    @Override
    @NotNull
    public Map<String, Double> getExchangeRates() {
        return this.exchangeRates;
    }
}

