/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.data.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.api.event.ChangeBalanceEvent;
import su.nightexpress.coinsengine.data.impl.CurrencySettings;
import su.nightexpress.nightcore.db.AbstractUser;

public class CoinsUser
extends AbstractUser {
    private final Map<String, Double> balanceMap;
    private final Map<String, CurrencySettings> settingsMap;

    @NotNull
    public static CoinsUser create(@NotNull CoinsEnginePlugin plugin, @NotNull UUID uuid, @NotNull String name) {
        long dateCreated = System.currentTimeMillis();
        HashMap<String, Double> balanceMap = new HashMap<String, Double>();
        for (Currency currency : plugin.getCurrencyManager().getCurrencies()) {
            balanceMap.put(currency.getId(), currency.getStartValue());
        }
        HashMap<String, CurrencySettings> settingsMap = new HashMap<String, CurrencySettings>();
        return new CoinsUser(plugin, uuid, name, dateCreated, dateCreated, balanceMap, settingsMap);
    }

    public CoinsUser(@NotNull CoinsEnginePlugin plugin, @NotNull UUID uuid, @NotNull String name, long dateCreated, long lastLogin, @NotNull Map<String, Double> balanceMap, @NotNull Map<String, CurrencySettings> settingsMap) {
        super(uuid, name, dateCreated, lastLogin);
        this.balanceMap = new HashMap<String, Double>(balanceMap);
        this.settingsMap = new HashMap<String, CurrencySettings>(settingsMap);
    }

    @NotNull
    public Map<String, Double> getBalanceMap() {
        return this.balanceMap;
    }

    @NotNull
    public Map<String, CurrencySettings> getSettingsMap() {
        return this.settingsMap;
    }

    public void resetBalance() {
        CoinsEngineAPI.getCurrencyManager().getCurrencies().forEach(this::resetBalance);
    }

    public void resetBalance(@NotNull Currency currency) {
        this.setBalance(currency, currency.getStartValue());
    }

    public double getBalance(@NotNull Currency currency) {
        return this.balanceMap.computeIfAbsent(currency.getId(), k -> 0.0);
    }

    public void addBalance(@NotNull Currency currency, double amount) {
        this.changeBalance(currency, this.getBalance(currency) + Math.abs(amount));
    }

    public void removeBalance(@NotNull Currency currency, double amount) {
        this.changeBalance(currency, this.getBalance(currency) - Math.abs(amount));
    }

    public void setBalance(@NotNull Currency currency, double amount) {
        this.changeBalance(currency, Math.abs(amount));
    }

    private void changeBalance(@NotNull Currency currency, double amount) {
        amount = Math.max(0.0, amount);
        double oldBalance = this.getBalance(currency);
        this.balanceMap.put(currency.getId(), currency.fineAndLimit(amount));
        ChangeBalanceEvent changeBalanceEvent = new ChangeBalanceEvent(this, currency, oldBalance, this.getBalance(currency));
        Bukkit.getPluginManager().callEvent((Event)changeBalanceEvent);
    }

    @NotNull
    public CurrencySettings getSettings(@NotNull Currency currency) {
        return this.settingsMap.computeIfAbsent(currency.getId(), k -> CurrencySettings.create(currency));
    }
}

