/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.hook;

import net.zithium.deluxecoinflip.api.DeluxeCoinflipAPI;
import net.zithium.deluxecoinflip.economy.provider.EconomyProvider;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.data.impl.CoinsUser;

public class DeluxeCoinflipHook {
    public static void setup(@NotNull CoinsEnginePlugin plugin) {
        DeluxeCoinflipAPI api = (DeluxeCoinflipAPI)plugin.getPluginManager().getPlugin("DeluxeCoinflip");
        if (api == null) {
            return;
        }
        plugin.getCurrencyManager().getCurrencies().forEach(currency -> {
            Provider provider = new Provider(plugin, (Currency)currency);
            api.registerEconomyProvider((EconomyProvider)provider, plugin.getName());
        });
    }

    public static void shutdown() {
    }

    private static class Provider
    extends EconomyProvider {
        private final CoinsEnginePlugin plugin;
        private final Currency currency;

        public Provider(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency) {
            super("coinsengine_" + currency.getId());
            this.plugin = plugin;
            this.currency = currency;
        }

        public void onEnable() {
        }

        @Nullable
        private CoinsUser getUser(@NotNull OfflinePlayer offlinePlayer) {
            return (CoinsUser)this.plugin.getUserManager().getOrFetch(offlinePlayer.getUniqueId());
        }

        public double getBalance(OfflinePlayer offlinePlayer) {
            CoinsUser user = this.getUser(offlinePlayer);
            return user == null ? 0.0 : user.getBalance(this.currency);
        }

        public void withdraw(OfflinePlayer offlinePlayer, double v) {
            CoinsUser user = this.getUser(offlinePlayer);
            if (user != null) {
                user.removeBalance(this.currency, v);
                this.plugin.getUserManager().save(user);
            }
        }

        public void deposit(OfflinePlayer offlinePlayer, double v) {
            CoinsUser user = this.getUser(offlinePlayer);
            if (user != null) {
                user.addBalance(this.currency, v);
                this.plugin.getUserManager().save(user);
            }
        }

        public String getDisplayName() {
            return this.currency.getName();
        }
    }
}

