/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.hook;

import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.util.TopEntry;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.text.NightMessage;

public class PlaceholderAPIHook {
    private static Expansion expansion;

    public static void setup(@NotNull CoinsEnginePlugin plugin) {
        if (expansion == null) {
            expansion = new Expansion(plugin);
            expansion.register();
        }
    }

    public static void shutdown() {
        if (expansion != null) {
            expansion.unregister();
            expansion = null;
        }
    }

    private static class Expansion
    extends PlaceholderExpansion {
        private static final DecimalFormat RAW_FORMAT = new DecimalFormat("#");
        private final CoinsEnginePlugin plugin;
        private final Map<String, BiFunction<Player, Currency, String>> placeholders;

        public Expansion(@NotNull CoinsEnginePlugin plugin) {
            this.plugin = plugin;
            this.placeholders = new LinkedHashMap<String, BiFunction<Player, Currency, String>>();
            this.placeholders.put("server_balance_raw", (player, currency) -> RAW_FORMAT.format(plugin.getCurrencyManager().getTotalBalance((Currency)currency)));
            this.placeholders.put("server_balance_short_plain", (player, currency) -> currency.formatCompact(plugin.getCurrencyManager().getTotalBalance((Currency)currency)));
            this.placeholders.put("server_balance_short", (player, currency) -> NightMessage.asLegacy((String)currency.formatCompact(plugin.getCurrencyManager().getTotalBalance((Currency)currency))));
            this.placeholders.put("server_balance_plain", (player, currency) -> currency.format(plugin.getCurrencyManager().getTotalBalance((Currency)currency)));
            this.placeholders.put("server_balance", (player, currency) -> NightMessage.asLegacy((String)currency.format(plugin.getCurrencyManager().getTotalBalance((Currency)currency))));
            this.placeholders.put("payments_state", (player, currency) -> this.handleUserCurrency((Player)player, user -> NightMessage.asLegacy((String)Lang.getEnabledOrDisabled((boolean)user.getSettings((Currency)currency).isPaymentsEnabled()))));
            this.placeholders.put("balance_raw", (player, currency) -> this.handleUserCurrency((Player)player, user -> RAW_FORMAT.format(currency.fine(user.getBalance((Currency)currency)))));
            this.placeholders.put("balance_rounded", (player, currency) -> this.handleUserCurrency((Player)player, user -> NumberUtil.format((double)currency.fine(user.getBalance((Currency)currency)))));
            this.placeholders.put("balance_short_plain", (player, currency) -> this.handleUserCurrency((Player)player, user -> currency.formatCompact(user.getBalance((Currency)currency))));
            this.placeholders.put("balance_short", (player, currency) -> this.handleUserCurrency((Player)player, user -> NightMessage.asLegacy((String)currency.formatCompact(user.getBalance((Currency)currency)))));
            this.placeholders.put("balance_plain", (player, currency) -> this.handleUserCurrency((Player)player, user -> currency.format(user.getBalance((Currency)currency))));
            this.placeholders.put("balance", (player, currency) -> this.handleUserCurrency((Player)player, user -> NightMessage.asLegacy((String)currency.format(user.getBalance((Currency)currency)))));
        }

        @NotNull
        public String getAuthor() {
            return (String)this.plugin.getDescription().getAuthors().getFirst();
        }

        @NotNull
        public String getIdentifier() {
            return this.plugin.getDescription().getName().toLowerCase();
        }

        @NotNull
        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        public boolean persist() {
            return true;
        }

        public String onPlaceholderRequest(Player player, @NotNull String params) {
            if (params.startsWith("top_")) {
                String cut = params.substring("top_".length());
                String[] split = cut.split("_");
                if (split.length < 3) {
                    return null;
                }
                String type = split[0];
                String currencyId = split[1];
                Currency currency = this.plugin.getCurrencyManager().getCurrency(currencyId);
                if (currency == null) {
                    return null;
                }
                int pos = NumberUtil.getIntegerAbs((String)split[2]);
                if (pos <= 0) {
                    return null;
                }
                List<TopEntry> baltop = this.plugin.getCurrencyManager().getTopBalances(currency);
                if (pos > baltop.size()) {
                    return "-";
                }
                TopEntry entry = baltop.get(pos - 1);
                if (type.equalsIgnoreCase("balance-short")) {
                    return NightMessage.asLegacy((String)currency.formatCompact(entry.balance()));
                }
                if (type.equalsIgnoreCase("balance-short-plain")) {
                    return currency.formatCompact(entry.balance());
                }
                if (type.equalsIgnoreCase("balance-plain")) {
                    return currency.format(entry.balance());
                }
                if (type.equalsIgnoreCase("balance")) {
                    return NightMessage.asLegacy((String)currency.format(entry.balance()));
                }
                if (type.equalsIgnoreCase("player")) {
                    return entry.name();
                }
                return null;
            }
            if (player == null) {
                return "";
            }
            for (Map.Entry<String, BiFunction<Player, Currency, String>> entry : this.placeholders.entrySet()) {
                String prefix = entry.getKey() + "_";
                if (!params.startsWith(prefix)) continue;
                String currencyId = params.substring(prefix.length());
                Currency currency = this.plugin.getCurrencyManager().getCurrency(currencyId);
                if (currency == null) continue;
                return entry.getValue().apply(player, currency);
            }
            return null;
        }

        @Nullable
        private String handleUserCurrency(@NotNull Player player, @NotNull Function<CoinsUser, String> function) {
            CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player);
            return function.apply(user);
        }

        static {
            RAW_FORMAT.setMaximumFractionDigits(8);
        }
    }
}

