/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.hook.vault;

import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.data.impl.CoinsUser;

public class CurrencyEconomy
extends AbstractEconomy {
    private final CoinsEnginePlugin plugin;
    private final Currency currency;

    public CurrencyEconomy(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency) {
        this.plugin = plugin;
        this.currency = currency;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return this.plugin.getName() + "_" + this.currency.getId();
    }

    public String format(double amount) {
        return this.currency.format(amount);
    }

    public int fractionalDigits() {
        return -1;
    }

    public String currencyNamePlural() {
        return this.currency.getName();
    }

    public String currencyNameSingular() {
        return this.currency.getName();
    }

    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public double getBalance(OfflinePlayer player) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        return user == null ? 0.0 : user.getBalance(this.currency);
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(String playerName) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        return user == null ? 0.0 : user.getBalance(this.currency);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.plugin.getData().isUserExists(player.getUniqueId());
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(String playerName) {
        return this.plugin.getData().isUserExists(playerName);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        return user != null && user.getBalance(this.currency) >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(String playerName, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        return user != null && user.getBalance(this.currency) >= amount;
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        if (user == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INVALID_PLAYER.getLegacy());
        }
        user.addBalance(this.currency, amount);
        this.plugin.getUserManager().save(user);
        double balance = user.getBalance(this.currency);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        if (user == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INVALID_PLAYER.getLegacy());
        }
        user.addBalance(this.currency, amount);
        this.plugin.getUserManager().save(user);
        double balance = user.getBalance(this.currency);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        if (user == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INVALID_PLAYER.getLegacy());
        }
        if (user.getBalance(this.currency) < amount) {
            return new EconomyResponse(amount, user.getBalance(this.currency), EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INSUFFICIENT_FUNDS.getLegacy());
        }
        user.removeBalance(this.currency, amount);
        this.plugin.getUserManager().save(user);
        double balance = user.getBalance(this.currency);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        if (user == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INVALID_PLAYER.getLegacy());
        }
        if (user.getBalance(this.currency) < amount) {
            return new EconomyResponse(amount, user.getBalance(this.currency), EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INSUFFICIENT_FUNDS.getLegacy());
        }
        user.removeBalance(this.currency, amount);
        this.plugin.getUserManager().save(user);
        double balance = user.getBalance(this.currency);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean hasBankSupport() {
        return false;
    }
}

