/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.migration.MigrationPlugin;
import su.nightexpress.coinsengine.migration.impl.PlayerPointsPlugin;
import su.nightexpress.coinsengine.migration.impl.VaultPlugin;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.Plugins;

public class MigrationManager
extends SimpleManager<CoinsEnginePlugin> {
    private final Map<String, MigrationPlugin> pluginMap = new HashMap<String, MigrationPlugin>();

    public MigrationManager(@NotNull CoinsEnginePlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.registerMigrator("PlayerPoints", () -> new PlayerPointsPlugin((CoinsEnginePlugin)this.plugin));
        this.registerMigrator("Vault", () -> new VaultPlugin((CoinsEnginePlugin)this.plugin));
    }

    protected void onShutdown() {
    }

    public boolean registerMigrator(@NotNull String name, @NotNull Supplier<MigrationPlugin> supplier) {
        if (!Plugins.isInstalled((String)name)) {
            return false;
        }
        MigrationPlugin migrationPlugin = supplier.get();
        this.pluginMap.put(migrationPlugin.getPluginName().toLowerCase(), migrationPlugin);
        ((CoinsEnginePlugin)this.plugin).info("Detected plugin available for data migration: " + migrationPlugin.getPluginName());
        return true;
    }

    public boolean migrate(@NotNull String pluginName, @NotNull Currency currency) {
        MigrationPlugin migrationPlugin = this.getPlugin(pluginName);
        if (migrationPlugin == null) {
            return false;
        }
        this.migrate(migrationPlugin, currency);
        return true;
    }

    public void migrate(@NotNull MigrationPlugin migrationPlugin, @NotNull Currency currency) {
        Map<OfflinePlayer, Double> balances = migrationPlugin.getBalances(currency);
        balances.forEach((player, points) -> {
            String name = player.getName();
            if (name == null) {
                return;
            }
            UUID uuid = player.getUniqueId();
            CoinsUser user = (CoinsUser)((CoinsEnginePlugin)this.plugin).getUserManager().getOrFetch(uuid);
            if (user == null) {
                user = CoinsUser.create((CoinsEnginePlugin)this.plugin, uuid, name);
                ((CoinsEnginePlugin)this.plugin).getData().insertUser(user);
            }
            user.setBalance(currency, (double)points);
            ((CoinsEnginePlugin)this.plugin).getUserManager().save(user);
        });
    }

    @NotNull
    public List<String> getMigrationPluginNames() {
        return new ArrayList<String>(this.getPluginMap().keySet());
    }

    @NotNull
    public Map<String, MigrationPlugin> getPluginMap() {
        return this.pluginMap;
    }

    @Nullable
    public MigrationPlugin getPlugin(@NotNull String name) {
        return this.getPluginMap().get(name.toLowerCase());
    }
}

