/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.migration.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.manager.DataManager;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.migration.MigrationPlugin;

public class PlayerPointsPlugin
extends MigrationPlugin {
    public PlayerPointsPlugin(@NotNull CoinsEnginePlugin plugin) {
        super(plugin, "PlayerPoints");
    }

    @Override
    @NotNull
    public Map<OfflinePlayer, Double> getBalances(@NotNull Currency currency) {
        HashMap<OfflinePlayer, Double> balances = new HashMap<OfflinePlayer, Double>();
        PlayerPoints playerPoints = (PlayerPoints)this.getBackendPlugin();
        if (playerPoints == null) {
            return balances;
        }
        HashMap<UUID, Integer> pointsMap = new HashMap<UUID, Integer>();
        DataManager dataManager = (DataManager)playerPoints.getManager(DataManager.class);
        try {
            dataManager.getDatabaseConnector().connect(connection -> {
                String query = "SELECT * FROM " + dataManager.getTablePrefix() + "points";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(query);
                while (resultSet.next()) {
                    UUID uuid = UUID.fromString(resultSet.getString("uuid"));
                    int points = resultSet.getInt("points");
                    pointsMap.put(uuid, points);
                }
                statement.close();
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        pointsMap.forEach((id, balance) -> {
            OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(id);
            balances.put(offlinePlayer, Double.valueOf(balance.intValue()));
        });
        return balances;
    }
}

