/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.nightcore.util.Colorizer;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.text.NightMessage;

public class CoinsLogger {
    private final CoinsEnginePlugin plugin;

    public CoinsLogger(@NotNull CoinsEnginePlugin plugin) {
        this.plugin = plugin;
    }

    public void logSend(@NotNull CoinsUser target, @NotNull Currency currency, double amount, @NotNull CommandSender from) {
        String text = from.getName() + " sent " + currency.formatValue(amount) + " " + currency.getName() + " to " + target.getName() + ". New balance: " + currency.format(target.getBalance(currency));
        this.log(text);
    }

    public void logGive(@NotNull CoinsUser user, @NotNull Currency currency, double amount, @NotNull CommandSender from) {
        String text = user.getName() + " received " + currency.formatValue(amount) + " " + currency.getName() + " from " + from.getName() + ". New balance: " + currency.format(user.getBalance(currency));
        this.log(text);
    }

    public void logSet(@NotNull CoinsUser user, @NotNull Currency currency, double amount, @NotNull CommandSender from) {
        String text = user.getName() + "'s " + currency.getName() + " balance set to " + currency.formatValue(amount) + " by " + from.getName() + ". New balance: " + currency.format(user.getBalance(currency));
        this.log(text);
    }

    public void logTake(@NotNull CoinsUser user, @NotNull Currency currency, double amount, @NotNull CommandSender from) {
        String text = user.getName() + " lost " + currency.formatValue(amount) + " " + currency.getName() + " by " + from.getName() + ". New balance: " + currency.format(user.getBalance(currency));
        this.log(text);
    }

    public void logExchange(@NotNull CoinsUser user, @NotNull Currency from, @NotNull Currency to, double amount, double result) {
        String text = user.getName() + " exchanged x" + NumberUtil.format((double)amount) + " " + from.getName() + " to x" + NumberUtil.format((double)result) + " " + to.getName() + ". New balance: " + from.format(user.getBalance(from)) + " and " + to.format(user.getBalance(to));
        this.log(text);
    }

    private void log(@NotNull String text) {
        if (!((Boolean)Config.LOGS_TO_CONSOLE.get()).booleanValue() && !((Boolean)Config.LOGS_TO_FILE.get()).booleanValue()) {
            return;
        }
        text = Colorizer.restrip((String)NightMessage.asLegacy((String)text));
        if (((Boolean)Config.LOGS_TO_CONSOLE.get()).booleanValue()) {
            this.plugin.info(text);
        }
        if (((Boolean)Config.LOGS_TO_FILE.get()).booleanValue()) {
            String date = LocalDateTime.now().format((DateTimeFormatter)Config.LOGS_DATE_FORMAT.get());
            String path = String.valueOf(this.plugin.getDataFolder()) + "/operations.log";
            try {
                BufferedWriter output = new BufferedWriter(new FileWriter(path, true));
                output.append("[").append(date).append("] ").append(text);
                output.newLine();
                output.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }
}

