/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.currency;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;

public class CommandVariant
implements Writeable {
    private final boolean enabled;
    private final String[] aliases;

    public CommandVariant(boolean enabled, String[] aliases) {
        this.enabled = enabled;
        this.aliases = aliases;
    }

    @NotNull
    public static CommandVariant enabled(String ... aliases) {
        return new CommandVariant(true, aliases);
    }

    @NotNull
    public static CommandVariant disabled(String ... aliases) {
        return new CommandVariant(false, aliases);
    }

    @NotNull
    public static CommandVariant read(@NotNull FileConfig config, @NotNull String path) {
        boolean enabled = (Boolean)ConfigValue.create((String)(path + ".Enabled"), (boolean)false, (String[])new String[0]).read(config);
        String[] aliases = config.getStringArray(path + ".Aliases");
        return new CommandVariant(enabled, aliases);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Enabled", (Object)this.enabled);
        config.setStringArray(path + ".Aliases", this.aliases);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

