/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.currency;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.OperationResult;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.nightcore.util.TimeUtil;

public class CurrencyLogger {
    private final BlockingQueue<OperationResult> queue = new LinkedBlockingQueue<OperationResult>();
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern((String)Config.LOGS_DATE_FORMAT.get());
    private final BufferedWriter writer;
    private boolean running;

    public CurrencyLogger(@NotNull CoinsEnginePlugin plugin) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(String.valueOf(plugin.getDataFolder()) + "/operations.log", true));
        this.running = true;
    }

    public void shutdown() {
        this.running = false;
        this.queue.clear();
        try {
            this.writer.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void addOperation(@NotNull OperationResult result) {
        this.queue.add(result);
    }

    public void write() {
        try {
            while (this.running && !this.queue.isEmpty()) {
                OperationResult result = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                if (result == null) continue;
                String date = TimeUtil.getLocalDateTimeOf((long)result.getTimestamp()).format(this.timeFormatter);
                this.writer.append("[").append(date).append("] ").append(result.getLog());
                this.writer.newLine();
                this.writer.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

