/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.tops.menu;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.tops.TopEntry;
import su.nightexpress.coinsengine.tops.TopManager;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class TopMenu
extends LinkedMenu<CoinsEnginePlugin, Currency>
implements Filled<TopEntry>,
ConfigBased {
    private final TopManager topManager;
    private String entryName;
    private List<String> entryLore;
    private int[] entrySlots;

    public TopMenu(@NotNull CoinsEnginePlugin plugin, @NotNull TopManager topManager) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Tags.BLACK.wrap("Balance Top - %currency_name%"));
        this.topManager = topManager;
    }

    @NotNull
    public MenuFiller<TopEntry> createFiller(@NotNull MenuViewer viewer) {
        Player player = viewer.getPlayer();
        Currency currency = (Currency)this.getLink(player);
        return MenuFiller.builder((Filled)this).setSlots(this.entrySlots).setItems(this.topManager.getTopEntries(currency)).setItemCreator(entry -> NightItem.fromType((Material)Material.PLAYER_HEAD).hideAllComponents().setDisplayName(this.entryName).setLore(this.entryLore).setPlayerProfile(entry.getProfile()).replacement(replacer -> replacer.replace("%pos%", (Object)entry.getPosition()).replace("%player_name%", (Object)entry.getName()).replace("%balance%", (Object)currency.format(entry.getBalance())))).build();
    }

    @NotNull
    protected String getTitle(@NotNull MenuViewer viewer) {
        Currency currency = (Currency)this.getLink(viewer);
        return (String)currency.replacePlaceholders().apply(super.getTitle(viewer));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        this.entryName = (String)ConfigValue.create((String)"Entry.Name", (String)(Tags.YELLOW.wrap("#%pos%") + " " + Tags.WHITE.wrap("%player_name%")), (String[])new String[0]).read(config);
        this.entryLore = (List)ConfigValue.create((String)"Entry.Lore", (List)Lists.newList((Object[])new String[]{Tags.GREEN.wrap("%balance%")}), (String[])new String[0]).read(config);
        this.entrySlots = (int[])ConfigValue.create((String)"Entry.Slots", (int[])IntStream.range(0, 36).toArray(), (String[])new String[0]).read(config);
        loader.addDefaultItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setSlots(IntStream.range(36, 45).toArray()));
        loader.addDefaultItem(MenuItem.buildNextPage((Menu)this, (int)44).setPriority(10));
        loader.addDefaultItem(MenuItem.buildPreviousPage((Menu)this, (int)36).setPriority(10));
        loader.addDefaultItem(MenuItem.buildExit((Menu)this, (int)40).setPriority(10));
    }
}

