/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement;

import dev.xylonity.explosiveenhancement.ExplosiveEnhancement;
import dev.xylonity.explosiveenhancement.config.ExplosiveValues;
import dev.xylonity.explosiveenhancement.registry.ExplosiveParticles;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class ExplosiveHandler {
    public static void spawnParticles(ServerLevel world, double x, double y, double z, float power, boolean isUnderWater, boolean didDestroyBlocks, boolean isImportant) {
        if (ExplosiveValues.debugLogs) {
            ExplosiveEnhancement.LOGGER.info("ExplosiveHandler has been called!");
        }
        if (isUnderWater) {
            power = ExplosiveValues.dynamicUnderwater ? power : 4.0f;
        } else {
            float f = power = ExplosiveValues.dynamicSize ? power : 4.0f;
        }
        if (ExplosiveValues.attemptBetterSmallExplosions && power == 1.0f) {
            y += ExplosiveValues.smallExplosionYOffset;
        }
        isImportant = isImportant || ExplosiveValues.alwaysShow;
        float blastwavePower = power * 1.75f;
        float fireballPower = power * 1.25f;
        float smokePower = power * 0.4f;
        boolean COUNT_DIRECTIONAL = false;
        double SPEED = 1.0;
        boolean finalIsImportant = isImportant;
        boolean finalIsImportant1 = isImportant;
        double finalY = y;
        BiConsumer<ParticleOptions, Vec3> send = (type, vel) -> world.sendParticles(type, finalIsImportant, finalIsImportant1, x, finalY, z, 0, vel.x, vel.y, vel.z, 1.0);
        if (isUnderWater) {
            if (ExplosiveValues.showUnderwaterBlastWave) {
                send.accept((ParticleOptions)ExplosiveParticles.UNDERWATERBLASTWAVE.get(), new Vec3((double)blastwavePower, 0.0, 0.0));
            }
            if (ExplosiveValues.showShockwave) {
                send.accept((ParticleOptions)ExplosiveParticles.SHOCKWAVE.get(), new Vec3((double)fireballPower, isImportant ? 1.0 : 0.0, 0.0));
            } else if (ExplosiveValues.showUnderwaterSparks) {
                send.accept((ParticleOptions)ExplosiveParticles.BLANK_SHOCKWAVE.get(), new Vec3((double)fireballPower, isImportant ? 1.0 : 0.0, 0.0));
            }
            for (int i = 0; i < ExplosiveValues.bubbleAmount; ++i) {
                Vec3 v = new Vec3((double)ExplosiveHandler.nextBetween(-7, 7) * 0.3, (double)ExplosiveHandler.nextBetween(1, 10) * 0.1, (double)ExplosiveHandler.nextBetween(-7, 7) * 0.3);
                send.accept((ParticleOptions)ExplosiveParticles.BUBBLE.get(), v);
            }
            if (ExplosiveValues.showDefaultExplosionUnderwater) {
                ExplosiveHandler.showDefaultParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
            }
        } else {
            if (ExplosiveValues.debugLogs) {
                ExplosiveEnhancement.LOGGER.info("Particle is being shown!");
            }
            if (ExplosiveValues.showBlastWave) {
                send.accept((ParticleOptions)ExplosiveParticles.BLASTWAVE.get(), new Vec3((double)blastwavePower, 0.0, 0.0));
            }
            if (ExplosiveValues.showFireball) {
                send.accept((ParticleOptions)ExplosiveParticles.FIREBALL.get(), new Vec3((double)fireballPower, isImportant ? 1.0 : 0.0, 0.0));
            } else if (ExplosiveValues.showSparks) {
                send.accept((ParticleOptions)ExplosiveParticles.BLANK_FIREBALL.get(), new Vec3((double)fireballPower, isImportant ? 1.0 : 0.0, 0.0));
            }
            if (ExplosiveValues.showMushroomCloud) {
                send.accept((ParticleOptions)ExplosiveParticles.SMOKE.get(), new Vec3((double)power, (double)smokePower, 0.0));
                send.accept((ParticleOptions)ExplosiveParticles.SMOKE.get(), new Vec3((double)power, (double)power * 0.25, 0.0));
                send.accept((ParticleOptions)ExplosiveParticles.SMOKE.get(), new Vec3(0.15, (double)smokePower, (double)power));
                send.accept((ParticleOptions)ExplosiveParticles.SMOKE.get(), new Vec3(-0.15, (double)smokePower, (double)power));
                send.accept((ParticleOptions)ExplosiveParticles.SMOKE.get(), new Vec3((double)power, (double)smokePower, 0.15));
                send.accept((ParticleOptions)ExplosiveParticles.SMOKE.get(), new Vec3((double)power, (double)smokePower, -0.15));
            }
            if (ExplosiveValues.showDefaultExplosion) {
                ExplosiveHandler.showDefaultParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
            }
        }
        if (ExplosiveValues.debugLogs) {
            ExplosiveEnhancement.LOGGER.info("Particle finished!");
        }
    }

    private static void showDefaultParticles(ServerLevel world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        SimpleParticleType type = !(power < 2.0f) && didDestroyBlocks ? ParticleTypes.EXPLOSION_EMITTER : ParticleTypes.EXPLOSION;
        world.sendParticles((ParticleOptions)type, isImportant, isImportant, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static int nextBetween(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }
}

