/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement.particle.custom;

import dev.xylonity.explosiveenhancement.config.ExplosiveValues;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UnderwaterSparksParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    UnderwaterSparksParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y, z);
        this.sprites = sprites;
        this.lifetime = (int)(5.0 + Math.floor(velX / 5.0));
        this.quadSize = velX == 0.0 ? (float)ExplosiveValues.underwaterSparkSize : (float)(ExplosiveValues.underwaterSparkSize * (velX * 0.25));
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.alpha = (float)ExplosiveValues.underwaterSparkOpacity;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.setSpriteFromAge(this.sprites);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float pPartialTick) {
        return ExplosiveValues.emissiveWaterExplosion ? 0xF000F0 : super.getLightColor(pPartialTick);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new UnderwaterSparksParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

