/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.epicpix.msg_encryption.MsgEncryptionMod;
import dev.epicpix.msg_encryption.NotificationHandler;
import dev.epicpix.msg_encryption.api.ClientState;
import dev.epicpix.msg_encryption.api.DirectConnection;
import dev.epicpix.msg_encryption.api.DirectConnectionPurpose;
import dev.epicpix.msg_encryption.api.DirectConnectionState;
import dev.epicpix.msg_encryption.api.GroupConnection;
import dev.epicpix.msg_encryption.api.IMessageHandler;
import dev.epicpix.msg_encryption.api.MsgEncryptionAPI;
import dev.epicpix.msg_encryption.api.Participant;
import dev.epicpix.msg_encryption.api.PeerTransportFormat;
import dev.epicpix.msg_encryption.api.PendingGroupConnection;
import dev.epicpix.msg_encryption.api.PendingGroupConnectionData;
import dev.epicpix.msg_encryption.api.PendingGroupKey;
import dev.epicpix.msg_encryption.api.PlayerStatus;
import dev.epicpix.msg_encryption.api.TransportFormat;
import dev.epicpix.msg_encryption.api.packet.AuthFailureResponsePacket;
import dev.epicpix.msg_encryption.api.packet.AuthRequestPacket;
import dev.epicpix.msg_encryption.api.packet.AuthSuccessResponsePacket;
import dev.epicpix.msg_encryption.api.packet.ClientStatePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionClosePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionCreateFailureResponsePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionCreateRequestPacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionCreateSuccessResponsePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionDataPacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionSendDataPacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionSendGroupDataPacket;
import dev.epicpix.msg_encryption.api.packet.HeartbeatPacket;
import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PlayerStatusRequestPacket;
import dev.epicpix.msg_encryption.api.packet.PlayerStatusResponsePacket;
import dev.epicpix.msg_encryption.api.packet.PrepareConnectionPacket;
import dev.epicpix.msg_encryption.stats.ConnectionStats;
import dev.epicpix.msg_encryption.stats.MessageHandlerStats;
import io.netty.util.collection.IntObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.codec.digest.DigestUtils;

public class MessageHandler
implements IMessageHandler {
    private static final Gson GSON = new Gson();
    private Socket socket;
    private DataOutputStream output;
    private boolean isReconnecting;
    private int totalEncryptedSentBytes = 0;
    private int totalEncryptedRecvBytes = 0;
    private int totalDecryptedSentBytes = 0;
    private int totalDecryptedRecvBytes = 0;
    private final IntObjectHashMap<Consumer<Packet>> responseCallbacks = new IntObjectHashMap();
    private int seq = 0;
    private SecretKey secretKey;
    private final ArrayList<DirectConnection> connections = new ArrayList();
    private final ArrayList<GroupConnection> groups = new ArrayList();
    private final ArrayList<PendingGroupConnection> pendingGroups = new ArrayList();
    private UUID authenticatedUUID;
    private boolean isClosed = false;
    private final ArrayList<AwaitedDirectConnection> awaitedDirectConnections = new ArrayList();
    private final ArrayList<PendingGroupKey> pendingGroupKeys = new ArrayList();
    private final ArrayList<PendingGroupConnectionData> pendingGroupMessages = new ArrayList();
    private final ArrayList<ConnectionStatusHook> connectionHooks = new ArrayList();

    public MessageHandler() {
        this(false);
    }

    public MessageHandler(boolean isReconnecting) {
        this.isReconnecting = isReconnecting;
    }

    @Override
    public MessageHandlerStats getStats() {
        HashMap<DirectConnection, ConnectionStats> connectionStats = new HashMap<DirectConnection, ConnectionStats>();
        this.connections.forEach(it -> connectionStats.put((DirectConnection)it, it.getStats()));
        HashMap<GroupConnection, ConnectionStats> groupStats = new HashMap<GroupConnection, ConnectionStats>();
        this.groups.forEach(it -> groupStats.put((GroupConnection)it, it.getStats()));
        return new MessageHandlerStats(System.currentTimeMillis(), this.totalEncryptedSentBytes, this.totalEncryptedRecvBytes, this.totalDecryptedSentBytes, this.totalDecryptedRecvBytes, connectionStats, groupStats);
    }

    private void sendData(byte[] data) {
        try {
            this.output.writeInt(data.length);
            this.output.write(data);
            this.totalEncryptedSentBytes += data.length + 4;
            this.output.flush();
        }
        catch (IOException e) {
            MsgEncryptionMod.LOGGER.error("Failed to send raw data", (Throwable)e);
            this.close(true, true);
        }
    }

    private void sendEncryptedData(byte[] data) {
        if (this.secretKey == null) {
            return;
        }
        byte[] ivBytes = new byte[12];
        new SecureRandom().nextBytes(ivBytes);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, ivBytes);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)this.secretKey, gcmSpec);
            byte[] encrypted = cipher.doFinal(data);
            this.totalDecryptedSentBytes += data.length;
            byte[] send = new byte[encrypted.length + ivBytes.length];
            System.arraycopy(ivBytes, 0, send, 0, ivBytes.length);
            System.arraycopy(encrypted, 0, send, ivBytes.length, encrypted.length);
            this.sendData(send);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            MsgEncryptionMod.LOGGER.error("Failed to send encrypted data", (Throwable)e);
            this.close(true, true);
        }
    }

    private void sendPacket(Packet packet) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bout);){
            out.writeByte(packet.type().id());
            packet.toBinaryData(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.sendEncryptedData(bout.toByteArray());
    }

    private void sendPacket(PlayerStatusRequestPacket packet, Consumer<PlayerStatus> responseCallback) {
        if (this.secretKey == null) {
            responseCallback.accept(null);
            return;
        }
        this.responseCallbacks.put(packet.requestId(), rp -> {
            if (rp == null) {
                responseCallback.accept(PlayerStatus.UNAVAILABLE);
            } else if (rp instanceof PlayerStatusResponsePacket) {
                PlayerStatusResponsePacket p = (PlayerStatusResponsePacket)rp;
                responseCallback.accept(p.status());
            } else {
                throw new RuntimeException("unexpected packet: " + String.valueOf(rp));
            }
        });
        this.sendPacket(packet);
    }

    private void sendPacket(ConnectionCreateRequestPacket packet, Runnable failureCallback, Consumer<UUID> successCallback) {
        if (this.secretKey == null) {
            failureCallback.run();
            return;
        }
        this.responseCallbacks.put(packet.requestId(), rp -> {
            if (rp == null || rp instanceof ConnectionCreateFailureResponsePacket) {
                failureCallback.run();
            } else if (rp instanceof ConnectionCreateSuccessResponsePacket) {
                ConnectionCreateSuccessResponsePacket p = (ConnectionCreateSuccessResponsePacket)rp;
                successCallback.accept(p.connectionId());
            } else {
                throw new RuntimeException("unexpected packet: " + String.valueOf(rp));
            }
        });
        this.sendPacket(packet);
    }

    @Override
    public void setSocket(Socket socket, DataOutputStream output) {
        this.socket = socket;
        this.output = output;
    }

    private SecretKey generateAesKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleOpen() {
        PublicKey serverKey = MsgEncryptionAPI.getServerPublicKey();
        if (serverKey == null) {
            this.close(false, true);
            return;
        }
        this.secretKey = this.generateAesKey();
        try {
            Cipher encryptCipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
            encryptCipher.init(1, serverKey);
            this.sendData(encryptCipher.doFinal(this.secretKey.getEncoded()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            MsgEncryptionMod.LOGGER.error("Failed to generate AES key", (Throwable)e);
            this.close(false, true);
            return;
        }
        JsonObject initData = new JsonObject();
        initData.addProperty("mod_version", "2.1.0");
        initData.addProperty("minecraft_version", class_155.method_16673().method_48019());
        initData.addProperty("host", "epme.mods.epicpix.dev");
        initData.addProperty("is_reconnecting", Boolean.valueOf(this.isReconnecting));
        initData.addProperty("transport_format", TransportFormat.BINARY_V1.name());
        JsonObject initBase = new JsonObject();
        initBase.addProperty("op", "CLIENT_INFO");
        initBase.add("data", (JsonElement)initData);
        this.sendEncryptedData(GSON.toJson((JsonElement)initBase).getBytes(StandardCharsets.UTF_8));
        String token = MsgEncryptionAPI.getAuthToken();
        if (token == null) {
            MsgEncryptionMod.LOGGER.error("Failed to get an authentication token");
            NotificationHandler.showTranslatableNotification("failed_get_auth_token");
            this.close(false, false);
            return;
        }
        this.sendPacket(new AuthRequestPacket(token));
    }

    @Override
    public void handleData(byte[] data) {
        this.totalEncryptedRecvBytes += data.length + 4;
        byte[] iv = new byte[12];
        System.arraycopy(data, 0, iv, 0, 12);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)this.secretKey, gcmSpec);
            byte[] input = new byte[data.length - 12];
            System.arraycopy(data, 12, input, 0, input.length);
            byte[] encrypted = cipher.doFinal(input);
            this.totalDecryptedRecvBytes += encrypted.length;
            this.handlePacket(Packet.fromBinary(new DataInputStream(new ByteArrayInputStream(encrypted))));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            MsgEncryptionMod.LOGGER.error("Failed to decrypt encrypted data", (Throwable)e);
            this.close(true, true);
        }
        catch (IOException | RuntimeException e) {
            MsgEncryptionMod.LOGGER.error("Failed to handle data", (Throwable)e);
            this.close(true, true);
        }
    }

    private void handlePacket(Packet packet) {
        Packet packet2 = packet;
        Objects.requireNonNull(packet2);
        Packet packet3 = packet2;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthFailureResponsePacket.class, AuthSuccessResponsePacket.class, HeartbeatPacket.class, PrepareConnectionPacket.class, ConnectionDataPacket.class, ConnectionClosePacket.class, ConnectionCreateFailureResponsePacket.class, ConnectionCreateSuccessResponsePacket.class, PlayerStatusResponsePacket.class}, (Object)packet3, n)) {
            case 0: {
                AuthFailureResponsePacket p = (AuthFailureResponsePacket)packet3;
                if (this.authenticatedUUID != null) {
                    throw new RuntimeException("received auth packet after handling auth");
                }
                NotificationHandler.showTranslatableNotification("failed_auth");
                this.close(false, false);
                break;
            }
            case 1: {
                AuthSuccessResponsePacket p = (AuthSuccessResponsePacket)packet3;
                if (p.firstTime()) {
                    MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.first_start"));
                }
                this.handleAuthenticated(p.uuid());
                break;
            }
            case 2: {
                HeartbeatPacket p = (HeartbeatPacket)packet3;
                this.sendPacket(p);
                break;
            }
            case 3: {
                PrepareConnectionPacket p = (PrepareConnectionPacket)packet3;
                DirectConnection connection = new DirectConnection(p.connectionId(), new Participant(p.username(), p.uuid()));
                this.connections.add(connection);
                break;
            }
            case 4: {
                ConnectionDataPacket p = (ConnectionDataPacket)packet3;
                for (DirectConnection connection : this.connections) {
                    if (!connection.connectionId.equals(p.connectionId())) continue;
                    connection.handleMessage(p.source(), p.data());
                    break block0;
                }
                break;
            }
            case 5: {
                ConnectionClosePacket p = (ConnectionClosePacket)packet3;
                DirectConnection connection = null;
                for (DirectConnection c : this.connections) {
                    if (!c.connectionId.equals(p.connectionId())) continue;
                    connection = c;
                    break;
                }
                if (connection == null) break;
                connection.destroy();
                this.connections.remove(connection);
                this.handleConnectionStatus(connection, false);
                break;
            }
            case 6: {
                ConnectionCreateFailureResponsePacket p = (ConnectionCreateFailureResponsePacket)packet3;
                Consumer cb = (Consumer)this.responseCallbacks.remove(p.requestId());
                if (cb == null) break;
                cb.accept(p);
                break;
            }
            case 7: {
                ConnectionCreateSuccessResponsePacket p = (ConnectionCreateSuccessResponsePacket)packet3;
                Consumer cb = (Consumer)this.responseCallbacks.remove(p.requestId());
                if (cb == null) break;
                cb.accept(p);
                break;
            }
            case 8: {
                PlayerStatusResponsePacket p = (PlayerStatusResponsePacket)packet3;
                Consumer cb = (Consumer)this.responseCallbacks.remove(p.requestId());
                if (cb == null) break;
                cb.accept(p);
                break;
            }
            default: {
                throw new RuntimeException("unknown packet: " + String.valueOf(packet));
            }
        }
    }

    public void handleAuthenticated(UUID uuid) {
        if (this.isReconnecting) {
            NotificationHandler.showTranslatableNotification("success_reconnecting");
        }
        this.authenticatedUUID = uuid;
        this.sendClientState(class_310.method_1551().method_1562() != null ? ClientState.PLAYING : ClientState.IN_MENU);
    }

    @Override
    public UUID getUuid() {
        return this.authenticatedUUID;
    }

    @Override
    public void handleClose(boolean reconnect, boolean showNotification) {
        if (this.authenticatedUUID == null) {
            System.clearProperty("EPME_ACCESS_TOKEN");
        }
        this.responseCallbacks.forEach((k, v) -> {
            try {
                v.accept(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (!this.isClosed) {
            this.isClosed = true;
            ArrayList<DirectConnection> connections = new ArrayList<DirectConnection>(this.connections);
            this.connections.clear();
            for (DirectConnection connection : connections) {
                connection.destroy();
                this.handleConnectionStatus(connection, false);
            }
            this.groups.clear();
            this.pendingGroupKeys.clear();
            this.pendingGroupMessages.clear();
            this.pendingGroups.clear();
            this.awaitedDirectConnections.clear();
            this.connectionHooks.clear();
            if (showNotification) {
                if (reconnect) {
                    NotificationHandler.showTranslatableNotification("reconnecting");
                } else {
                    NotificationHandler.showTranslatableNotification("disconnected");
                }
            }
            if (reconnect) {
                MsgEncryptionAPI.executorService.submit(() -> {
                    try {
                        TimeUnit.MILLISECONDS.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (MsgEncryptionMod.messageHandler == null) {
                        MessageHandler newMessageHandler = new MessageHandler(true);
                        MsgEncryptionMod.setMessageHandler(newMessageHandler);
                        if (!MsgEncryptionAPI.connectToMessageServer(MsgEncryptionAPI.getMessageServerAddress(), newMessageHandler) && showNotification) {
                            NotificationHandler.showTranslatableNotification("failed_reconnecting");
                        }
                    }
                });
            }
        }
    }

    @Override
    public void close(boolean reconnect, boolean showNotification) {
        if (!this.isClosed && this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                MsgEncryptionMod.LOGGER.error("Failed to close socket", (Throwable)e);
            }
        }
        boolean isCurrentHandler = MsgEncryptionMod.messageHandler == this;
        this.handleClose(reconnect && isCurrentHandler, showNotification && isCurrentHandler);
    }

    @Override
    public boolean isConnected() {
        return !this.isClosed && this.socket != null && !this.socket.isClosed();
    }

    public void getDirectConnection(String username, UUID uuid, Consumer<DirectConnection> successCallback, Runnable failureCallback) {
        if (this.isClosed) {
            failureCallback.run();
            return;
        }
        for (DirectConnection connection2 : this.connections) {
            if (!connection2.recipient.username().equalsIgnoreCase(username) && !connection2.recipient.uuid().equals(uuid) || connection2.getPurpose() != DirectConnectionPurpose.DIRECT) continue;
            this.getConnection(connection2.connectionId, successCallback, failureCallback);
            return;
        }
        this.createConnection(username, uuid).thenAccept(connection -> {
            if (connection == null) {
                failureCallback.run();
            } else {
                connection.sendFormatChangeRequest(PeerTransportFormat.SNBT);
                connection.sendConnectionStartKeyExchange();
                connection.startKeyExchange();
                this.connectionHooks.add(new ConnectionStatusHook(connection.connectionId, success -> successCallback.accept((DirectConnection)connection), failureCallback));
            }
        });
    }

    public void awaitForDirectConnection(String username, UUID uuid, Consumer<DirectConnection> successCallback, Runnable failureCallback) {
        for (DirectConnection connection : this.connections) {
            if (!connection.recipient.username().equalsIgnoreCase(username) && !connection.recipient.uuid().equals(uuid) || connection.getPurpose() != DirectConnectionPurpose.DIRECT) continue;
            this.getConnection(connection.connectionId, successCallback, failureCallback);
            return;
        }
        this.awaitedDirectConnections.add(new AwaitedDirectConnection(username, uuid, successCallback, failureCallback));
    }

    public void checkGroupReady(UUID groupId) {
        PendingGroupConnection readyGroup = null;
        for (PendingGroupConnection group : this.pendingGroups) {
            if (!group.groupId.equals(groupId) || !group.isKeyReady()) continue;
            readyGroup = group;
        }
        if (readyGroup != null) {
            GroupConnection group = new GroupConnection(groupId, readyGroup.establishedPlayers.toArray(new Participant[0]), readyGroup.allKeys);
            this.groups.add(group);
            this.pendingGroups.remove(readyGroup);
            this.pendingGroupMessages.removeIf(it -> {
                if (it.groupId().equals(groupId)) {
                    group.handleData(it.source(), it.data());
                    return true;
                }
                return false;
            });
            readyGroup.successCallback.accept(group);
        }
    }

    public void updateGroupKey(UUID groupId, Participant source, byte[] key) {
        boolean foundGroup = false;
        for (PendingGroupConnection group : this.pendingGroups) {
            if (!group.groupId.equals(groupId)) continue;
            if (group.allPlayers.contains(source.uuid()) && !group.establishedPlayers.contains(source)) {
                group.addKey(source, key);
            }
            foundGroup = true;
            break;
        }
        if (foundGroup) {
            this.checkGroupReady(groupId);
        } else {
            this.pendingGroupKeys.add(new PendingGroupKey(groupId, source, key));
        }
    }

    public void removeGroup(UUID groupId) {
        this.groups.remove(this.getGroup(groupId));
    }

    public PendingGroupConnection getPendingGroup(UUID groupId) {
        for (PendingGroupConnection pendingGroup : this.pendingGroups) {
            if (!pendingGroup.groupId.equals(groupId)) continue;
            return pendingGroup;
        }
        return null;
    }

    public void handleGroupData(UUID groupId, UUID source, byte[] data) {
        GroupConnection group = this.getGroup(groupId);
        if (group != null) {
            group.handleData(source, data);
        } else if (this.getPendingGroup(groupId) != null) {
            this.pendingGroupMessages.add(new PendingGroupConnectionData(groupId, source, data));
        }
    }

    @Override
    public void handleConnectionStatus(DirectConnection connection, boolean success) {
        this.awaitedDirectConnections.removeIf(it -> {
            if (connection.getPurpose() == DirectConnectionPurpose.DIRECT && (Objects.equals(it.username, connection.recipient.username()) || Objects.equals(it.uuid, connection.recipient.uuid()))) {
                if (success) {
                    it.successCallback.accept(connection);
                } else {
                    it.failureCallback.run();
                }
                return true;
            }
            return false;
        });
        this.connectionHooks.removeIf(c -> {
            if (connection.connectionId.equals(c.uuid)) {
                if (success) {
                    c.successCallback.accept(connection);
                } else {
                    c.failureCallback.run();
                }
                return true;
            }
            return false;
        });
    }

    public DirectConnection getConnectionNow(UUID connectionId) {
        for (DirectConnection connection : this.connections) {
            if (!connection.connectionId.equals(connectionId)) continue;
            return connection;
        }
        return null;
    }

    @Override
    public void getConnection(UUID connectionId, Consumer<DirectConnection> successCallback, Runnable failureCallback) {
        boolean connectionRegistered = false;
        for (DirectConnection connection : this.connections) {
            if (!connection.connectionId.equals(connectionId)) continue;
            connectionRegistered = true;
            if (connection.getState() != DirectConnectionState.ESTABLISHED || connection.getPurpose() != DirectConnectionPurpose.DIRECT) continue;
            successCallback.accept(connection);
            return;
        }
        if (!connectionRegistered) {
            failureCallback.run();
        } else {
            this.connectionHooks.add(new ConnectionStatusHook(connectionId, successCallback, failureCallback));
        }
    }

    private void validateEveryoneAvailable(List<UUID> players, Runnable successCallback, Runnable failureCallback) {
        AtomicInteger index = new AtomicInteger();
        AtomicBoolean failureCallbackCalled = new AtomicBoolean();
        for (UUID player : players) {
            if (player.equals(this.authenticatedUUID)) {
                if (index.addAndGet(1) != players.size()) continue;
                successCallback.run();
                continue;
            }
            this.getPlayerStatus(null, player).thenAccept(status -> {
                if (status != PlayerStatus.ON_GATEWAY) {
                    if (failureCallbackCalled.compareAndSet(false, true)) {
                        failureCallback.run();
                    }
                } else if (index.addAndGet(1) == players.size()) {
                    successCallback.run();
                }
            });
        }
    }

    public void createGroupConnections(UUID groupId, boolean initiator, List<UUID> players, Consumer<GroupConnection> successCallback, Runnable failureCallback) {
        this.validateEveryoneAvailable(players, () -> {
            PendingGroupConnection pending = new PendingGroupConnection(this.authenticatedUUID, groupId, players, successCallback);
            this.pendingGroups.add(pending);
            for (UUID player : players) {
                if (player.equals(this.authenticatedUUID)) continue;
                if (initiator || this.authenticatedUUID.compareTo(player) < 0) {
                    this.getDirectConnection(null, player, conn -> {
                        if (initiator) {
                            conn.sendGroupStart(groupId, players.toArray(new UUID[0]));
                        }
                        conn.sendGroupKey(groupId, pending.selfKey.getEncoded());
                        this.openGroupConnection(groupId, player);
                    }, failureCallback);
                    continue;
                }
                this.awaitForDirectConnection(null, player, conn -> conn.sendGroupKey(groupId, pending.selfKey.getEncoded()), failureCallback);
            }
            this.pendingGroupKeys.removeIf(it -> {
                if (it.groupId().equals(groupId)) {
                    this.updateGroupKey(it.groupId(), it.source(), it.key());
                    return true;
                }
                return false;
            });
        }, failureCallback);
    }

    @Override
    public void createGroup(List<UUID> players, Consumer<GroupConnection> successCallback, Runnable failureCallback) {
        this.createGroupConnections(UUID.randomUUID(), true, players, successCallback, failureCallback);
    }

    public void openGroupConnection(UUID groupId, UUID player) {
        if (this.authenticatedUUID.compareTo(player) < 0) {
            this.createConnection(null, player).thenAccept(connection -> connection.convertToGroup(groupId));
        }
    }

    @Override
    public GroupConnection getGroup(UUID groupId) {
        for (GroupConnection group : this.groups) {
            if (!group.groupId.equals(groupId)) continue;
            return group;
        }
        return null;
    }

    public ArrayList<UUID> getGroupConnections(UUID groupId) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (DirectConnection connection : this.connections) {
            if (connection.getPurpose() != DirectConnectionPurpose.GROUP_DATA || !groupId.equals(connection.getGroupIdBinding())) continue;
            uuids.add(connection.connectionId);
        }
        return uuids;
    }

    @Override
    public void closeConnection(UUID connectionId) {
        DirectConnection dc = null;
        for (DirectConnection connection : this.connections) {
            if (!connection.connectionId.equals(connectionId)) continue;
            dc = connection;
            break;
        }
        if (dc != null) {
            this.connections.remove(dc);
            dc.destroy();
            this.sendConnectionClose(connectionId);
            this.handleConnectionStatus(dc, false);
        }
    }

    private byte[] usernameHash(String username) {
        return DigestUtils.sha1((String)("husername:" + username.toLowerCase()));
    }

    private byte[] uuidHash(UUID uuid) {
        return DigestUtils.sha1((String)("huuid:" + String.valueOf(uuid)));
    }

    @Override
    public CompletableFuture<PlayerStatus> getPlayerStatus(String username, UUID uuid) {
        CompletableFuture<PlayerStatus> result = new CompletableFuture<PlayerStatus>();
        if (this.isConnected()) {
            this.sendPacket(new PlayerStatusRequestPacket(this.seq++, username != null ? this.usernameHash(username) : null, uuid != null ? this.uuidHash(uuid) : null), result::complete);
        } else {
            result.complete(PlayerStatus.UNAVAILABLE);
        }
        return result;
    }

    @Override
    public CompletableFuture<DirectConnection> createConnection(String username, UUID uuid) {
        CompletableFuture<DirectConnection> result = new CompletableFuture<DirectConnection>();
        if (this.isConnected()) {
            this.sendPacket(new ConnectionCreateRequestPacket(this.seq++, username != null ? this.usernameHash(username) : null, uuid != null ? this.uuidHash(uuid) : null), () -> result.complete(null), id -> result.complete(this.getConnectionNow((UUID)id)));
        } else {
            result.complete(null);
        }
        return result;
    }

    @Override
    public void sendConnectionData(UUID connectionId, byte[] data, boolean includeSelf) {
        this.sendPacket(new ConnectionSendDataPacket(connectionId, includeSelf, data));
    }

    @Override
    public void sendConnectionDataGroup(List<UUID> connectionIds, byte[] data) {
        this.sendPacket(new ConnectionSendGroupDataPacket(connectionIds, data));
    }

    public void sendConnectionClose(UUID connectionId) {
        this.sendPacket(new ConnectionClosePacket(connectionId));
    }

    public void sendClientState(ClientState state) {
        this.sendPacket(new ClientStatePacket(state));
    }

    private record AwaitedDirectConnection(String username, UUID uuid, Consumer<DirectConnection> successCallback, Runnable failureCallback) {
    }

    private record ConnectionStatusHook(UUID uuid, Consumer<DirectConnection> successCallback, Runnable failureCallback) {
    }
}

