/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public record ConnectionSendDataPacket(UUID connectionId, boolean includeSelf, byte[] data) implements Packet
{
    public static ConnectionSendDataPacket fromBinary(DataInputStream input) throws IOException {
        return new ConnectionSendDataPacket(new UUID(input.readLong(), input.readLong()), input.readBoolean(), input.readNBytes(input.readInt()));
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeLong(this.connectionId.getMostSignificantBits());
        output.writeLong(this.connectionId.getLeastSignificantBits());
        output.writeBoolean(this.includeSelf);
        output.writeInt(this.data.length);
        output.write(this.data);
    }

    @Override
    public PacketType type() {
        return PacketType.CONNECTION_SEND_DATA;
    }
}

