/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public record ConnectionSendGroupDataPacket(List<UUID> connectionIds, byte[] data) implements Packet
{
    public static ConnectionSendGroupDataPacket fromBinary(DataInputStream input) throws IOException {
        int connectionIdCount = input.readInt();
        ArrayList<UUID> connectionIds = new ArrayList<UUID>();
        for (int i = 0; i < connectionIdCount; ++i) {
            connectionIds.add(new UUID(input.readLong(), input.readLong()));
        }
        return new ConnectionSendGroupDataPacket(connectionIds, input.readNBytes(input.readInt()));
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeInt(this.connectionIds.size());
        for (UUID connectionId : this.connectionIds) {
            output.writeLong(connectionId.getMostSignificantBits());
            output.writeLong(connectionId.getLeastSignificantBits());
        }
        output.writeInt(this.data.length);
        output.write(this.data);
    }

    @Override
    public PacketType type() {
        return PacketType.CONNECTION_SEND_GROUP_DATA;
    }
}

