/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public record AuthSuccessResponsePacket(String username, UUID uuid, boolean firstTime) implements Packet
{
    public static AuthSuccessResponsePacket fromBinary(DataInputStream input) throws IOException {
        return new AuthSuccessResponsePacket(input.readUTF(), new UUID(input.readLong(), input.readLong()), input.readBoolean());
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeUTF(this.username);
        output.writeLong(this.uuid.getMostSignificantBits());
        output.writeLong(this.uuid.getLeastSignificantBits());
        output.writeBoolean(this.firstTime);
    }

    @Override
    public PacketType type() {
        return PacketType.AUTH_SUCCESS_RESPONSE;
    }
}

