/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public record ConnectionClosePacket(UUID connectionId) implements Packet
{
    public static ConnectionClosePacket fromBinary(DataInputStream input) throws IOException {
        return new ConnectionClosePacket(new UUID(input.readLong(), input.readLong()));
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeLong(this.connectionId.getMostSignificantBits());
        output.writeLong(this.connectionId.getLeastSignificantBits());
    }

    @Override
    public PacketType type() {
        return PacketType.CONNECTION_CLOSE;
    }
}

