/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.PlayerStatus;
import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public record PlayerStatusResponsePacket(int requestId, PlayerStatus status) implements Packet
{
    public static PlayerStatusResponsePacket fromBinary(DataInputStream input) throws IOException {
        int requestId = input.readInt();
        int statusIndex = input.readUnsignedByte();
        PlayerStatus status = switch (statusIndex) {
            case 0 -> PlayerStatus.UNAVAILABLE;
            case 1 -> PlayerStatus.OFF_GATEWAY;
            case 2 -> PlayerStatus.ON_GATEWAY_AWAY;
            case 3 -> PlayerStatus.ON_GATEWAY;
            default -> throw new IllegalStateException("invalid player status: " + statusIndex);
        };
        return new PlayerStatusResponsePacket(requestId, status);
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeInt(this.requestId);
        switch (this.status) {
            case UNAVAILABLE: {
                output.writeByte(0);
                break;
            }
            case OFF_GATEWAY: {
                output.writeByte(1);
                break;
            }
            case ON_GATEWAY_AWAY: {
                output.writeByte(2);
                break;
            }
            case ON_GATEWAY: {
                output.writeByte(3);
            }
        }
    }

    @Override
    public PacketType type() {
        return PacketType.PLAYER_STATUS_RESPONSE;
    }
}

