/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption;

import com.mojang.brigadier.CommandDispatcher;
import dev.epicpix.msg_encryption.LocalCommandDispatcher;
import dev.epicpix.msg_encryption.MessageHandler;
import dev.epicpix.msg_encryption.NotificationHandler;
import dev.epicpix.msg_encryption.api.ClientState;
import dev.epicpix.msg_encryption.api.MsgEncryptionAPI;
import dev.epicpix.msg_encryption.config.ModConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7591;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgEncryptionMod
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ep-msg-encryption");
    public static class_304 settingsKeyBinding;
    public static MessageHandler messageHandler;
    private static final Pattern protocolLinkPattern;
    private static final Pattern optProtocolLinkPattern;

    public static void addMessage(class_2561 text) {
        MsgEncryptionMod.addMessage(text, class_7591.method_44751());
    }

    public static void addMessage(class_2561 text, class_7591 indicator) {
        class_310.method_1551().execute(() -> class_310.method_1551().field_1705.method_1743().method_44811(text, null, indicator));
    }

    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        settingsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.epme.settings", class_3675.class_307.field_1668, 77, "key.categories.misc"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (settingsKeyBinding.method_1436()) {
                if (client.field_1755 != null) continue;
                client.method_1507((class_437)AutoConfig.getConfigScreen(ModConfig.class, null).get());
            }
        });
        MsgEncryptionMod.tryConnect();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (messageHandler != null && messageHandler.isConnected()) {
                messageHandler.sendClientState(ClientState.PLAYING);
            } else {
                MsgEncryptionMod.tryConnect();
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (messageHandler != null && messageHandler.isConnected()) {
                messageHandler.sendClientState(ClientState.IN_MENU);
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> LocalCommandDispatcher.registerClientCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        LocalCommandDispatcher.lastPlayer = config.lastMessagedPlayer;
    }

    public static ArrayList<Range<Integer>> generateLinkRanges(String content) {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        Matcher matcher = (config.allowLinksWithoutProtocol ? optProtocolLinkPattern : protocolLinkPattern).matcher(content);
        ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>();
        while (matcher.find()) {
            result.add((Range<Integer>)Range.between((Comparable)Integer.valueOf(matcher.start()), (Comparable)Integer.valueOf(matcher.end() - 1)));
        }
        return result;
    }

    public static class_5250 generateLinks(String content) {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        Matcher matcher = (config.allowLinksWithoutProtocol ? optProtocolLinkPattern : protocolLinkPattern).matcher(content);
        class_5250 result = class_2561.method_43470((String)"");
        int end = 0;
        while (matcher.find()) {
            result.method_10852((class_2561)class_2561.method_43470((String)content.substring(end, matcher.start())));
            end = matcher.end();
            Object url = content.substring(matcher.start(), matcher.end());
            if (config.allowLinksWithoutProtocol && matcher.group(1) == null) {
                url = "https://" + (String)url;
            }
            try {
                URI uri = new URI((String)url);
                result.method_10852((class_2561)class_2561.method_43470((String)content.substring(matcher.start(), matcher.end())).method_10862(class_2583.field_24360.method_10977(config.linkColor.getFormatting()).method_30938(Boolean.valueOf(config.underlineLinks)).method_10958(new class_2558(class_2558.class_2559.field_11749, (String)url))));
            }
            catch (URISyntaxException ignored) {
                result.method_10852((class_2561)class_2561.method_43470((String)content.substring(matcher.start(), matcher.end())));
            }
        }
        result.method_10852((class_2561)class_2561.method_43470((String)content.substring(end)));
        return result;
    }

    public static synchronized void setMessageHandler(MessageHandler handler) {
        MessageHandler oldHandler = messageHandler;
        messageHandler = handler;
        if (oldHandler != null) {
            oldHandler.close(false, false);
        }
    }

    private static void tryConnect() {
        MsgEncryptionAPI.executorService.submit(() -> {
            if (messageHandler == null || !messageHandler.isConnected()) {
                MessageHandler newMessageHandler = new MessageHandler();
                MsgEncryptionMod.setMessageHandler(newMessageHandler);
                if (!MsgEncryptionAPI.connectToMessageServer(MsgEncryptionAPI.getMessageServerAddress(), newMessageHandler)) {
                    NotificationHandler.showTranslatableNotification("disconnected");
                }
            }
        });
    }

    static {
        protocolLinkPattern = Pattern.compile("https?://([a-zA-Z0-9_-]+\\.)+[a-z]+([/?][-a-zA-Z0-9()@:%_+.~#?&/=]*)?");
        optProtocolLinkPattern = Pattern.compile("(https?://)?([a-zA-Z0-9_-]+\\.)+[a-z]+([/?][-a-zA-Z0-9()@:%_+.~#?&/=]*)?");
    }
}

