/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.epicpix.msg_encryption.LocalCommandDispatcher;
import dev.epicpix.msg_encryption.MsgEncryptionMod;
import dev.epicpix.msg_encryption.NotificationHandler;
import dev.epicpix.msg_encryption.api.CommonConnection;
import dev.epicpix.msg_encryption.api.ConnectionMessage;
import dev.epicpix.msg_encryption.api.DirectConnectionPurpose;
import dev.epicpix.msg_encryption.api.DirectConnectionState;
import dev.epicpix.msg_encryption.api.GroupConnection;
import dev.epicpix.msg_encryption.api.NbtConverter;
import dev.epicpix.msg_encryption.api.Participant;
import dev.epicpix.msg_encryption.api.PeerTransportFormat;
import dev.epicpix.msg_encryption.api.PendingGroupConnection;
import dev.epicpix.msg_encryption.config.ModConfig;
import dev.epicpix.msg_encryption.events.DirectConnectionEndedEvent;
import dev.epicpix.msg_encryption.events.DirectConnectionStartedEvent;
import dev.epicpix.msg_encryption.stats.ConnectionStats;
import ep-msg-encryption-fabric.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_7591;
import org.apache.commons.lang3.Range;

public class DirectConnection
implements CommonConnection {
    private static final Gson GSON = new GsonBuilder().create();
    public final UUID connectionId;
    public final Participant recipient;
    private DirectConnectionPurpose purpose;
    private UUID groupIdBinding;
    private PeerTransportFormat sendFormat = PeerTransportFormat.JSON;
    private PeerTransportFormat recvFormat = PeerTransportFormat.JSON;
    private DirectConnectionState state;
    private final HashMap<String, Integer> recvSizes = new HashMap();
    private final HashMap<String, Integer> sentSizes = new HashMap();
    private final ArrayList<QueuedMessage> sendQueue = new ArrayList();
    private KeyPair keyPair;
    private SecretKey key;
    private final HashMap<String, BiConsumer<DirectConnection, ConnectionMessage>> messageTypes = new HashMap();

    public DirectConnection(UUID connectionId, Participant recipient) {
        this.connectionId = connectionId;
        this.recipient = recipient;
        this.purpose = DirectConnectionPurpose.DIRECT;
        this.groupIdBinding = null;
        this.setState(DirectConnectionState.ESTABLISHING);
    }

    void updateGroupSendCount(int amt) {
        this.sentSizes.put("GROUP_DATA", this.sentSizes.getOrDefault("GROUP_DATA", 0) + amt);
    }

    @Override
    public ConnectionStats getStats() {
        return new ConnectionStats(new HashMap<String, Integer>(this.recvSizes), new HashMap<String, Integer>(this.sentSizes));
    }

    public DirectConnectionPurpose getPurpose() {
        return this.purpose;
    }

    public UUID getGroupIdBinding() {
        return this.groupIdBinding;
    }

    public DirectConnectionState getState() {
        return this.state;
    }

    private void setState(DirectConnectionState state) {
        this.state = state;
        if (state == DirectConnectionState.ESTABLISHED && this.purpose == DirectConnectionPurpose.DIRECT) {
            for (QueuedMessage queue : this.sendQueue) {
                this.sendData(queue.op, queue.data, queue.includeSelf);
            }
            this.sendQueue.clear();
        }
    }

    public void destroy() {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (config.showNotificationOnDestroyedConnection) {
            NotificationHandler.showNotification((class_2561)class_2561.method_43471((String)"epme.notification.connection_destroyed.title"), (class_2561)class_2561.method_43469((String)"epme.notification.connection_destroyed.description", (Object[])new Object[]{this.recipient.username()}));
        }
        DirectConnectionState prevState = this.state;
        this.setState(DirectConnectionState.DEAD);
        if (prevState != DirectConnectionState.DEAD) {
            if (this.purpose == DirectConnectionPurpose.GROUP_DATA) {
                GroupConnection group = MsgEncryptionMod.messageHandler.getGroup(this.groupIdBinding);
                if (group != null) {
                    group.disbandGroup();
                }
            } else {
                ((DirectConnectionEndedEvent)DirectConnectionEndedEvent.EVENT.invoker()).execute(this);
            }
        }
    }

    public void startKeyExchange() {
        KeyPairGenerator kpg;
        if (this.state != DirectConnectionState.ESTABLISHING) {
            throw new IllegalStateException(this.state.name());
        }
        this.setState(DirectConnectionState.KEY_EXCHANGE);
        try {
            kpg = KeyPairGenerator.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        kpg.initialize(256);
        this.keyPair = kpg.generateKeyPair();
        byte[] publicKey = this.keyPair.getPublic().getEncoded();
        this.sendConnectionPublicKey(publicKey);
    }

    public void startKeyValidation(byte[] publicKey) {
        if (this.state != DirectConnectionState.KEY_EXCHANGE) {
            throw new IllegalStateException(this.state.name());
        }
        this.setState(DirectConnectionState.KEY_GENERATION);
        try {
            KeyFactory kf = KeyFactory.getInstance("EC");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            PublicKey otherPublicKey = kf.generatePublic(keySpec);
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(this.keyPair.getPrivate());
            ka.doPhase(otherPublicKey, true);
            byte[] sharedSecret = ka.generateSecret();
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            hash.update(sharedSecret);
            List<ByteBuffer> keys = Arrays.asList(ByteBuffer.wrap(this.keyPair.getPublic().getEncoded()), ByteBuffer.wrap(publicKey));
            Collections.sort(keys);
            hash.update(keys.get(0));
            hash.update(keys.get(1));
            byte[] keyBytes = hash.digest();
            this.key = new SecretKeySpec(keyBytes, "AES");
            this.sendConnectionKeyGenerated();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        this.setState(DirectConnectionState.KEY_VALIDATION);
    }

    public void validateKeys() {
        if (this.state != DirectConnectionState.KEY_VALIDATION) {
            throw new IllegalStateException(this.state.name());
        }
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            hash.update((MsgEncryptionMod.messageHandler.getUuid().toString() + this.recipient.uuid().toString() + this.connectionId.toString()).getBytes(StandardCharsets.UTF_8));
            hash.update(this.key.getEncoded());
            byte[] validateBytes = hash.digest();
            this.sendConnectionVerification(validateBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.setState(DirectConnectionState.KEY_VALIDATING);
    }

    public void validateKeyData(byte[] keyData) {
        if (this.state != DirectConnectionState.KEY_VALIDATING) {
            throw new IllegalStateException(this.state.name());
        }
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            hash.update((this.recipient.uuid().toString() + MsgEncryptionMod.messageHandler.getUuid().toString() + this.connectionId.toString()).getBytes(StandardCharsets.UTF_8));
            hash.update(this.key.getEncoded());
            byte[] validateBytes = hash.digest();
            for (int i = 0; i < keyData.length; ++i) {
                if (validateBytes[i] == keyData[i]) continue;
                this.setState(DirectConnectionState.DEAD);
                this.sendConnectionKeyExchangeFailure();
                return;
            }
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (config.displayShortVerificationKey) {
                MessageDigest keyHash = MessageDigest.getInstance("SHA-256");
                keyHash.update(this.key.getEncoded());
                String num = new BigInteger(keyHash.digest()).toString();
                if (num.startsWith("-")) {
                    num = num.substring(1);
                }
                num = num.substring(num.length() - 8);
                class_5250 chatMessage = class_2561.method_43469((String)"epme.chat.display_verification_key_direct", (Object[])new Object[]{class_2561.method_43470((String)this.recipient.username()).method_27692(class_124.field_1056), class_2561.method_43470((String)num).method_27692(class_124.field_1065)}).method_27692(class_124.field_1075);
                MsgEncryptionMod.addMessage((class_2561)chatMessage, config.showEncryptedMessageIndicator ? new class_7591(45232, null, (class_2561)class_2561.method_43469((String)"epme.chat.indicator", (Object[])new Object[]{this.recipient.username()}), null) : null);
            }
            this.sendConnectionKeyExchangeSuccess();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.setState(DirectConnectionState.PRE_ESTABLISHED);
    }

    public void updateStatus(String status) {
        if (status.equals("START_KEY_EXCHANGE")) {
            this.startKeyExchange();
        } else if (status.equals("KEYS_GENERATED")) {
            this.validateKeys();
        } else if (status.equals("KEY_EXCHANGE_FAILED")) {
            NotificationHandler.showNotification((class_2561)class_2561.method_43471((String)"epme.notification.connection_key_exchange_failed.title"), (class_2561)class_2561.method_43469((String)"epme.notification.connection_key_exchange_failed.description", (Object[])new Object[]{this.recipient.username()}));
            this.setState(DirectConnectionState.DEAD);
            MsgEncryptionMod.messageHandler.handleConnectionStatus(this, false);
        } else if (status.equals("KEY_EXCHANGE_SUCCESS") && this.state == DirectConnectionState.PRE_ESTABLISHED) {
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (config.showNotificationOnEstablishedConnection) {
                NotificationHandler.showNotification((class_2561)class_2561.method_43471((String)"epme.notification.connection_key_exchange_succeeded.title"), (class_2561)class_2561.method_43469((String)"epme.notification.connection_key_exchange_succeeded.description", (Object[])new Object[]{this.recipient.username()}));
            }
            this.setState(DirectConnectionState.ESTABLISHED);
            ((DirectConnectionStartedEvent)DirectConnectionStartedEvent.EVENT.invoker()).execute(this);
            MsgEncryptionMod.messageHandler.handleConnectionStatus(this, true);
        }
    }

    public void registerMessageType(String op, BiConsumer<DirectConnection, ConnectionMessage> executor) {
        this.messageTypes.put(op, executor);
    }

    public void handleMessage(UUID source, byte[] data) {
        class_2487 class_24872;
        if (this.purpose == DirectConnectionPurpose.GROUP_DATA) {
            this.recvSizes.put("GROUP_DATA", this.recvSizes.getOrDefault("GROUP_DATA", 0) + data.length);
            MsgEncryptionMod.messageHandler.handleGroupData(this.groupIdBinding, source, data);
            return;
        }
        if (this.state != DirectConnectionState.ESTABLISHED) {
            class_2487 class_24873;
            switch (this.recvFormat) {
                default: {
                    throw new J_L_MatchException(null, null);
                }
                case JSON: {
                    class_2487 class_24874;
                    class_24873 = class_24874 = (class_2487)NbtConverter.jsonToNbt((JsonElement)GSON.fromJson(new String(data, StandardCharsets.UTF_8), JsonObject.class));
                    break;
                }
                case SNBT: {
                    class_2487 class_24874;
                    try {
                        class_24873 = class_24874 = class_2507.method_10627((DataInput)new DataInputStream(new ByteArrayInputStream(data)));
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            class_2487 obj = class_24873;
            String op = obj.method_10558("op");
            this.recvSizes.put(op, this.recvSizes.getOrDefault(op, 0) + data.length);
            if ("HANDSHAKE".equals(op)) {
                String innerOp;
                class_2487 innerData = obj.method_10562("data");
                switch (innerOp = innerData.method_10558("op")) {
                    case "GROUP_CONNECTION": {
                        UUID groupId = UUID.fromString(innerData.method_10558("group_id"));
                        this.purpose = DirectConnectionPurpose.GROUP_DATA;
                        this.groupIdBinding = groupId;
                        PendingGroupConnection group = MsgEncryptionMod.messageHandler.getPendingGroup(groupId);
                        if (group == null) break;
                        group.markConnectionReady(this.connectionId);
                        if (!group.isConnectionReady()) break;
                        group.markReady(group.selfUuid);
                        group.broadcast("CONNECTION_READY");
                        MsgEncryptionMod.messageHandler.checkGroupReady(groupId);
                        break;
                    }
                    case "PUBLIC_KEY": {
                        this.startKeyValidation(NbtConverter.tagToBytes(innerData.method_10580("publicKey")));
                        break;
                    }
                    case "VERIFICATION_DATA": {
                        this.validateKeyData(NbtConverter.tagToBytes(innerData.method_10580("verification")));
                        break;
                    }
                    case "STATUS": {
                        this.updateStatus(innerData.method_10558("status"));
                        break;
                    }
                    case "FORMAT_CHANGE_REQ": {
                        PeerTransportFormat newFormat = PeerTransportFormat.valueOf(innerData.method_10558("transportFormat"));
                        this.sendFormatChangeResponse(newFormat);
                        this.sendFormat = newFormat;
                        break;
                    }
                    case "FORMAT_CHANGE_ACCEPT_REQ": {
                        PeerTransportFormat newFormat = PeerTransportFormat.valueOf(innerData.method_10558("transportFormat"));
                        this.sendFormatChangeAcceptResponse(newFormat);
                        this.sendFormat = newFormat;
                        this.recvFormat = newFormat;
                        break;
                    }
                    case "FORMAT_CHANGE_RESP": {
                        this.recvFormat = PeerTransportFormat.valueOf(innerData.method_10558("transportFormat"));
                    }
                }
            }
            return;
        }
        byte[] decryptedData = this.decryptData(data);
        switch (this.recvFormat) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case JSON: {
                class_2487 innerData;
                class_24872 = innerData = (class_2487)NbtConverter.jsonToNbt((JsonElement)GSON.fromJson(new String(decryptedData, StandardCharsets.UTF_8), JsonObject.class));
                break;
            }
            case SNBT: {
                class_2487 innerData;
                try {
                    class_24872 = innerData = class_2507.method_10627((DataInput)new DataInputStream(new ByteArrayInputStream(decryptedData)));
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        class_2487 obj = class_24872;
        String op = obj.method_10558("op");
        this.recvSizes.put(op, this.recvSizes.getOrDefault(op, 0) + data.length);
        if ("GROUP_HANDSHAKE".equals(op)) {
            class_2487 innerData = obj.method_10562("data");
            String innerOp = innerData.method_10558("op");
            if ("GROUP_START".equals(innerOp)) {
                ArrayList<UUID> participants = new ArrayList<UUID>();
                UUID groupId = UUID.fromString(innerData.method_10558("group_id"));
                for (class_2520 participant : innerData.method_10554("participants", 8)) {
                    participants.add(UUID.fromString(participant.method_10714()));
                }
                MsgEncryptionMod.messageHandler.createGroupConnections(groupId, false, participants, success -> {}, () -> {});
            } else if ("GROUP_KEY".equals(innerOp)) {
                UUID groupId = UUID.fromString(innerData.method_10558("group_id"));
                byte[] key = NbtConverter.tagToBytes(innerData.method_10580("key"));
                MsgEncryptionMod.messageHandler.updateGroupKey(groupId, this.recipient, key);
            } else if ("GROUP_STATE".equals(innerOp)) {
                UUID groupId = UUID.fromString(innerData.method_10558("group_id"));
                String state = innerData.method_10558("state");
                PendingGroupConnection group = MsgEncryptionMod.messageHandler.getPendingGroup(groupId);
                if (group != null && "CONNECTION_READY".equals(state)) {
                    group.markReady(source);
                    MsgEncryptionMod.messageHandler.checkGroupReady(groupId);
                }
            }
        } else if ("MESSAGE".equals(op)) {
            String rawDataMessage;
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (config.changeLastMessagedContextOnMessage) {
                LocalCommandDispatcher.lastConnection = this.connectionId;
                LocalCommandDispatcher.lastPlayer = this.recipient.uuid();
            }
            String rawMessage = rawDataMessage = obj.method_10562("data").method_10558("message");
            ArrayList<Range<Integer>> linkRanges = MsgEncryptionMod.generateLinkRanges(rawMessage);
            rawMessage = Pattern.compile("([\u00a7&])([0-9a-fklmnor])").matcher(rawMessage).replaceAll(match -> {
                String charType = match.group(1);
                if (charType.equals("&")) {
                    for (Range linkRange : linkRanges) {
                        if (!linkRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(match.start()), (Comparable)Integer.valueOf(match.end() - 1)))) continue;
                        return match.group(0);
                    }
                }
                if (!config.allowColorCodes) {
                    if (charType.equals("\u00a7")) {
                        return "";
                    }
                    return "&" + match.group(2);
                }
                return "\u00a7" + match.group(2);
            });
            rawMessage = rawMessage.replace("\n", "\\n");
            class_5250 message = MsgEncryptionMod.generateLinks(rawMessage).method_27692(config.messageColor.getFormatting());
            class_5250 chatMessage = class_2561.method_43469((String)(source.equals(this.recipient.uuid()) ? "epme.chat.message_sent" : "epme.chat.message_received"), (Object[])new Object[]{class_2561.method_43470((String)this.recipient.username()).method_27692(config.recipientColor.getFormatting()), message}).method_27692(config.defaultColor.getFormatting());
            if (config.italicText) {
                chatMessage.method_27692(class_124.field_1056);
            }
            chatMessage.method_10862(chatMessage.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click"))).method_10958(new class_2558(class_2558.class_2559.field_21462, rawDataMessage)));
            MsgEncryptionMod.addMessage((class_2561)chatMessage, config.showEncryptedMessageIndicator ? new class_7591(45232, null, (class_2561)class_2561.method_43469((String)"epme.chat.indicator", (Object[])new Object[]{this.recipient.username()}), null) : null);
            if (config.enableNotificationSound && source.equals(this.recipient.uuid())) {
                class_310.method_1551().execute(() -> {
                    if (class_310.method_1551().field_1724 != null) {
                        class_310.method_1551().field_1724.method_5783(class_3417.field_15224, 1.0f, 1.0f);
                    }
                });
            }
        } else {
            BiConsumer<DirectConnection, ConnectionMessage> executor = this.messageTypes.get(op);
            if (executor != null) {
                executor.accept(this, new ConnectionMessage(source, obj.method_10562("data")));
            }
        }
    }

    public void sendMessage(String message) {
        class_2487 data = new class_2487();
        data.method_10582("message", message);
        this.sendData("MESSAGE", data);
    }

    public void sendGroupStart(UUID groupId, UUID[] participants) {
        class_2487 data = new class_2487();
        data.method_10582("group_id", groupId.toString());
        class_2499 participantsArray = new class_2499();
        for (UUID participant : participants) {
            participantsArray.add((Object)class_2519.method_23256((String)participant.toString()));
        }
        data.method_10566("participants", (class_2520)participantsArray);
        this.sendGroupHandshakeData("GROUP_START", data);
    }

    public void sendGroupState(UUID groupId, String state) {
        class_2487 data = new class_2487();
        data.method_10582("group_id", groupId.toString());
        data.method_10582("state", state);
        this.sendGroupHandshakeData("GROUP_STATE", data);
    }

    public void sendGroupKey(UUID groupId, byte[] key) {
        class_2487 data = new class_2487();
        data.method_10582("group_id", groupId.toString());
        data.method_10582("key", Base64.getEncoder().encodeToString(key));
        this.sendGroupHandshakeData("GROUP_KEY", data);
    }

    public void sendHandshakeData(String op, class_2487 data) {
        class_2487 obj = new class_2487();
        obj.method_10582("op", "HANDSHAKE");
        data.method_10582("op", op);
        obj.method_10566("data", (class_2520)data);
        byte[] sentData = switch (this.sendFormat) {
            default -> throw new J_L_MatchException(null, null);
            case PeerTransportFormat.JSON -> {
                byte[] var5_4;
                yield var5_4 = GSON.toJson(NbtConverter.nbtToJson((class_2520)obj)).getBytes(StandardCharsets.UTF_8);
            }
            case PeerTransportFormat.SNBT -> {
                byte[] var5_4;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try (DataOutputStream out = new DataOutputStream(bout);){
                    class_2507.method_10628((class_2487)obj, (DataOutput)out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                yield var5_4 = bout.toByteArray();
            }
        };
        this.sentSizes.put("HANDSHAKE", this.sentSizes.getOrDefault("HANDSHAKE", 0) + sentData.length);
        MsgEncryptionMod.messageHandler.sendConnectionData(this.connectionId, sentData, false);
    }

    public void sendGroupHandshakeData(String op, class_2487 data) {
        data.method_10582("op", op);
        this.sendData("GROUP_HANDSHAKE", data, false);
    }

    @Override
    public void sendData(String op, class_2487 data, boolean includeSelf) {
        if (this.key == null && this.purpose == DirectConnectionPurpose.DIRECT) {
            this.sendQueue.add(new QueuedMessage(data, op, includeSelf));
            return;
        }
        class_2487 obj = new class_2487();
        obj.method_10582("op", op);
        obj.method_10566("data", (class_2520)data);
        byte[] sentData = switch (this.sendFormat) {
            default -> throw new J_L_MatchException(null, null);
            case PeerTransportFormat.JSON -> {
                byte[] var6_5;
                yield var6_5 = GSON.toJson(NbtConverter.nbtToJson((class_2520)obj)).getBytes(StandardCharsets.UTF_8);
            }
            case PeerTransportFormat.SNBT -> {
                byte[] var6_5;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try (DataOutputStream out = new DataOutputStream(bout);){
                    class_2507.method_10628((class_2487)obj, (DataOutput)out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                yield var6_5 = bout.toByteArray();
            }
        };
        sentData = this.encryptData(sentData);
        this.sentSizes.put(op, this.sentSizes.getOrDefault(op, 0) + sentData.length);
        MsgEncryptionMod.messageHandler.sendConnectionData(this.connectionId, sentData, includeSelf);
    }

    private byte[] encryptData(byte[] data) {
        if (this.key == null) {
            return new byte[0];
        }
        byte[] ivBytes = new byte[12];
        new SecureRandom().nextBytes(ivBytes);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, ivBytes);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)this.key, gcmSpec);
            byte[] encrypted = cipher.doFinal(data);
            byte[] send = new byte[encrypted.length + ivBytes.length];
            System.arraycopy(ivBytes, 0, send, 0, ivBytes.length);
            System.arraycopy(encrypted, 0, send, ivBytes.length, encrypted.length);
            return send;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] decryptData(byte[] data) {
        byte[] iv = new byte[12];
        System.arraycopy(data, 0, iv, 0, 12);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)this.key, gcmSpec);
            byte[] input = new byte[data.length - 12];
            System.arraycopy(data, 12, input, 0, input.length);
            return cipher.doFinal(input);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public void convertToGroup(UUID groupId) {
        if (this.purpose == DirectConnectionPurpose.DIRECT) {
            this.purpose = DirectConnectionPurpose.GROUP_DATA;
            this.groupIdBinding = groupId;
            class_2487 obj = new class_2487();
            obj.method_10582("group_id", groupId.toString());
            this.sendHandshakeData("GROUP_CONNECTION", obj);
            PendingGroupConnection group = MsgEncryptionMod.messageHandler.getPendingGroup(groupId);
            if (group != null) {
                group.markConnectionReady(this.connectionId);
                if (group.isConnectionReady()) {
                    group.markReady(group.selfUuid);
                    group.broadcast("CONNECTION_READY");
                    MsgEncryptionMod.messageHandler.checkGroupReady(groupId);
                }
            }
        }
    }

    public void sendFormatChangeRequest(PeerTransportFormat format) {
        class_2487 req = new class_2487();
        req.method_10582("transportFormat", format.name());
        this.sendHandshakeData("FORMAT_CHANGE_REQ", req);
    }

    public void sendFormatChangeResponse(PeerTransportFormat format) {
        class_2487 req = new class_2487();
        req.method_10582("transportFormat", format.name());
        this.sendHandshakeData("FORMAT_CHANGE_ACCEPT_REQ", req);
    }

    public void sendFormatChangeAcceptResponse(PeerTransportFormat format) {
        class_2487 req = new class_2487();
        req.method_10582("transportFormat", format.name());
        this.sendHandshakeData("FORMAT_CHANGE_RESP", req);
    }

    public void sendConnectionPublicKey(byte[] publicKey) {
        class_2487 req = new class_2487();
        req.method_10570("publicKey", publicKey);
        this.sendHandshakeData("PUBLIC_KEY", req);
    }

    public void sendConnectionVerification(byte[] verificationData) {
        class_2487 req = new class_2487();
        req.method_10570("verification", verificationData);
        this.sendHandshakeData("VERIFICATION_DATA", req);
    }

    public void sendConnectionKeyExchangeFailure() {
        class_2487 req = new class_2487();
        req.method_10582("status", "KEY_EXCHANGE_FAILED");
        this.sendHandshakeData("STATUS", req);
    }

    public void sendConnectionKeyExchangeSuccess() {
        class_2487 req = new class_2487();
        req.method_10582("status", "KEY_EXCHANGE_SUCCESS");
        this.sendHandshakeData("STATUS", req);
    }

    public void sendConnectionStartKeyExchange() {
        class_2487 req = new class_2487();
        req.method_10582("status", "START_KEY_EXCHANGE");
        this.sendHandshakeData("STATUS", req);
    }

    public void sendConnectionKeyGenerated() {
        class_2487 req = new class_2487();
        req.method_10582("status", "KEYS_GENERATED");
        this.sendHandshakeData("STATUS", req);
    }

    private record QueuedMessage(class_2487 data, String op, boolean includeSelf) {
    }
}

