/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public record ConnectionCreateRequestPacket(int requestId, byte[] hashedUsername, byte[] hashedUuid) implements Packet
{
    public ConnectionCreateRequestPacket {
        if (hashedUsername != null && hashedUsername.length != 20) {
            throw new IllegalArgumentException("hashedUsername must be of length 20");
        }
        if (hashedUuid != null && hashedUuid.length != 20) {
            throw new IllegalArgumentException("hashedUuid must be of length 20");
        }
    }

    public static ConnectionCreateRequestPacket fromBinary(DataInputStream input) throws IOException {
        int flags = input.readUnsignedByte();
        int requestId = input.readInt();
        byte[] username = (flags & 1) != 0 ? input.readNBytes(20) : null;
        byte[] uuid = (flags & 2) != 0 ? input.readNBytes(20) : null;
        return new ConnectionCreateRequestPacket(requestId, username, uuid);
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        int flags = (this.hashedUsername != null ? 1 : 0) | (this.hashedUuid != null ? 2 : 0);
        output.writeByte(flags);
        output.writeInt(this.requestId);
        if (this.hashedUsername != null) {
            output.write(this.hashedUsername);
        }
        if (this.hashedUuid != null) {
            output.write(this.hashedUuid);
        }
    }

    @Override
    public PacketType type() {
        return PacketType.CONNECTION_CREATE_REQUEST;
    }
}

