/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public record ConnectionDataPacket(UUID connectionId, UUID source, byte[] data) implements Packet
{
    public static ConnectionDataPacket fromBinary(DataInputStream input) throws IOException {
        return new ConnectionDataPacket(new UUID(input.readLong(), input.readLong()), new UUID(input.readLong(), input.readLong()), input.readNBytes(input.readInt()));
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeLong(this.connectionId.getMostSignificantBits());
        output.writeLong(this.connectionId.getLeastSignificantBits());
        output.writeLong(this.source.getMostSignificantBits());
        output.writeLong(this.source.getLeastSignificantBits());
        output.writeInt(this.data.length);
        output.write(this.data);
    }

    @Override
    public PacketType type() {
        return PacketType.CONNECTION_DATA;
    }
}

