/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.epicpix.msg_encryption.MessageHandler;
import dev.epicpix.msg_encryption.MsgEncryptionMod;
import dev.epicpix.msg_encryption.NotificationHandler;
import dev.epicpix.msg_encryption.api.CommonConnection;
import dev.epicpix.msg_encryption.api.DirectConnection;
import dev.epicpix.msg_encryption.api.GroupConnection;
import dev.epicpix.msg_encryption.api.MsgEncryptionAPI;
import dev.epicpix.msg_encryption.api.PlayerStatus;
import dev.epicpix.msg_encryption.arguments.PlayerArgumentType;
import dev.epicpix.msg_encryption.config.ModConfig;
import dev.epicpix.msg_encryption.stats.ConnectionStats;
import dev.epicpix.msg_encryption.stats.MessageHandlerStats;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class LocalCommandDispatcher {
    private static CommandDispatcher<Object> dispatcher;
    private static final ArrayList<String> shownWarningList;
    public static UUID lastPlayer;
    public static UUID lastConnection;

    public static void trySendMessage(UUID connectionId, String message, Runnable declinedCallback) {
        MsgEncryptionMod.messageHandler.getConnection(connectionId, connection -> {
            lastConnection = connection.connectionId;
            lastPlayer = connection.recipient.uuid();
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            config.lastMessagedPlayer = lastPlayer;
            AutoConfig.getConfigHolder(ModConfig.class).save();
            connection.sendMessage(message);
        }, () -> MsgEncryptionMod.messageHandler.getPlayerStatus(null, lastPlayer).handleAsync((playerStatus, e) -> {
            if (playerStatus == PlayerStatus.UNAVAILABLE) {
                MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.not_available").method_27692(class_124.field_1061));
                return null;
            }
            if (playerStatus == PlayerStatus.OFF_GATEWAY) {
                MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.not_online").method_27692(class_124.field_1061));
                return null;
            }
            if (playerStatus == PlayerStatus.ON_GATEWAY_AWAY) {
                MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.away").method_27692(class_124.field_1061));
                return null;
            }
            declinedCallback.run();
            return null;
        }));
    }

    public static void trySendMessage(String username, UUID uuid, String message, Runnable declinedCallback) {
        MsgEncryptionMod.messageHandler.getDirectConnection(username, uuid, connection -> {
            lastConnection = connection.connectionId;
            lastPlayer = connection.recipient.uuid();
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            config.lastMessagedPlayer = lastPlayer;
            AutoConfig.getConfigHolder(ModConfig.class).save();
            connection.sendMessage(message);
        }, () -> MsgEncryptionMod.messageHandler.getPlayerStatus(username, uuid).handleAsync((playerStatus, e) -> {
            if (playerStatus == PlayerStatus.UNAVAILABLE) {
                MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.not_available").method_27692(class_124.field_1061));
                return null;
            }
            if (playerStatus == PlayerStatus.OFF_GATEWAY) {
                MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.not_online").method_27692(class_124.field_1061));
                return null;
            }
            if (playerStatus == PlayerStatus.ON_GATEWAY_AWAY) {
                MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.away").method_27692(class_124.field_1061));
                return null;
            }
            declinedCallback.run();
            return null;
        }));
    }

    public static boolean execute(String command) {
        if (dispatcher == null) {
            dispatcher = new CommandDispatcher();
            RequiredArgumentBuilder playerArgument = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(RequiredArgumentBuilder.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
                String player = StringArgumentType.getString((CommandContext)context, (String)"player");
                String message = StringArgumentType.getString((CommandContext)context, (String)"message");
                if (MsgEncryptionMod.messageHandler == null || !MsgEncryptionMod.messageHandler.isConnected()) {
                    return 0;
                }
                if (player.equalsIgnoreCase(class_310.method_1551().method_1548().method_1676())) {
                    return 0;
                }
                PlayerStatus playerStatus = MsgEncryptionMod.messageHandler.getPlayerStatus(player, null).join();
                if (playerStatus == PlayerStatus.UNAVAILABLE || playerStatus == PlayerStatus.ON_GATEWAY_AWAY) {
                    return 0;
                }
                if (playerStatus == PlayerStatus.OFF_GATEWAY) {
                    if (!shownWarningList.contains(player)) {
                        MsgEncryptionMod.addMessage((class_2561)class_2561.method_43469((String)"epme.chat.not_using_encrypted_messages", (Object[])new Object[]{player}).method_27692(class_124.field_1061));
                        shownWarningList.add(player);
                    }
                    return 0;
                }
                MsgEncryptionMod.messageHandler.getDirectConnection(player, null, connection -> {
                    lastConnection = connection.connectionId;
                    lastPlayer = connection.recipient.uuid();
                    ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                    config.lastMessagedPlayer = lastPlayer;
                    AutoConfig.getConfigHolder(ModConfig.class).save();
                    connection.sendMessage(message);
                }, () -> MsgEncryptionMod.addMessage((class_2561)class_2561.method_43469((String)"epme.chat.connection_failed", (Object[])new Object[]{player}).method_27692(class_124.field_1061)));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"msg").then((ArgumentBuilder)playerArgument));
            dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"w").then((ArgumentBuilder)playerArgument));
            dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tell").then((ArgumentBuilder)playerArgument));
        }
        try {
            return dispatcher.execute(command, (Object)class_310.method_1551()) == 1;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static void registerClientCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (!config.encryptedMessageCommand.isEmpty()) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)config.encryptedMessageCommand).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"player", (ArgumentType)new PlayerArgumentType()).then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(data -> {
                if (MsgEncryptionMod.messageHandler == null || !MsgEncryptionMod.messageHandler.isConnected()) {
                    MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.not_connected").method_27692(class_124.field_1061));
                    return 0;
                }
                String player = (String)data.getArgument("player", String.class);
                if (player.equalsIgnoreCase(class_310.method_1551().method_1548().method_1676())) {
                    MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.self").method_27692(class_124.field_1061));
                    return 0;
                }
                String message = (String)data.getArgument("message", String.class);
                LocalCommandDispatcher.trySendMessage(player, null, message, () -> MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.declined").method_27692(class_124.field_1061)));
                return 1;
            }))).executes(context -> {
                if (MsgEncryptionMod.messageHandler == null || !MsgEncryptionMod.messageHandler.isConnected()) {
                    MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.not_connected").method_27692(class_124.field_1061));
                    return 0;
                }
                String player = StringArgumentType.getString((CommandContext)context, (String)"player");
                if (player.equalsIgnoreCase(class_310.method_1551().method_1548().method_1676())) {
                    return 0;
                }
                PlayerStatus playerStatus = MsgEncryptionMod.messageHandler.getPlayerStatus(player, null).join();
                if (playerStatus == PlayerStatus.UNAVAILABLE || playerStatus == PlayerStatus.ON_GATEWAY_AWAY) {
                    return 0;
                }
                if (playerStatus == PlayerStatus.OFF_GATEWAY) {
                    MsgEncryptionMod.addMessage((class_2561)class_2561.method_43469((String)"epme.chat.not_using_encrypted_messages", (Object[])new Object[]{player}).method_27692(class_124.field_1061));
                    shownWarningList.add(player);
                    return 0;
                }
                MsgEncryptionMod.messageHandler.getDirectConnection(player, null, connection -> MsgEncryptionMod.addMessage((class_2561)class_2561.method_43469((String)"epme.chat.connection_success", (Object[])new Object[]{player}).method_27692(class_124.field_1060)), () -> MsgEncryptionMod.addMessage((class_2561)class_2561.method_43469((String)"epme.chat.connection_failed", (Object[])new Object[]{player}).method_27692(class_124.field_1061)));
                return 1;
            })));
        }
        if (!config.nonEncryptedMessageCommand.isEmpty()) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)config.nonEncryptedMessageCommand).then(ClientCommandManager.argument((String)"player", (ArgumentType)new PlayerArgumentType()).then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(data -> {
                String player = (String)data.getArgument("player", String.class);
                String message = (String)data.getArgument("message", String.class);
                class_310.method_1551().field_1724.field_3944.method_45730("msg " + player + " " + message);
                return 1;
            }))));
        }
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"edebugstats").executes(data -> {
            if (MsgEncryptionMod.messageHandler == null) {
                MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.handler_not_found").method_27692(class_124.field_1061));
                return 0;
            }
            MessageHandlerStats stats = MsgEncryptionMod.messageHandler.getStats();
            ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Encrypted Messages Stats").method_27692(class_124.field_1065));
            ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Connected: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)Boolean.toString(MsgEncryptionMod.messageHandler.isConnected())).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (encrypted)").method_27692(class_124.field_1065)));
            ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Received ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(stats.totalEncryptedRecvBytes() + " bytes")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (encrypted)").method_27692(class_124.field_1065)));
            ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Received ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(stats.totalDecryptedRecvBytes() + " bytes")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (decrypted)").method_27692(class_124.field_1065)));
            ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Sent ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(stats.totalEncryptedSentBytes() + " bytes")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (encrypted)").method_27692(class_124.field_1065)));
            ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Sent ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(stats.totalDecryptedSentBytes() + " bytes")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (decrypted)").method_27692(class_124.field_1065)));
            if (!stats.connectionStats().isEmpty()) {
                ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Encrypted Messages (Connection) Stats").method_27692(class_124.field_1065));
                for (Map.Entry<DirectConnection, ConnectionStats> entry : stats.connectionStats().entrySet()) {
                    ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)entry.getKey().connectionId.toString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1075).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Recipient: " + entry.getKey().recipient.username() + " (" + String.valueOf(entry.getKey().recipient.uuid()) + ")")))))).method_10852((class_2561)class_2561.method_43470((String)":").method_27692(class_124.field_1065)));
                    ConnectionStats conStats = entry.getValue();
                    HashMap<String, IntIntPair> info = new HashMap<String, IntIntPair>();
                    for (Map.Entry<String, Integer> entry2 : conStats.sentSizes().entrySet()) {
                        info.put(entry2.getKey(), IntIntPair.of((int)entry2.getValue(), (int)0));
                    }
                    Iterator<Map.Entry<String, Integer>> iterator = conStats.recvSizes().entrySet().iterator();
                    while (iterator.hasNext()) {
                        IntIntPair prev;
                        Map.Entry<String, Integer> entry3;
                        info.put(entry3.getKey(), IntIntPair.of((int)((prev = (IntIntPair)info.get((entry3 = iterator.next()).getKey())) != null ? prev.leftInt() : 0), (int)entry3.getValue()));
                    }
                    for (Map.Entry<String, Integer> entry4 : info.entrySet()) {
                        ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)entry4.getKey()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - Sent: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(((IntIntPair)entry4.getValue()).leftInt() + " bytes")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", Received: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(((IntIntPair)entry4.getValue()).rightInt() + " bytes")).method_27692(class_124.field_1075)));
                    }
                }
            }
            if (!stats.groupStats().isEmpty()) {
                ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Encrypted Messages (Group) Stats").method_27692(class_124.field_1065));
                for (Map.Entry<CommonConnection, ConnectionStats> entry : stats.groupStats().entrySet()) {
                    String participants = ((GroupConnection)entry.getKey()).participants.stream().map(v -> v.username() + " (" + String.valueOf(v.uuid()) + ")").collect(Collectors.joining("\n"));
                    String connectionIds = MsgEncryptionMod.messageHandler.getGroupConnections(((GroupConnection)entry.getKey()).groupId).stream().map(v -> "- " + String.valueOf(v)).collect(Collectors.joining("\n"));
                    ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)((GroupConnection)entry.getKey()).groupId.toString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1075).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Participants:\n" + participants + "\n\nConnection IDs:\n" + connectionIds)))))).method_10852((class_2561)class_2561.method_43470((String)":").method_27692(class_124.field_1065)));
                    ConnectionStats conStats = entry.getValue();
                    HashMap<String, IntIntPair> hashMap = new HashMap<String, IntIntPair>();
                    for (Map.Entry<String, Integer> entry5 : conStats.sentSizes().entrySet()) {
                        hashMap.put(entry5.getKey(), IntIntPair.of((int)entry5.getValue(), (int)0));
                    }
                    Iterator<Map.Entry<String, Integer>> iterator = conStats.recvSizes().entrySet().iterator();
                    while (iterator.hasNext()) {
                        IntIntPair prev;
                        Map.Entry<String, Integer> entry6;
                        hashMap.put(entry6.getKey(), IntIntPair.of((int)((prev = (IntIntPair)hashMap.get((entry6 = iterator.next()).getKey())) != null ? prev.leftInt() : 0), (int)entry6.getValue()));
                    }
                    for (Map.Entry<String, Integer> entry7 : hashMap.entrySet()) {
                        ((FabricClientCommandSource)data.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)entry7.getKey()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - Sent: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(((IntIntPair)entry7.getValue()).leftInt() + " bytes")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", Received: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(((IntIntPair)entry7.getValue()).rightInt() + " bytes")).method_27692(class_124.field_1075)));
                    }
                }
            }
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ereconnect").executes(data -> {
            MessageHandler newMessageHandler = new MessageHandler(true);
            MsgEncryptionMod.setMessageHandler(newMessageHandler);
            if (!MsgEncryptionAPI.connectToMessageServer(MsgEncryptionAPI.getMessageServerAddress(), newMessageHandler)) {
                NotificationHandler.showTranslatableNotification("disconnected");
                return 0;
            }
            return 1;
        }));
        if (!config.encryptedReplyCommand.isEmpty()) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)config.encryptedReplyCommand).then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(data -> {
                if (MsgEncryptionMod.messageHandler == null || !MsgEncryptionMod.messageHandler.isConnected()) {
                    MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.not_connected").method_27692(class_124.field_1061));
                    return 0;
                }
                String message = (String)data.getArgument("message", String.class);
                if (lastConnection == null) {
                    if (config.lastMessagedPlayer != null) {
                        LocalCommandDispatcher.trySendMessage(null, config.lastMessagedPlayer, message, () -> MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.declined").method_27692(class_124.field_1061)));
                        return 0;
                    }
                    MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.no_last_message").method_27692(class_124.field_1061));
                    return 0;
                }
                LocalCommandDispatcher.trySendMessage(lastConnection, message, () -> LocalCommandDispatcher.trySendMessage(null, lastPlayer, message, () -> MsgEncryptionMod.addMessage((class_2561)class_2561.method_43471((String)"epme.chat.failed_send.declined").method_27692(class_124.field_1061))));
                return 1;
            })));
        }
    }

    static {
        shownWarningList = new ArrayList();
        lastPlayer = null;
        lastConnection = null;
    }
}

