/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api;

import com.google.common.net.HostAndPort;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.exceptions.AuthenticationException;
import dev.epicpix.msg_encryption.MsgEncryptionMod;
import dev.epicpix.msg_encryption.api.IMessageHandler;
import dev.epicpix.msg_encryption.config.ModConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_310;

public class MsgEncryptionAPI {
    public static final String MOD_VERSION = "2.1.0";
    private static final byte[] SHARED_BYTES = new BigInteger("72151d7ccc98765805f8d3f381c1e797", 16).toByteArray();
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private static final Gson GSON = new Gson();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final String EPME_HOST = "epme.mods.epicpix.dev";
    public static final String SRV_RECORD = "_epme._tcp.epme.mods.epicpix.dev";
    public static final String BASE_API_URL = "https://epme.mods.epicpix.dev/api/v1";
    public static final String AUTH_URL = "https://auth.mods.epicpix.dev/api/v1/authenticate_minecraft";
    public static final String VERSION_URL = "https://versions.mods.epicpix.dev/api/v1/epme/version";
    public static final String TOKEN_PROPERTY_NAME = "EPME_ACCESS_TOKEN";
    private static final JsonObject RESPONSE_ERROR = new JsonObject();
    public static final ExecutorService executorService;

    private static JsonObject get(String endpoint) {
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().uri(new URI(BASE_API_URL + endpoint)).header("X-Mod-Version", MOD_VERSION).build();
            String response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString()).body();
            return (JsonObject)GSON.fromJson(response, JsonObject.class);
        }
        catch (JsonSyntaxException | IOException | InterruptedException | URISyntaxException e) {
            return RESPONSE_ERROR;
        }
    }

    public static String getAuthToken() {
        try {
            if (MsgEncryptionAPI.authenticateUsingMinecraft()) {
                return System.getProperty(TOKEN_PROPERTY_NAME);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static synchronized boolean authenticateUsingMinecraft() throws URISyntaxException, IOException, InterruptedException, NoSuchAlgorithmException, AuthenticationException {
        if (System.getProperty(TOKEN_PROPERTY_NAME) == null) {
            return MsgEncryptionAPI.authenticateUsingMinecraft0();
        }
        return true;
    }

    private static boolean authenticateUsingMinecraft0() throws URISyntaxException, IOException, InterruptedException, NoSuchAlgorithmException, AuthenticationException {
        class_310 client = class_310.method_1551();
        for (int tryNumber = 0; tryNumber < 3; ++tryNumber) {
            byte[] bytes = new byte[16];
            SECURE_RANDOM.nextBytes(bytes);
            byte[] allBytes = new byte[32];
            System.arraycopy(bytes, 0, allBytes, 0, 16);
            System.arraycopy(SHARED_BYTES, 0, allBytes, 16, 16);
            byte[] sha1d = MessageDigest.getInstance("SHA-1").digest(allBytes);
            String sha1 = new BigInteger(sha1d).toString(16);
            client.method_73361().comp_837().joinServer(client.method_1548().method_44717(), client.method_1548().method_1674(), sha1);
            JsonObject data = new JsonObject();
            data.addProperty("username", client.method_1548().method_1676());
            data.addProperty("auth", Base64.getEncoder().encodeToString(bytes));
            String response = HTTP_CLIENT.send(HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)data))).uri(new URI(AUTH_URL)).header("Content-Type", "application/json").build(), HttpResponse.BodyHandlers.ofString()).body();
            try {
                JsonObject result = (JsonObject)GSON.fromJson(response, JsonObject.class);
                if (result.get("ok").getAsBoolean()) {
                    String token = result.get("token").getAsString();
                    JsonObject tokenData = (JsonObject)GSON.fromJson(new String(Base64.getDecoder().decode(token.split("\\.")[1]), StandardCharsets.UTF_8), JsonObject.class);
                    executorService.submit(() -> {
                        try {
                            Thread.sleep(tokenData.get("exp").getAsLong() * 1000L - System.currentTimeMillis());
                            System.clearProperty(TOKEN_PROPERTY_NAME);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    });
                    System.setProperty(TOKEN_PROPERTY_NAME, token);
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (JsonSyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public static HostAndPort getMessageServerAddress() {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(SRV_RECORD, new String[]{"SRV"});
            Attribute attribute = attributes.get("srv");
            if (attribute != null) {
                String[] parts = attribute.get().toString().split(" ", 4);
                return HostAndPort.fromParts((String)parts[3], (int)Integer.parseInt(parts[2]));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean connectToMessageServer(HostAndPort address, IMessageHandler handler) {
        String host = address.getHost();
        int port = address.getPort();
        try {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(30000);
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            DataInputStream input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            handler.setSocket(socket, output);
            handler.handleOpen();
            executorService.submit(() -> {
                try {
                    try {
                        while (true) {
                            int dataLength = input.readInt();
                            byte[] data = input.readNBytes(dataLength);
                            handler.handleData(data);
                        }
                    }
                    catch (Exception ignored) {
                        boolean isCurrentHandler = handler == MsgEncryptionMod.messageHandler;
                        handler.handleClose(isCurrentHandler, isCurrentHandler);
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            });
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static PublicKey getServerPublicKey() {
        JsonObject keyData = MsgEncryptionAPI.get("/key");
        if (!keyData.get("ok").getAsBoolean()) {
            return null;
        }
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        String key = keyData.get("public_key").getAsString();
        config.knownServerKeys.add(key);
        byte[] bytes = Base64.getDecoder().decode(key);
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
            return KeyFactory.getInstance("RSA").generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return null;
        }
    }

    public static String getLatestVersion(String minecraftVersion) {
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().uri(new URI("https://versions.mods.epicpix.dev/api/v1/epme/version?minecraft_version=" + minecraftVersion)).header("X-Mod-Version", MOD_VERSION).build();
            String response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString()).body();
            JsonObject newest = (JsonObject)GSON.fromJson(response, JsonObject.class);
            if (!newest.get("ok").getAsBoolean()) {
                return null;
            }
            return newest.get("version").getAsString();
        }
        catch (JsonSyntaxException | IOException | InterruptedException | URISyntaxException throwable) {
            return null;
        }
    }

    static {
        RESPONSE_ERROR.addProperty("ok", Boolean.valueOf(false));
        executorService = Executors.newFixedThreadPool(4);
    }
}

