/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.ClientState;
import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public record ClientStatePacket(ClientState state) implements Packet
{
    public static ClientStatePacket fromBinary(DataInputStream input) throws IOException {
        int index = input.readUnsignedByte();
        ClientState state = switch (index) {
            case 0 -> ClientState.PLAYING;
            case 1 -> ClientState.IN_MENU;
            default -> throw new IllegalStateException("invalid client state: " + index);
        };
        return new ClientStatePacket(state);
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        switch (this.state) {
            case PLAYING: {
                output.writeByte(0);
                break;
            }
            case IN_MENU: {
                output.writeByte(1);
            }
        }
    }

    @Override
    public PacketType type() {
        return PacketType.CLIENT_STATE;
    }
}

