/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.AuthFailureResponsePacket;
import dev.epicpix.msg_encryption.api.packet.AuthRequestPacket;
import dev.epicpix.msg_encryption.api.packet.AuthSuccessResponsePacket;
import dev.epicpix.msg_encryption.api.packet.ClientInfoPacket;
import dev.epicpix.msg_encryption.api.packet.ClientStatePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionClosePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionCreateFailureResponsePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionCreateRequestPacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionCreateSuccessResponsePacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionDataPacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionSendDataPacket;
import dev.epicpix.msg_encryption.api.packet.ConnectionSendGroupDataPacket;
import dev.epicpix.msg_encryption.api.packet.HeartbeatPacket;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import dev.epicpix.msg_encryption.api.packet.PlayerStatusRequestPacket;
import dev.epicpix.msg_encryption.api.packet.PlayerStatusResponsePacket;
import dev.epicpix.msg_encryption.api.packet.PrepareConnectionPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;

public interface Packet {
    public static Packet fromBinary(DataInputStream input) throws IOException {
        int op = input.readUnsignedByte();
        PacketType packetType = PacketType.fromId(op);
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CLIENT_INFO", "AUTH_REQUEST", "AUTH_FAILURE_RESPONSE", "AUTH_SUCCESS_RESPONSE", "CLIENT_STATE", "CONNECTION_CLOSE", "PLAYER_STATUS_REQUEST", "PLAYER_STATUS_RESPONSE", "CONNECTION_CREATE_REQUEST", "CONNECTION_CREATE_FAILURE_RESPONSE", "CONNECTION_CREATE_SUCCESS_RESPONSE", "HEARTBEAT", "PREPARE_CONNECTION", "CONNECTION_SEND_DATA", "CONNECTION_SEND_GROUP_DATA", "CONNECTION_DATA"}, (PacketType)packetType, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> ClientInfoPacket.fromBinary(input);
            case 1 -> AuthRequestPacket.fromBinary(input);
            case 2 -> AuthFailureResponsePacket.fromBinary(input);
            case 3 -> AuthSuccessResponsePacket.fromBinary(input);
            case 4 -> ClientStatePacket.fromBinary(input);
            case 5 -> ConnectionClosePacket.fromBinary(input);
            case 6 -> PlayerStatusRequestPacket.fromBinary(input);
            case 7 -> PlayerStatusResponsePacket.fromBinary(input);
            case 8 -> ConnectionCreateRequestPacket.fromBinary(input);
            case 9 -> ConnectionCreateFailureResponsePacket.fromBinary(input);
            case 10 -> ConnectionCreateSuccessResponsePacket.fromBinary(input);
            case 11 -> HeartbeatPacket.fromBinary(input);
            case 12 -> PrepareConnectionPacket.fromBinary(input);
            case 13 -> ConnectionSendDataPacket.fromBinary(input);
            case 14 -> ConnectionSendGroupDataPacket.fromBinary(input);
            case 15 -> ConnectionDataPacket.fromBinary(input);
            case -1 -> throw new NullPointerException("unknown opcode received: " + op);
        };
    }

    public void toBinaryData(DataOutputStream var1) throws IOException;

    public PacketType type();
}

