/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public record PrepareConnectionPacket(UUID connectionId, String username, UUID uuid) implements Packet
{
    public static PrepareConnectionPacket fromBinary(DataInputStream input) throws IOException {
        return new PrepareConnectionPacket(new UUID(input.readLong(), input.readLong()), input.readUTF(), new UUID(input.readLong(), input.readLong()));
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeLong(this.connectionId.getMostSignificantBits());
        output.writeLong(this.connectionId.getLeastSignificantBits());
        output.writeUTF(this.username);
        output.writeLong(this.uuid.getMostSignificantBits());
        output.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    public PacketType type() {
        return PacketType.PREPARE_CONNECTION;
    }
}

