/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api;

import dev.epicpix.msg_encryption.MsgEncryptionMod;
import dev.epicpix.msg_encryption.api.GroupConnection;
import dev.epicpix.msg_encryption.api.Participant;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PendingGroupConnection {
    public final HashSet<Participant> establishedPlayers = new HashSet();
    public final HashSet<UUID> readyConnections = new HashSet();
    public final HashSet<UUID> readyPlayers = new HashSet();
    public final List<UUID> allPlayers;
    public final UUID groupId;
    public final SecretKey selfKey;
    public final HashMap<UUID, SecretKey> allKeys = new HashMap();
    public final Consumer<GroupConnection> successCallback;
    public final UUID selfUuid;

    public PendingGroupConnection(UUID selfUuid, UUID groupId, List<UUID> allPlayers, Consumer<GroupConnection> successCallback) {
        this.groupId = groupId;
        this.selfUuid = selfUuid;
        this.allPlayers = allPlayers;
        this.successCallback = successCallback;
        byte[] bytes = new byte[64];
        new SecureRandom().nextBytes(bytes);
        this.selfKey = new SecretKeySpec(bytes, "AES");
        this.allKeys.put(selfUuid, this.selfKey);
    }

    public void addKey(Participant player, byte[] bytes) {
        this.establishedPlayers.add(player);
        this.allKeys.put(player.uuid(), new SecretKeySpec(bytes, "AES"));
    }

    public void markConnectionReady(UUID uuid) {
        this.readyConnections.add(uuid);
    }

    public void markReady(UUID uuid) {
        this.readyPlayers.add(uuid);
    }

    public void broadcast(String state) {
        for (UUID player : this.allPlayers) {
            if (player.equals(this.selfUuid)) continue;
            MsgEncryptionMod.messageHandler.getDirectConnection(null, player, conn -> conn.sendGroupState(this.groupId, state), () -> {});
        }
    }

    public boolean isKeyReady() {
        return this.isConnectionReady() && this.establishedPlayers.size() + 1 == this.allPlayers.size() && this.readyPlayers.size() == this.allPlayers.size();
    }

    public boolean isConnectionReady() {
        return this.readyConnections.size() + 1 == this.allPlayers.size();
    }
}

