/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api.packet;

import dev.epicpix.msg_encryption.api.TransportFormat;
import dev.epicpix.msg_encryption.api.packet.Packet;
import dev.epicpix.msg_encryption.api.packet.PacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public record ClientInfoPacket(String modVersion, String minecraftVersion, String host, boolean isReconnecting, TransportFormat transportFormat) implements Packet
{
    public static ClientInfoPacket fromBinary(DataInputStream input) throws IOException {
        String modVersion = input.readUTF();
        String minecraftVersion = input.readUTF();
        String host = input.readUTF();
        boolean isReconnecting = input.readBoolean();
        int transportFormatIndex = input.readUnsignedByte();
        TransportFormat transportFormat = switch (transportFormatIndex) {
            case 0 -> TransportFormat.JSON;
            case 1 -> TransportFormat.BINARY_V1;
            default -> throw new IllegalStateException("invalid transport format: " + transportFormatIndex);
        };
        return new ClientInfoPacket(modVersion, minecraftVersion, host, isReconnecting, transportFormat);
    }

    @Override
    public void toBinaryData(DataOutputStream output) throws IOException {
        output.writeUTF(this.modVersion);
        output.writeUTF(this.minecraftVersion);
        output.writeUTF(this.host);
        output.writeBoolean(this.isReconnecting);
        switch (this.transportFormat) {
            case JSON: {
                output.writeByte(0);
                break;
            }
            case BINARY_V1: {
                output.writeByte(1);
            }
        }
    }

    @Override
    public PacketType type() {
        return PacketType.CLIENT_INFO;
    }
}

