/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.msg_encryption.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.epicpix.msg_encryption.MsgEncryptionMod;
import dev.epicpix.msg_encryption.api.CommonConnection;
import dev.epicpix.msg_encryption.api.ConnectionMessage;
import dev.epicpix.msg_encryption.api.DirectConnection;
import dev.epicpix.msg_encryption.api.NbtConverter;
import dev.epicpix.msg_encryption.api.Participant;
import dev.epicpix.msg_encryption.api.PeerTransportFormat;
import dev.epicpix.msg_encryption.config.ModConfig;
import dev.epicpix.msg_encryption.events.GroupConnectionEndedEvent;
import dev.epicpix.msg_encryption.events.GroupConnectionStartedEvent;
import dev.epicpix.msg_encryption.stats.ConnectionStats;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7591;

public class GroupConnection
implements CommonConnection {
    private static final Gson GSON = new GsonBuilder().create();
    public final UUID groupId;
    public final List<Participant> participants;
    private final List<UUID> connectionIds;
    private final SecretKey key;
    private final PeerTransportFormat sendFormat = PeerTransportFormat.JSON;
    private final PeerTransportFormat recvFormat = PeerTransportFormat.JSON;
    private final HashMap<String, Integer> recvSizes = new HashMap();
    private final HashMap<String, Integer> sentSizes = new HashMap();
    private final HashMap<String, BiConsumer<GroupConnection, ConnectionMessage>> messageTypes = new HashMap();

    @Override
    public ConnectionStats getStats() {
        return new ConnectionStats(new HashMap<String, Integer>(this.recvSizes), new HashMap<String, Integer>(this.sentSizes));
    }

    public GroupConnection(UUID groupId, Participant[] participants, HashMap<UUID, SecretKey> secretKeys) {
        this.groupId = groupId;
        this.participants = Arrays.stream(participants).toList();
        ArrayList<Map.Entry<UUID, SecretKey>> sortedKeys = new ArrayList<Map.Entry<UUID, SecretKey>>(secretKeys.entrySet());
        sortedKeys.sort(Map.Entry.comparingByKey());
        List<byte[]> longKeyList = sortedKeys.stream().map(a -> ((SecretKey)a.getValue()).getEncoded()).toList();
        Integer longKeyLength = longKeyList.stream().map(a -> ((byte[])a).length).reduce(0, Integer::sum);
        byte[] longKey = new byte[longKeyLength.intValue()];
        int index = 0;
        for (byte[] key : longKeyList) {
            System.arraycopy(longKey, index, key, 0, key.length);
            index += key.length;
        }
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            hash.update(longKey);
            byte[] shortKey = hash.digest();
            this.key = new SecretKeySpec(shortKey, "AES");
            this.connectionIds = MsgEncryptionMod.messageHandler.getGroupConnections(groupId);
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (config.displayShortVerificationKey) {
                String num = new BigInteger(shortKey).toString();
                if (num.startsWith("-")) {
                    num = num.substring(1);
                }
                num = num.substring(num.length() - 8);
                String formattedParticipants = Arrays.stream(participants).filter(x -> !x.uuid().equals(MsgEncryptionMod.messageHandler.getUuid())).map(Participant::username).collect(Collectors.joining(", "));
                class_5250 chatMessage = class_2561.method_43469((String)"epme.chat.display_verification_key_group", (Object[])new Object[]{class_2561.method_43470((String)formattedParticipants).method_27692(class_124.field_1056), class_2561.method_43470((String)num).method_27692(class_124.field_1065)}).method_27692(class_124.field_1075);
                MsgEncryptionMod.addMessage((class_2561)chatMessage, config.showEncryptedMessageIndicator ? new class_7591(45232, null, (class_2561)class_2561.method_43469((String)"epme.chat.indicator", (Object[])new Object[]{formattedParticipants}), null) : null);
            }
            ((GroupConnectionStartedEvent)GroupConnectionStartedEvent.EVENT.invoker()).execute(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerMessageType(String op, BiConsumer<GroupConnection, ConnectionMessage> executor) {
        this.messageTypes.put(op, executor);
    }

    public void handleData(UUID source, byte[] data) {
        BiConsumer<GroupConnection, ConnectionMessage> executor;
        class_2487 class_24872;
        byte[] decryptedData = this.decryptData(data);
        switch (this.recvFormat) {
            default: {
                throw new MatchException(null, null);
            }
            case JSON: {
                class_2487 class_24873;
                class_24872 = class_24873 = (class_2487)NbtConverter.jsonToNbt((JsonElement)GSON.fromJson(new String(decryptedData, StandardCharsets.UTF_8), JsonObject.class));
                break;
            }
            case SNBT: {
                class_2487 class_24873;
                try {
                    class_24872 = class_24873 = class_2507.method_10627((DataInput)new DataInputStream(new ByteArrayInputStream(decryptedData)));
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        class_2487 obj = class_24872;
        String op = obj.method_68564("op", "");
        this.recvSizes.put(op, this.recvSizes.getOrDefault(op, 0) + data.length);
        if ("DISBAND_GROUP".equals(op)) {
            for (UUID connectionId : this.connectionIds) {
                MsgEncryptionMod.messageHandler.closeConnection(connectionId);
            }
            MsgEncryptionMod.messageHandler.removeGroup(this.groupId);
        }
        if ((executor = this.messageTypes.get(op)) != null) {
            executor.accept(this, new ConnectionMessage(source, obj.method_68568("data")));
        }
    }

    @Override
    public void sendData(String op, class_2487 data, boolean includeSelf) {
        Object object;
        class_2487 obj = new class_2487();
        obj.method_10582("op", op);
        obj.method_10566("data", (class_2520)data);
        byte[] sentData = switch (this.sendFormat) {
            default -> throw new MatchException(null, null);
            case PeerTransportFormat.JSON -> {
                object = GSON.toJson(NbtConverter.nbtToJson((class_2520)obj)).getBytes(StandardCharsets.UTF_8);
                yield object;
            }
            case PeerTransportFormat.SNBT -> {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try (DataOutputStream out = new DataOutputStream(bout);){
                    class_2507.method_10628((class_2487)obj, (DataOutput)out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                object = bout.toByteArray();
                yield object;
            }
        };
        sentData = this.encryptData(sentData);
        this.sentSizes.put(op, this.sentSizes.getOrDefault(op, 0) + sentData.length);
        MsgEncryptionMod.messageHandler.sendConnectionDataGroup(this.connectionIds, sentData);
        object = this.connectionIds.iterator();
        while (object.hasNext()) {
            UUID connectionId = (UUID)object.next();
            DirectConnection connection = MsgEncryptionMod.messageHandler.getConnectionNow(connectionId);
            if (connection == null) continue;
            connection.updateGroupSendCount(sentData.length);
        }
        if (includeSelf) {
            this.handleData(MsgEncryptionMod.messageHandler.getUuid(), sentData);
        }
    }

    public void disbandGroup() {
        this.sendData("DISBAND_GROUP", new class_2487(), true);
        ((GroupConnectionEndedEvent)GroupConnectionEndedEvent.EVENT.invoker()).execute(this);
    }

    private byte[] encryptData(byte[] data) {
        byte[] ivBytes = new byte[12];
        new SecureRandom().nextBytes(ivBytes);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, ivBytes);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)this.key, gcmSpec);
            byte[] encrypted = cipher.doFinal(data);
            byte[] send = new byte[encrypted.length + ivBytes.length];
            System.arraycopy(ivBytes, 0, send, 0, ivBytes.length);
            System.arraycopy(encrypted, 0, send, ivBytes.length, encrypted.length);
            return send;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] decryptData(byte[] data) {
        byte[] iv = new byte[12];
        System.arraycopy(data, 0, iv, 0, 12);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)this.key, gcmSpec);
            byte[] input = new byte[data.length - 12];
            System.arraycopy(data, 12, input, 0, input.length);
            return cipher.doFinal(input);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

