/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.menus;

import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.builders.gui.DynamicInventoryBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.Permissions;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.tasks.menus.CrateMainMenu;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiFiller;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import com.ryderbelserion.fusion.paper.api.builders.gui.types.PaginatedGui;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateAdminMenu
extends DynamicInventoryBuilder {
    private final Player player = this.getPlayer();
    private final PaginatedGui gui = this.getGui();

    public CrateAdminMenu(@NotNull Player player) {
        super(player, "<bold><red>Admin Keys</bold>", 6);
    }

    @Override
    public void open() {
        GuiFiller guiFiller = this.gui.getFiller();
        GuiItem guiItem = new GuiItem((ItemType)ItemType.BLACK_STAINED_GLASS_PANE);
        guiFiller.fillTop(guiItem);
        guiFiller.fillBottom(guiItem);
        this.crateManager.getUsableCrates().forEach(crate -> this.gui.addItem(new GuiItem(crate.getKey(1), action -> {
            if (!Permissions.CRAZYCRATES_ACCESS.hasPermission(this.player)) {
                Messages.no_permission.sendMessage((CommandSender)this.player);
                this.gui.close(this.player, InventoryCloseEvent.Reason.CANT_USE, false);
                return;
            }
            String fileName = crate.getFileName();
            UUID uuid = this.player.getUniqueId();
            ClickType click = action.getClick();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{amount}", "1");
            placeholders.put("{key}", crate.getKeyName());
            Location location = this.player.getLocation();
            switch (click) {
                case LEFT: {
                    if (!MiscUtils.isInventoryFull(this.player)) {
                        new FoliaScheduler(this.plugin, location, (Crate)crate){
                            final /* synthetic */ Crate val$crate;
                            {
                                this.val$crate = crate;
                                super(arg0, arg1);
                            }

                            @Override
                            public void run() {
                                MiscUtils.addItem(CrateAdminMenu.this.player, this.val$crate.getKey(CrateAdminMenu.this.player));
                            }
                        }.runNow();
                        this.player.playSound(location, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 1.0f, 1.0f);
                        placeholders.put("{keytype}", KeyType.physical_key.getFriendlyName());
                        Messages.obtaining_keys.sendMessage((CommandSender)this.player, placeholders);
                        return;
                    }
                    this.player.playSound(location, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    break;
                }
                case SHIFT_LEFT: {
                    if (MiscUtils.isInventoryFull(this.player)) {
                        new FoliaScheduler(this.plugin, location, (Crate)crate){
                            final /* synthetic */ Crate val$crate;
                            {
                                this.val$crate = crate;
                                super(arg0, arg1);
                            }

                            @Override
                            public void run() {
                                MiscUtils.addItem(CrateAdminMenu.this.player, this.val$crate.getKey(8, CrateAdminMenu.this.player));
                            }
                        }.runNow();
                        this.player.playSound(location, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 1.0f, 1.0f);
                        placeholders.put("{keytype}", KeyType.physical_key.getFriendlyName());
                        placeholders.put("{amount}", "8");
                        Messages.obtaining_keys.sendMessage((CommandSender)this.player, placeholders);
                        return;
                    }
                    this.player.playSound(location, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    break;
                }
                case RIGHT: {
                    this.userManager.addKeys(uuid, fileName, KeyType.virtual_key, 1);
                    this.player.playSound(location, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 1.0f, 1.0f);
                    placeholders.put("{keytype}", KeyType.physical_key.getFriendlyName());
                    Messages.obtaining_keys.sendMessage((CommandSender)this.player, placeholders);
                    break;
                }
                case SHIFT_RIGHT: {
                    this.userManager.addKeys(uuid, fileName, KeyType.virtual_key, 8);
                    this.player.playSound(location, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 1.0f, 1.0f);
                    placeholders.put("{keytype}", KeyType.physical_key.getFriendlyName());
                    placeholders.put("{amount}", "8");
                    Messages.obtaining_keys.sendMessage((CommandSender)this.player, placeholders);
                }
            }
        })));
        this.gui.open(this.player, gui -> {
            int rows = gui.getRows();
            gui.setItem(rows, 5, ((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder(this.plugin, (ItemType)ItemType.CHEST).setDisplayName("<red>What is this menu?")).addDisplayLore(" <gold>\u2937 Right click to go back to the main menu!")).addDisplayLore("")).addDisplayLore("<light_purple>A cheat cheat menu of all your available keys.")).addDisplayLore(" <gold>\u2937 Right click to get virtual keys.")).addDisplayLore(" <gold>\u2937 Shift right click to get 8 virtual keys.")).addDisplayLore(" <gold>\u2937 Left click to get physical keys.")).addDisplayLore(" <gold>\u2937 Shift left click to get 8 physical keys.")).asGuiItem(action -> {
                if (!Permissions.CRAZYCRATES_ACCESS.hasPermission(this.player)) {
                    Messages.no_permission.sendMessage((CommandSender)this.player);
                    gui.close(this.player, InventoryCloseEvent.Reason.CANT_USE, false);
                    return;
                }
                if (this.config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
                    this.player.playSound(this.player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    new CrateMainMenu(this.player, this.config.getProperty(ConfigKeys.inventory_name), this.config.getProperty(ConfigKeys.inventory_rows)).open();
                }
            }));
            this.addBackButton(false);
            this.addNextButton(false);
        });
    }
}

