/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extension;

import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.extension.CommandExtensions;
import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.extension.annotation.AnnotationProcessor;
import dev.triumphteam.cmd.core.extension.argument.ArgumentValidator;
import dev.triumphteam.cmd.core.extension.command.CommandExecutor;
import dev.triumphteam.cmd.core.extension.command.Processor;
import dev.triumphteam.cmd.core.extension.sender.SenderExtension;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ExtensionBuilder<D, S, ST> {
    private final Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> annotationProcessors = new HashMap<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>>();
    private final List<Processor<D, S>> processors = new ArrayList<Processor<D, S>>();
    private SenderExtension<D, S> senderExtension = null;
    private ArgumentValidator<S, ST> argumentValidator = null;
    private CommandExecutor<S> commandExecutor = null;
    private SuggestionMapper<ST> suggestionMapper = null;

    @Contract(value="_, _ -> this")
    @NotNull
    public <A extends Annotation> ExtensionBuilder<D, S, ST> addAnnotationProcessor(Class<A> annotation, @NotNull AnnotationProcessor<A> annotationProcessor) {
        this.annotationProcessors.put(annotation, annotationProcessor);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S, ST> addProcessor(@NotNull Processor<D, S> processor) {
        this.processors.add(processor);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S, ST> setArgumentValidator(@NotNull ArgumentValidator<S, ST> argumentValidator) {
        this.argumentValidator = argumentValidator;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S, ST> setCommandExecutor(@NotNull CommandExecutor<S> commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S, ST> setSenderExtension(@NotNull SenderExtension<D, S> senderExtension) {
        this.senderExtension = senderExtension;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S, ST> setSuggestionMapper(@NotNull SuggestionMapper<ST> suggestionMapper) {
        this.suggestionMapper = suggestionMapper;
        return this;
    }

    @NotNull
    public CommandExtensions<D, S, ST> build(@NotNull SenderExtension<D, S> defaultExtension) {
        if (this.argumentValidator == null) {
            throw new CommandRegistrationException("No argument validator was added to Command Manager.");
        }
        if (this.commandExecutor == null) {
            throw new CommandRegistrationException("No command executor was added to Command Manager.");
        }
        if (this.suggestionMapper == null) {
            throw new CommandRegistrationException("No suggestion mapper was added to Command Manager.");
        }
        return new CommandExtensions<D, S, ST>(this.senderExtension == null ? defaultExtension : this.senderExtension, this.annotationProcessors, this.processors, this.argumentValidator, this.commandExecutor, this.suggestionMapper);
    }
}

