/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.internal.ConversionUtils;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.ArrayPropertyType;
import ch.jalu.configme.properties.types.InlineArrayPropertyType;
import ch.jalu.configme.properties.types.PropertyAndLeafType;
import ch.jalu.typeresolver.TypeInfo;
import ch.jalu.typeresolver.numbers.StandardNumberType;
import ch.jalu.typeresolver.numbers.ValueRangeComparison;
import ch.jalu.typeresolver.primitives.PrimitiveType;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberType<N extends Number>
extends PropertyAndLeafType<N> {
    public static final NumberType<Byte> BYTE = new NumberType<Byte>(StandardNumberType.TYPE_BYTE);
    public static final NumberType<Short> SHORT = new NumberType<Short>(StandardNumberType.TYPE_SHORT);
    public static final NumberType<Integer> INTEGER = new NumberType<Integer>(StandardNumberType.TYPE_INTEGER);
    public static final NumberType<Long> LONG = new NumberType<Long>(StandardNumberType.TYPE_LONG);
    public static final NumberType<Float> FLOAT = new NumberType<Float>(StandardNumberType.TYPE_FLOAT);
    public static final NumberType<Double> DOUBLE = new NumberType<Double>(StandardNumberType.TYPE_DOUBLE);
    public static final NumberType<BigInteger> BIG_INTEGER = new NumberType<BigInteger>(StandardNumberType.TYPE_BIG_INTEGER);
    public static final NumberType<BigDecimal> BIG_DECIMAL = new NumberType<BigDecimal>(StandardNumberType.TYPE_BIG_DECIMAL);
    private static final BigDecimal BIG_DECIMAL_SCIENTIFIC_THRESHOLD = new BigDecimal("1E100");
    private final ch.jalu.typeresolver.numbers.NumberType<N> numberType;

    protected NumberType(@NotNull ch.jalu.typeresolver.numbers.NumberType<N> type) {
        super(type.getType());
        this.numberType = type;
    }

    @Override
    @Nullable
    public N convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (object instanceof String) {
            Number value = this.convertToNumberIfPossible((String)object);
            return value == null ? null : (N)this.convertToType(value, errorRecorder);
        }
        if (object instanceof Number) {
            return this.convertToType((Number)object, errorRecorder);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toExportValue(@NotNull N value) {
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal.abs().compareTo(BIG_DECIMAL_SCIENTIFIC_THRESHOLD) >= 0 ? bigDecimal.toString() : bigDecimal.toPlainString();
        }
        if (value instanceof BigInteger) {
            return value.toString();
        }
        return value;
    }

    @Override
    public boolean canConvertToType(@NotNull TypeInfo typeInformation) {
        Class<N> requestedClass = PrimitiveType.toReferenceType(typeInformation.toClass());
        return requestedClass != null && requestedClass.isAssignableFrom(this.numberType.getType());
    }

    @NotNull
    protected final ch.jalu.typeresolver.numbers.NumberType<N> getTypeResolverNumberType() {
        return this.numberType;
    }

    @Nullable
    protected N convertToType(@NotNull Number number, @NotNull ConvertErrorRecorder errorRecorder) {
        ValueRangeComparison comparison = this.numberType.compareToValueRange(number);
        if (comparison == ValueRangeComparison.WITHIN_RANGE) {
            return (N)((Number)this.numberType.convertUnsafe(number));
        }
        errorRecorder.setHasError("Value cannot be represented in type (" + String.valueOf((Object)comparison) + ")");
        return (N)((Number)this.numberType.convertToBounds(number));
    }

    @Nullable
    protected Number convertToNumberIfPossible(@NotNull String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @NotNull
    public String toString() {
        return "NumberType[" + this.getType().getSimpleName() + "]";
    }

    @NotNull
    public ArrayPropertyType<N> arrayType() {
        return new ArrayPropertyType(this, size -> (Number[])ConversionUtils.createArrayForReferenceType(this.getType(), size));
    }

    @NotNull
    public InlineArrayPropertyType<N> inlineArrayType(@NotNull String separator) {
        return new InlineArrayPropertyType(this, separator, true, size -> (Number[])ConversionUtils.createArrayForReferenceType(this.getType(), size));
    }
}

