/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners.crates;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.events.CrateInteractEvent;
import com.badbones69.crazycrates.paper.api.events.KeyCheckEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.tasks.menus.CrateMainMenu;
import com.badbones69.crazycrates.paper.utils.ItemUtils;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateInteractListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final Server server = this.plugin.getServer();
    private final PluginManager pluginManager = this.server.getPluginManager();
    private final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    private final SettingsManager config = ConfigManager.getConfig();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final BukkitUserManager userManager = this.plugin.getUserManager();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCrateInteract(CrateInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        event.cancel();
        Player player = event.getPlayer();
        CrateLocation crateLocation = event.getCrateLocation();
        Crate crate = crateLocation.getCrate();
        Action action = event.getAction();
        switch (action) {
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (crate.getCrateType() == CrateType.menu) {
                    this.preview(player, crate, true);
                    return;
                }
                boolean isLeftClickToPreview = this.config.getProperty(ConfigKeys.crate_physical_interaction);
                if (isLeftClickToPreview) {
                    this.preview(player, crate, false);
                    return;
                }
                this.openCrate(player, crateLocation, crate);
                break;
            }
            case RIGHT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: {
                if (crate.getCrateType() == CrateType.menu) {
                    this.preview(player, crate, true);
                    return;
                }
                boolean isRightClickToOpen = this.config.getProperty(ConfigKeys.crate_physical_interaction);
                if (isRightClickToOpen) {
                    this.openCrate(player, crateLocation, crate);
                    return;
                }
                this.preview(player, crate, false);
            }
        }
    }

    private void openCrate(@NotNull Player player, @NotNull CrateLocation crateLocation, @NotNull Crate crate) {
        KeyCheckEvent key = new KeyCheckEvent(player, crateLocation);
        this.pluginManager.callEvent((Event)key);
        if (key.isCancelled()) {
            return;
        }
        Location location = crateLocation.getLocation();
        boolean hasKey = false;
        boolean isPhysical = false;
        boolean useQuickCrateAgain = false;
        int requiredKeys = crate.getRequiredKeys();
        String fileName = crate.getFileName();
        int totalKeys = this.userManager.getTotalKeys(player.getUniqueId(), fileName);
        String fancyName = crate.getCrateName();
        if (requiredKeys > 0 && totalKeys < requiredKeys) {
            Messages.not_enough_keys.sendMessage((CommandSender)player, Map.of("{required_amount}", String.valueOf(requiredKeys), "{key_amount}", String.valueOf(requiredKeys), "{amount}", String.valueOf(totalKeys), "{key}", crate.getKeyName(), "{crate}", fancyName));
            this.lackingKey(player, crate, location, false);
            key.setCancelled(true);
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (this.config.getProperty(ConfigKeys.physical_accepts_physical_keys).booleanValue() && crate.getCrateType() != CrateType.crate_on_the_go && ItemUtils.isSimilar(itemStack, crate)) {
            hasKey = true;
            isPhysical = true;
        } else if (this.config.getProperty(ConfigKeys.physical_accepts_virtual_keys).booleanValue() && this.userManager.getVirtualKeys(player.getUniqueId(), fileName) >= 1) {
            hasKey = true;
        }
        if (hasKey) {
            KeyType keyType;
            if (this.crateManager.isInOpeningList(player) && this.crateManager.getOpeningCrate(player).getCrateType() == CrateType.quick_crate && this.crateManager.isCrateInUse(player) && this.crateManager.getCrateInUseLocation(player).equals((Object)crateLocation.getLocation())) {
                useQuickCrateAgain = true;
            }
            if (!useQuickCrateAgain) {
                if (this.crateManager.isInOpeningList(player)) {
                    Messages.already_opening_crate.sendMessage((CommandSender)player, "{crate}", fancyName);
                    return;
                }
                if (this.crateManager.getCratesInUse().containsValue(crateLocation.getLocation())) {
                    Messages.crate_in_use.sendMessage((CommandSender)player, "{crate}", fancyName);
                    return;
                }
            }
            if (MiscUtils.isInventoryFull(player)) {
                Messages.inventory_not_empty.sendMessage((CommandSender)player, "{crate}", fancyName);
                return;
            }
            if (useQuickCrateAgain) {
                this.crateManager.endQuickCrate(player, crateLocation.getLocation(), crate, true);
            }
            KeyType keyType2 = keyType = isPhysical ? KeyType.physical_key : KeyType.virtual_key;
            if (crate.getCrateType() == CrateType.cosmic) {
                this.crateManager.addPlayerKeyType(player, keyType);
            }
            this.crateManager.addPlayerToOpeningList(player, crate);
            this.crateManager.openCrate(player, crate, keyType, location, false, true, EventType.event_crate_opened);
            return;
        }
        this.lackingKey(player, crate, location, true);
        key.setCancelled(true);
    }

    private void lackingKey(@NotNull Player player, @NotNull Crate crate, @NotNull Location location, boolean sendMessage) {
        String keyName = crate.getKeyName();
        if (crate.getCrateType() != CrateType.crate_on_the_go) {
            if (this.config.getProperty(ConfigKeys.knock_back).booleanValue()) {
                this.knockback(player, location);
            }
            if (this.config.getProperty(ConfigKeys.need_key_sound_toggle).booleanValue()) {
                player.playSound(Sound.sound((Key)Key.key((String)this.config.getProperty(ConfigKeys.need_key_sound)), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f));
            }
            if (sendMessage) {
                Messages.no_keys.sendMessage((CommandSender)player, Map.of("{crate}", crate.getCrateName(), "{key}", keyName));
            }
        }
    }

    private void knockback(@NotNull Player player, @NotNull Location location) {
        Vector vector = player.getLocation().toVector().subtract(location.toVector()).normalize().multiply(1).setY(0.1);
        if (player.isInsideVehicle() && player.getVehicle() != null) {
            player.getVehicle().setVelocity(vector);
            return;
        }
        player.setVelocity(vector);
    }

    private void preview(@NotNull Player player, @NotNull Crate crate, boolean skipTypeCheck) {
        if (skipTypeCheck || crate.getCrateType() == CrateType.menu) {
            if (!this.crateManager.isInOpeningList(player) && this.config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
                new CrateMainMenu(player, this.config.getProperty(ConfigKeys.inventory_name), this.config.getProperty(ConfigKeys.inventory_rows)).open();
            } else {
                Messages.feature_disabled.sendMessage((CommandSender)player);
            }
        } else if (crate.isPreviewEnabled()) {
            this.inventoryManager.openNewCratePreview(player, crate);
        } else {
            Messages.preview_disabled.sendMessage((CommandSender)player, "{crate}", crate.getCrateName());
        }
    }
}

