/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners.crates.types;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.ChestManager;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.tasks.crates.other.quadcrates.QuadCrateManager;
import com.badbones69.crazycrates.paper.tasks.crates.other.quadcrates.SessionManager;
import com.badbones69.crazycrates.paper.utils.ItemUtils;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class QuadCrateListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    private final SessionManager sessionManager = new SessionManager();

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.sessionManager.inSession(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChestClick(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            final Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (!this.sessionManager.inSession(player)) {
                return;
            }
            final QuadCrateManager session = this.sessionManager.getSession(player);
            if (session == null) {
                return;
            }
            List<Location> crateLocation = session.getCrateLocations();
            if (!crateLocation.contains(block.getLocation())) {
                return;
            }
            event.setCancelled(true);
            if (session.getCratesOpened().get(block.getLocation()).booleanValue()) {
                return;
            }
            ChestManager.openChest(block, true);
            final Crate crate = session.getCrate();
            final Prize prize = crate.pickPrize(player);
            PrizeManager.givePrize(player, block.getLocation().clone().add(0.5, 1.3, 0.5), crate, prize);
            ItemStack display = prize.getDisplayItem(player, crate);
            display.editPersistentDataContainer(container -> container.set(ItemKeys.crate_prize.getNamespacedKey(), PersistentDataType.STRING, (Object)"1"));
            final ItemStack itemStack = ItemUtils.convertItemStack(display).asItemStack();
            final Location location = block.getLocation();
            new FoliaScheduler(this.plugin, location){

                @Override
                public void run() {
                    Item reward;
                    try {
                        reward = player.getWorld().dropItem(location.clone().add(0.5, 1.0, 0.5), itemStack);
                    }
                    catch (IllegalArgumentException exception) {
                        String crateName = prize.getCrateName();
                        String prizeName = prize.getPrizeName();
                        List.of("A prize could not be given due to an invalid display item for this prize.", "Crate: %s Prize: %s").forEach(line -> QuadCrateListener.this.logger.warn(String.format(line, crateName, prizeName), (Throwable)exception));
                        this.cancel();
                        return;
                    }
                    reward.setVelocity(new Vector(0.0, 0.2, 0.0));
                    reward.customName(itemStack.displayName());
                    reward.setCustomNameVisible(true);
                    reward.setCanMobPickup(false);
                    reward.setCanPlayerPickup(false);
                    session.getDisplayedRewards().add((Entity)reward);
                }
            }.runNow();
            session.getCratesOpened().put(block.getLocation(), true);
            if (session.allCratesOpened()) {
                new FoliaScheduler(this, this.plugin, null, (Entity)player){

                    @Override
                    public void run() {
                        session.endCrate(false);
                        crate.playSound(player, block.getLocation(), "stop-sound", "block.anvil.land", Sound.Source.BLOCK);
                    }
                }.runDelayed(60L);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.sessionManager.inSession(player)) {
            return;
        }
        Location oldLocation = event.getFrom();
        Location newLocation = event.getTo();
        if (oldLocation.getBlockX() != newLocation.getBlockX() || oldLocation.getBlockZ() != newLocation.getBlockZ()) {
            player.teleportAsync(oldLocation);
            event.setCancelled(true);
        }
        for (Entity entity : player.getNearbyEntities(2.0, 2.0, 2.0)) {
            Player target;
            if (!(entity instanceof Player) || !this.sessionManager.inSession(target = (Player)entity)) continue;
            Vector velocity = player.getLocation().toVector().subtract(target.getLocation().toVector()).normalize().setY(1);
            if (player.isInsideVehicle() && player.getVehicle() != null) {
                player.getVehicle().setVelocity(velocity);
                break;
            }
            player.setVelocity(velocity);
            break;
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.sessionManager.inSession(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCommandProcess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        QuadCrateManager session = this.sessionManager.getSession(player);
        if (session != null && !player.hasPermission("crazycrates.admin")) {
            event.setCancelled(true);
            Crate crate = session.getCrate();
            Messages.no_commands_while_in_crate.sendMessage((CommandSender)player, Map.of("{crate}", crate.getCrateName(), "{player}", player.getName()));
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        QuadCrateManager session = this.sessionManager.getSession(player);
        if (session != null && event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            event.setCancelled(true);
            Crate crate = session.getCrate();
            Messages.no_teleporting.sendMessage((CommandSender)player, Map.of("{crate}", crate.getCrateName(), "{player}", player.getName()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        QuadCrateManager session = this.sessionManager.getSession(player);
        if (session != null) {
            session.endCrate(true);
        }
    }
}

