/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.support.holograms.types;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Display.CMIBillboard;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import java.util.ArrayList;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CMIHologramsSupport
extends HologramManager {
    private final com.Zrips.CMI.Modules.Holograms.HologramManager hologramManager = CMI.getInstance().getHologramManager();

    @Override
    public void createHologram(final @NotNull Location location, @NotNull Crate crate, @NotNull String id) {
        if (crate.getCrateType() == CrateType.menu) {
            return;
        }
        final CrateHologram crateHologram = crate.getHologram();
        if (!crateHologram.isEnabled()) {
            this.removeHologram(id);
            return;
        }
        if (this.exists(id)) {
            return;
        }
        final CMIHologram hologram = new CMIHologram(this.name(id), new CMILocation(location.clone().add(this.getVector(crate))));
        hologram.setNewDisplayMethod(true);
        hologram.setBillboard(CMIBillboard.CENTER);
        String color = crateHologram.getBackgroundColor();
        if (color.equalsIgnoreCase("transparent")) {
            hologram.setBackgroundAlpha(0);
        } else {
            hologram.setBackgroundColor(CMIChatColor.getClosest((String)color));
        }
        hologram.setShowRange(crateHologram.getRange());
        ArrayList lines = new ArrayList();
        crateHologram.getMessages().forEach(line -> lines.add(CMIChatColor.colorize((String)line)));
        hologram.setLines(lines);
        if (crateHologram.getUpdateInterval() != -1) {
            hologram.setUpdateIntervalSec((double)crateHologram.getUpdateInterval());
        }
        this.hologramManager.addHologram(hologram);
        new FoliaScheduler(this.plugin, location){

            @Override
            public void run() {
                location.getNearbyEntitiesByType(Player.class, (double)crateHologram.getRange()).forEach(player -> CMIHologramsSupport.this.hologramManager.handleHoloUpdates(player, (Location)hologram.getLocation()));
            }
        }.runNow();
    }

    @Override
    public void removeHologram(@NotNull String id) {
        CMIHologram hologram = this.hologramManager.getByName(this.name(id));
        if (hologram != null) {
            hologram.remove();
        }
    }

    @Override
    public boolean exists(@NotNull String id) {
        return this.hologramManager.getByName(this.name(id)) != null;
    }

    @Override
    public void purge(boolean isShutdown) {
        String name = this.plugin.getName().toLowerCase();
        ArrayList holograms = new ArrayList();
        this.hologramManager.getHolograms().forEach((id, hologram) -> {
            if (id.startsWith(name + "-")) {
                holograms.add(id.replace(name + "-", ""));
            }
        });
        holograms.forEach(this::removeHologram);
    }

    @Override
    @NotNull
    public final String getName() {
        return "CMI";
    }
}

