/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import dev.triumphteam.cmd.core.command.ArgumentInput;
import dev.triumphteam.cmd.core.extension.InternalArgumentResult;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionInternalArgument<S, ST>
extends LimitlessInternalArgument<S, ST> {
    private final InternalArgument<S, ST> internalArgument;
    private final Class<?> collectionType;

    public CollectionInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull InternalArgument<S, ST> internalArgument, @NotNull Class<?> collectionType, @NotNull InternalSuggestion<S, ST> suggestion, @Nullable String defaultValue, boolean optional) {
        super(meta, name, description, String.class, suggestion, defaultValue, optional);
        this.internalArgument = internalArgument;
        this.collectionType = collectionType;
    }

    @Override
    @NotNull
    public InternalArgumentResult resolve(@NotNull S sender, @NotNull ArgumentInput input) {
        return CollectionInternalArgument.resolveCollection(sender, this.internalArgument, Arrays.asList(input.getInput().split(" ")), this.collectionType);
    }

    @NotNull
    public static <S, ST> InternalArgumentResult resolveCollection(@NotNull S sender, @NotNull InternalArgument<S, ST> internalArgument, @NotNull Collection<String> value, @NotNull Class<?> collectionType) {
        Collection<Object> collection = CollectionInternalArgument.createCollection(collectionType);
        for (String arg : value) {
            InternalArgumentResult resolved = internalArgument.resolve(sender, new ArgumentInput(arg));
            if (!(resolved instanceof InternalArgumentResult.Valid)) {
                return resolved;
            }
            collection.add(((InternalArgumentResult.Valid)resolved).getValue());
        }
        return InternalArgument.valid(collection);
    }

    private static Collection<Object> createCollection(Class<?> collectionType) {
        if (collectionType == Set.class) {
            return new HashSet<Object>();
        }
        return new ArrayList<Object>();
    }

    @Override
    @NotNull
    public String toString() {
        return "CollectionArgument{collectionType=" + this.collectionType + ", super=" + super.toString() + "}";
    }
}

