/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.array;

import ch.jalu.typeresolver.array.ArrayClassProperties;
import ch.jalu.typeresolver.array.ArrayTypeProperties;
import ch.jalu.typeresolver.array.GenericArrayTypeProperties;
import ch.jalu.typeresolver.typeimpl.GenericArrayTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;

public final class ArrayTypeUtils {
    private ArrayTypeUtils() {
    }

    public static Class<?> createArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Class<?> createArrayClass(Class<?> componentType, int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("Dimension may not be negative");
        }
        if (dimension == 0) {
            return componentType;
        }
        int[] dimensions = new int[dimension];
        return Array.newInstance(componentType, dimensions).getClass();
    }

    public static Type createArrayType(Type componentType) {
        return ArrayTypeUtils.createArrayType(componentType, 1);
    }

    public static Type createArrayType(Type componentType, int dimension) {
        if (componentType instanceof Class) {
            return ArrayTypeUtils.createArrayClass((Class)componentType, dimension);
        }
        return GenericArrayTypeImpl.create(componentType, dimension);
    }

    public static ArrayTypeProperties getArrayProperty(Type type) {
        if (type instanceof Class) {
            return new ArrayClassProperties((Class)type);
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeProperties((GenericArrayType)type);
        }
        return new GenericArrayTypeProperties(type, 0);
    }
}

