/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.array;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static int binarySearch(Object array, Object key) {
        int length = Array.getLength(array);
        return ArrayUtils.binarySearch(array, 0, length, key);
    }

    public static int binarySearch(Object array, int fromIndex, int toIndex, Object key) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(array);
        ArrayUtils.verifyArgumentMatchesComponentType(key, comp, "key");
        switch (comp) {
            case BOOLEAN: {
                return ArrayUtils.simpleBooleanArrayBinarySearch((boolean[])array, fromIndex, toIndex, (Boolean)key);
            }
            case BYTE: {
                return Arrays.binarySearch((byte[])array, fromIndex, toIndex, (Byte)key);
            }
            case CHARACTER: {
                return Arrays.binarySearch((char[])array, fromIndex, toIndex, ((Character)key).charValue());
            }
            case SHORT: {
                return Arrays.binarySearch((short[])array, fromIndex, toIndex, (Short)key);
            }
            case INTEGER: {
                return Arrays.binarySearch((int[])array, fromIndex, toIndex, (Integer)key);
            }
            case LONG: {
                return Arrays.binarySearch((long[])array, fromIndex, toIndex, (Long)key);
            }
            case FLOAT: {
                return Arrays.binarySearch((float[])array, fromIndex, toIndex, ((Float)key).floatValue());
            }
            case DOUBLE: {
                return Arrays.binarySearch((double[])array, fromIndex, toIndex, (Double)key);
            }
        }
        return Arrays.binarySearch((Object[])array, fromIndex, toIndex, key);
    }

    public static Object copyOf(Object original, int newLength) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(original);
        switch (comp) {
            case BOOLEAN: {
                return Arrays.copyOf((boolean[])original, newLength);
            }
            case BYTE: {
                return Arrays.copyOf((byte[])original, newLength);
            }
            case CHARACTER: {
                return Arrays.copyOf((char[])original, newLength);
            }
            case SHORT: {
                return Arrays.copyOf((short[])original, newLength);
            }
            case INTEGER: {
                return Arrays.copyOf((int[])original, newLength);
            }
            case LONG: {
                return Arrays.copyOf((long[])original, newLength);
            }
            case FLOAT: {
                return Arrays.copyOf((float[])original, newLength);
            }
            case DOUBLE: {
                return Arrays.copyOf((double[])original, newLength);
            }
        }
        return Arrays.copyOf((Object[])original, newLength);
    }

    public static Object copyOfRange(Object original, int from, int to) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(original);
        switch (comp) {
            case BOOLEAN: {
                return Arrays.copyOfRange((boolean[])original, from, to);
            }
            case BYTE: {
                return Arrays.copyOfRange((byte[])original, from, to);
            }
            case CHARACTER: {
                return Arrays.copyOfRange((char[])original, from, to);
            }
            case SHORT: {
                return Arrays.copyOfRange((short[])original, from, to);
            }
            case INTEGER: {
                return Arrays.copyOfRange((int[])original, from, to);
            }
            case LONG: {
                return Arrays.copyOfRange((long[])original, from, to);
            }
            case FLOAT: {
                return Arrays.copyOfRange((float[])original, from, to);
            }
            case DOUBLE: {
                return Arrays.copyOfRange((double[])original, from, to);
            }
        }
        return Arrays.copyOfRange((Object[])original, from, to);
    }

    public static boolean equals(Object a, Object a2) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(a);
        switch (comp) {
            case BOOLEAN: {
                return Arrays.equals((boolean[])a, (boolean[])a2);
            }
            case BYTE: {
                return Arrays.equals((byte[])a, (byte[])a2);
            }
            case CHARACTER: {
                return Arrays.equals((char[])a, (char[])a2);
            }
            case SHORT: {
                return Arrays.equals((short[])a, (short[])a2);
            }
            case INTEGER: {
                return Arrays.equals((int[])a, (int[])a2);
            }
            case LONG: {
                return Arrays.equals((long[])a, (long[])a2);
            }
            case FLOAT: {
                return Arrays.equals((float[])a, (float[])a2);
            }
            case DOUBLE: {
                return Arrays.equals((double[])a, (double[])a2);
            }
        }
        return Arrays.equals((Object[])a, (Object[])a2);
    }

    public static void fill(Object a, Object val) {
        ArrayUtils.fill(a, 0, Array.getLength(a), val);
    }

    public static void fill(Object a, int fromIndex, int toIndex, Object val) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(a);
        ArrayUtils.verifyArgumentMatchesComponentType(val, comp, "val");
        switch (comp) {
            case BOOLEAN: {
                Arrays.fill((boolean[])a, fromIndex, toIndex, (Boolean)val);
                break;
            }
            case BYTE: {
                Arrays.fill((byte[])a, fromIndex, toIndex, (Byte)val);
                break;
            }
            case CHARACTER: {
                Arrays.fill((char[])a, fromIndex, toIndex, ((Character)val).charValue());
                break;
            }
            case SHORT: {
                Arrays.fill((short[])a, fromIndex, toIndex, (Short)val);
                break;
            }
            case INTEGER: {
                Arrays.fill((int[])a, fromIndex, toIndex, (Integer)val);
                break;
            }
            case LONG: {
                Arrays.fill((long[])a, fromIndex, toIndex, (Long)val);
                break;
            }
            case FLOAT: {
                Arrays.fill((float[])a, fromIndex, toIndex, ((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                Arrays.fill((double[])a, fromIndex, toIndex, (Double)val);
                break;
            }
            default: {
                Arrays.fill((Object[])a, fromIndex, toIndex, val);
            }
        }
    }

    public static int hashCode(Object a) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(a);
        switch (comp) {
            case BOOLEAN: {
                return Arrays.hashCode((boolean[])a);
            }
            case BYTE: {
                return Arrays.hashCode((byte[])a);
            }
            case CHARACTER: {
                return Arrays.hashCode((char[])a);
            }
            case SHORT: {
                return Arrays.hashCode((short[])a);
            }
            case INTEGER: {
                return Arrays.hashCode((int[])a);
            }
            case LONG: {
                return Arrays.hashCode((long[])a);
            }
            case FLOAT: {
                return Arrays.hashCode((float[])a);
            }
            case DOUBLE: {
                return Arrays.hashCode((double[])a);
            }
        }
        return Arrays.hashCode((Object[])a);
    }

    public static void parallelSort(Object a) {
        ArrayUtils.parallelSort(a, 0, Array.getLength(a));
    }

    public static void parallelSort(Object a, int fromIndex, int toIndex) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(a);
        switch (comp) {
            case BOOLEAN: {
                ArrayUtils.simpleBooleanArraySort((boolean[])a, fromIndex, toIndex);
                break;
            }
            case BYTE: {
                Arrays.parallelSort((byte[])a, fromIndex, toIndex);
                break;
            }
            case CHARACTER: {
                Arrays.parallelSort((char[])a, fromIndex, toIndex);
                break;
            }
            case SHORT: {
                Arrays.parallelSort((short[])a, fromIndex, toIndex);
                break;
            }
            case INTEGER: {
                Arrays.parallelSort((int[])a, fromIndex, toIndex);
                break;
            }
            case LONG: {
                Arrays.parallelSort((long[])a, fromIndex, toIndex);
                break;
            }
            case FLOAT: {
                Arrays.parallelSort((float[])a, fromIndex, toIndex);
                break;
            }
            case DOUBLE: {
                Arrays.parallelSort((double[])a, fromIndex, toIndex);
                break;
            }
            default: {
                Arrays.parallelSort((Comparable[])((Comparable[])a), (int)fromIndex, (int)toIndex);
            }
        }
    }

    public static Stream<Object> stream(Object array) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(array);
        if (comp == ArrayComponentType.OBJECT) {
            return Arrays.stream((Object[])array);
        }
        int length = Array.getLength(array);
        return IntStream.range(0, length).mapToObj(idx -> Array.get(array, idx));
    }

    public static void sort(Object a) {
        ArrayUtils.sort(a, 0, Array.getLength(a));
    }

    public static void sort(Object a, int fromIndex, int toIndex) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(a);
        switch (comp) {
            case BOOLEAN: {
                ArrayUtils.simpleBooleanArraySort((boolean[])a, fromIndex, toIndex);
                break;
            }
            case BYTE: {
                Arrays.sort((byte[])a, fromIndex, toIndex);
                break;
            }
            case CHARACTER: {
                Arrays.sort((char[])a, fromIndex, toIndex);
                break;
            }
            case SHORT: {
                Arrays.sort((short[])a, fromIndex, toIndex);
                break;
            }
            case INTEGER: {
                Arrays.sort((int[])a, fromIndex, toIndex);
                break;
            }
            case LONG: {
                Arrays.sort((long[])a, fromIndex, toIndex);
                break;
            }
            case FLOAT: {
                Arrays.sort((float[])a, fromIndex, toIndex);
                break;
            }
            case DOUBLE: {
                Arrays.sort((double[])a, fromIndex, toIndex);
                break;
            }
            default: {
                Arrays.sort((Object[])a, fromIndex, toIndex);
            }
        }
    }

    public static String toString(Object a) {
        ArrayComponentType comp = ArrayUtils.getArrayComponentType(a);
        switch (comp) {
            case BOOLEAN: {
                return Arrays.toString((boolean[])a);
            }
            case BYTE: {
                return Arrays.toString((byte[])a);
            }
            case CHARACTER: {
                return Arrays.toString((char[])a);
            }
            case SHORT: {
                return Arrays.toString((short[])a);
            }
            case INTEGER: {
                return Arrays.toString((int[])a);
            }
            case LONG: {
                return Arrays.toString((long[])a);
            }
            case FLOAT: {
                return Arrays.toString((float[])a);
            }
            case DOUBLE: {
                return Arrays.toString((double[])a);
            }
        }
        return Arrays.toString((Object[])a);
    }

    public static int simpleBooleanArrayBinarySearch(boolean[] array, int fromIndex, int toIndex, boolean value) {
        int lastIndex;
        if (fromIndex < toIndex && array[fromIndex] == value) {
            return fromIndex;
        }
        if (value && (lastIndex = toIndex - 1) > fromIndex && array[lastIndex]) {
            return lastIndex;
        }
        return value ? -toIndex - 1 : -fromIndex - 1;
    }

    public static void simpleBooleanArraySort(boolean[] array, int fromIndex, int toIndex) {
        int numberOfFalse = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (array[i]) continue;
            ++numberOfFalse;
        }
        Arrays.fill(array, fromIndex, fromIndex + numberOfFalse, false);
        Arrays.fill(array, fromIndex + numberOfFalse, toIndex, true);
    }

    private static ArrayComponentType getArrayComponentType(Object array) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        ArrayComponentType componentType = ArrayComponentType.resolveComponentForPrimitiveArrays(array.getClass());
        if (componentType != null) {
            return componentType;
        }
        if (Object[].class.isAssignableFrom(array.getClass())) {
            return ArrayComponentType.OBJECT;
        }
        throw new IllegalArgumentException("Expected an array as argument, but got: " + array.getClass());
    }

    private static void verifyArgumentMatchesComponentType(Object argument, ArrayComponentType componentType, String argumentName) {
        if (argument == null) {
            throw new NullPointerException(argumentName);
        }
        if (!componentType.matches(argument)) {
            throw new ClassCastException("Expected " + argumentName + " to be a " + componentType.name().toLowerCase(Locale.ROOT) + ", instead found: " + argument.getClass());
        }
    }

    static enum ArrayComponentType {
        BOOLEAN(Boolean.class),
        BYTE(Byte.class),
        CHARACTER(Character.class),
        SHORT(Short.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        OBJECT(Object.class);

        private static final Map<Class<?>, ArrayComponentType> PRIMITIVE_ARRAY_TO_COMPONENT;
        private final Class<?> referenceType;

        private ArrayComponentType(Class<?> referenceType) {
            this.referenceType = referenceType;
        }

        boolean matches(Object obj) {
            return this.referenceType.isInstance(obj);
        }

        @Nullable
        static ArrayComponentType resolveComponentForPrimitiveArrays(Class<?> clazz) {
            return PRIMITIVE_ARRAY_TO_COMPONENT.get(clazz);
        }

        private static Map<Class<?>, ArrayComponentType> createPrimitiveArrayTypesToComponentMap() {
            HashMap<Class, ArrayComponentType> map = new HashMap<Class, ArrayComponentType>();
            map.put(boolean[].class, BOOLEAN);
            map.put(byte[].class, BYTE);
            map.put(char[].class, CHARACTER);
            map.put(short[].class, SHORT);
            map.put(int[].class, INTEGER);
            map.put(long[].class, LONG);
            map.put(float[].class, FLOAT);
            map.put(double[].class, DOUBLE);
            return Collections.unmodifiableMap(map);
        }

        static {
            PRIMITIVE_ARRAY_TO_COMPONENT = ArrayComponentType.createPrimitiveArrayTypesToComponentMap();
        }
    }
}

