/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.support.placeholders;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.api.builders.PlayerBuilder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPISupport
extends PlaceholderExpansion {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final FusionPaper fusion = this.plugin.getFusion();
    private final Server server = this.plugin.getServer();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final NumberFormat instance = NumberFormat.getNumberInstance();

    @NotNull
    public final String onPlaceholderRequest(Player player, @NotNull String identifier) {
        OfflinePlayer offlineTarget;
        PlayerBuilder builder;
        Player target;
        if (player == null || identifier.isEmpty()) {
            return "N/A";
        }
        AtomicReference<UUID> uuid = new AtomicReference<UUID>(player.getUniqueId());
        if (identifier.equalsIgnoreCase("crates_opened_raw")) {
            return String.valueOf(this.userManager.getTotalCratesOpened(uuid.get()));
        }
        if (identifier.equalsIgnoreCase("crates_opened")) {
            return this.instance.format(this.userManager.getTotalCratesOpened(uuid.get()));
        }
        ArrayList values = new ArrayList(1);
        String[] keys = identifier.split("_");
        String value = keys[0];
        this.crateManager.getCrateByName(value).ifPresentOrElse(crate -> {
            String name = crate.getFileName();
            if (identifier.equalsIgnoreCase(name)) {
                values.add(this.instance.format(this.userManager.getVirtualKeys((UUID)uuid.get(), name)));
            }
            if (identifier.equalsIgnoreCase("%s_physical_raw".formatted(name))) {
                values.add(String.valueOf(this.userManager.getPhysicalKeys((UUID)uuid.get(), name)));
            }
            if (identifier.equalsIgnoreCase("%s_physical".formatted(name))) {
                values.add(this.instance.format(this.userManager.getPhysicalKeys((UUID)uuid.get(), name)));
            }
            if (identifier.equalsIgnoreCase("%s_total_raw".formatted(name))) {
                values.add(String.valueOf(this.userManager.getTotalKeys((UUID)uuid.get(), name)));
            }
            if (identifier.equalsIgnoreCase("%s_total".formatted(name))) {
                values.add(this.instance.format(this.userManager.getTotalKeys((UUID)uuid.get(), name)));
            }
            if (identifier.equalsIgnoreCase("%s_opened_raw".formatted(name))) {
                values.add(String.valueOf(this.userManager.getCrateOpened((UUID)uuid.get(), name)));
            }
            if (identifier.equalsIgnoreCase("%s_opened".formatted(name))) {
                values.add(this.instance.format(this.userManager.getCrateOpened((UUID)uuid.get(), name)));
            }
            if (identifier.equalsIgnoreCase("%s_raw".formatted(name))) {
                values.add(String.valueOf(this.userManager.getVirtualKeys((UUID)uuid.get(), name)));
            }
        }, () -> this.fusion.log("warn", "{} is not a valid crate name! Placeholder: {}", value, identifier));
        if (!values.isEmpty()) {
            return (String)values.getFirst();
        }
        String playerName = "%" + StringUtils.substringBetween((String)keys[0], (String)"{", (String)"}") + "%";
        String parsedPlayer = player.getName();
        if (playerName.equalsIgnoreCase("%player%")) {
            parsedPlayer = PlaceholderAPI.setPlaceholders((Player)player, (String)playerName);
        }
        UUID id = !parsedPlayer.equalsIgnoreCase(player.getName()) ? ((target = (builder = new PlayerBuilder(this.server, parsedPlayer)).getPlayer()) == null ? ((offlineTarget = builder.getOfflinePlayer()) != null ? offlineTarget.getUniqueId() : null) : target.getUniqueId()) : player.getUniqueId();
        if (id == null) {
            return "N/A";
        }
        String crateName = keys[1];
        this.crateManager.getCrateByName(crateName).ifPresent(crate -> {
            if (identifier.equalsIgnoreCase("%s_%s_opened_raw".formatted(playerName, crateName))) {
                values.add(String.valueOf(this.userManager.getCrateOpened(id, crateName)));
            }
            if (identifier.equalsIgnoreCase("%s_%s_opened".formatted(playerName, crateName))) {
                values.add(this.instance.format(this.userManager.getCrateOpened(id, crateName)));
            }
            if (identifier.equalsIgnoreCase("%s_%s_physical_raw".formatted(playerName, crateName))) {
                values.add(String.valueOf(this.userManager.getPhysicalKeys(id, crateName)));
            }
            if (identifier.equalsIgnoreCase("%s_%s_physical".formatted(playerName, crateName))) {
                values.add(this.instance.format(this.userManager.getPhysicalKeys(id, crateName)));
            }
            if (identifier.equalsIgnoreCase("%s_%s_virtual_raw".formatted(playerName, crateName))) {
                values.add(String.valueOf(this.userManager.getVirtualKeys(id, crateName)));
            }
            if (identifier.equalsIgnoreCase("%s_%s_virtual".formatted(playerName, crateName))) {
                values.add(this.instance.format(this.userManager.getVirtualKeys(id, crateName)));
            }
            if (identifier.equalsIgnoreCase("%s_%s_total_raw".formatted(playerName, crateName))) {
                values.add(String.valueOf(this.userManager.getTotalKeys(id, crateName)));
            }
            if (identifier.equalsIgnoreCase("%s_%s_total".formatted(playerName, crateName))) {
                values.add(this.instance.format(this.userManager.getTotalKeys(id, crateName)));
            }
        });
        if (!values.isEmpty()) {
            return (String)values.getFirst();
        }
        if (identifier.endsWith("opened")) {
            return this.instance.format(this.userManager.getTotalCratesOpened(id));
        }
        if (identifier.endsWith("opened_raw")) {
            return String.valueOf(this.userManager.getTotalCratesOpened(id));
        }
        return "N/A";
    }

    public final boolean persist() {
        return true;
    }

    public final boolean canRegister() {
        return true;
    }

    @NotNull
    public final String getIdentifier() {
        return this.plugin.getName().toLowerCase();
    }

    @NotNull
    public final String getAuthor() {
        return "ryderbelserion";
    }

    @NotNull
    public final String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }
}

