/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.Server;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.core.config.impl.EditorKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.ChestManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.api.objects.crates.BrokeLocation;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.api.objects.crates.quadcrates.CrateSchematic;
import com.badbones69.crazycrates.paper.listeners.items.NexoInteractListener;
import com.badbones69.crazycrates.paper.listeners.items.OraxenInteractListener;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import com.badbones69.crazycrates.paper.support.holograms.types.DecentHologramsSupport;
import com.badbones69.crazycrates.paper.support.holograms.types.FancyHologramsSupport;
import com.badbones69.crazycrates.paper.tasks.crates.other.quadcrates.QuadCrateManager;
import com.badbones69.crazycrates.paper.tasks.crates.types.CasinoCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.CosmicCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.CrateOnTheGo;
import com.badbones69.crazycrates.paper.tasks.crates.types.CsgoCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.FireCrackerCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.QuadCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.QuickCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.RouletteCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.WarCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.WheelCrate;
import com.badbones69.crazycrates.paper.tasks.crates.types.WonderCrate;
import com.badbones69.crazycrates.paper.tasks.menus.CrateMainMenu;
import com.badbones69.crazycrates.paper.utils.ItemUtils;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.utils.FileUtils;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import com.ryderbelserion.fusion.paper.files.FileManager;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import io.papermc.paper.persistence.PersistentDataContainerView;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimerTask;
import java.util.UUID;
import java.util.WeakHashMap;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateManager {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final Path dataPath = this.plugin.getDataPath();
    private final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    private final FileManager fileManager = this.plugin.getFileManager();
    private final Server instance = this.plugin.getInstance();
    private final FusionPaper fusion = this.plugin.getFusion();
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    private final org.bukkit.Server server = this.plugin.getServer();
    private final PluginManager pluginManager = this.server.getPluginManager();
    private final List<QuadCrateManager> quadSessions = new ArrayList<QuadCrateManager>();
    private final List<CrateLocation> crateLocations = new ArrayList<CrateLocation>();
    private final List<CrateSchematic> crateSchematics = new ArrayList<CrateSchematic>();
    private final List<BrokeLocation> brokeLocations = new ArrayList<BrokeLocation>();
    private final Map<UUID, Location> cratesInUse = new HashMap<UUID, Location>();
    private final List<String> brokeCrates = new ArrayList<String>();
    private final List<Crate> crates = new ArrayList<Crate>();
    private final Map<UUID, Crate> crateEditors = new HashMap<UUID, Crate>();
    private final Map<UUID, Map<Integer, Tier>> tiers = new WeakHashMap<UUID, Map<Integer, Tier>>();
    private HologramManager holograms;
    private boolean giveNewPlayersKeys;
    private final SettingsManager config = ConfigManager.getConfig();
    private final Map<UUID, Crate> playerOpeningCrates = new HashMap<UUID, Crate>();
    private final Map<UUID, KeyType> playerKeys = new HashMap<UUID, KeyType>();
    private final Map<UUID, ScheduledTask> currentTasks = new HashMap<UUID, ScheduledTask>();
    private final Map<UUID, TimerTask> timerTasks = new HashMap<UUID, TimerTask>();
    private final Map<UUID, List<ScheduledTask>> currentQuadTasks = new HashMap<UUID, List<ScheduledTask>>();
    private final SettingsManager editor = ConfigManager.getEditor();
    private final Map<UUID, Boolean> canPick = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> canClose = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> checkHands = new HashMap<UUID, Boolean>();
    private final List<Entity> allRewards = new ArrayList<Entity>();
    private final Map<UUID, Entity> rewards = new HashMap<UUID, Entity>();
    private final Map<UUID, ArrayList<Integer>> slots = new HashMap<UUID, ArrayList<Integer>>();

    public void addEditorCrate(@NotNull Player player, @NotNull Crate crate) {
        this.crateEditors.put(player.getUniqueId(), crate);
    }

    public void removeEditorCrate(@NotNull Player player) {
        this.crateEditors.remove(player.getUniqueId());
    }

    public boolean hasEditorCrate(@NotNull Player player) {
        return this.crateEditors.containsKey(player.getUniqueId());
    }

    @Nullable
    public Crate getEditorCrate(@NotNull Player player) {
        return this.crateEditors.getOrDefault(player.getUniqueId(), null);
    }

    public void addQuadSession(@NotNull QuadCrateManager session) {
        this.quadSessions.add(session);
    }

    public void removeQuadSession(@NotNull QuadCrateManager session) {
        this.quadSessions.remove(session);
    }

    public void purgeQuadSessions() {
        this.quadSessions.clear();
    }

    public List<QuadCrateManager> getQuadSessions() {
        return this.quadSessions;
    }

    public void addTier(@NotNull Player player, final int slot, final Tier tier) {
        UUID uuid = player.getUniqueId();
        if (this.tiers.containsKey(uuid)) {
            this.tiers.get(uuid).put(slot, tier);
            return;
        }
        this.tiers.put(uuid, (Map<Integer, Tier>)new WeakHashMap<Integer, Tier>(this){
            {
                this.put(slot, tier);
            }
        });
    }

    public void removeTier(@NotNull Player player) {
        this.tiers.remove(player.getUniqueId());
    }

    public final Tier getTier(@NotNull Player player, int slot) {
        return this.tiers.get(player.getUniqueId()).get(slot);
    }

    public Map<UUID, Map<Integer, Tier>> getTiers() {
        return Collections.unmodifiableMap(this.tiers);
    }

    public void reloadCrate(@Nullable Crate crate) {
        block10: {
            try {
                if (crate == null) {
                    return;
                }
                YamlConfiguration file = crate.getFile();
                this.inventoryManager.closePreview();
                crate.purge();
                ArrayList<Prize> prizes = new ArrayList<Prize>();
                ConfigurationSection prizesSection = file.getConfigurationSection("Crate.Prizes");
                if (prizesSection != null) {
                    for (String prize : prizesSection.getKeys(false)) {
                        boolean isEnabled;
                        Object list;
                        ConfigurationSection prizeSection = prizesSection.getConfigurationSection(prize);
                        ArrayList<Tier> tierPrizes = new ArrayList<Tier>();
                        if (prizeSection == null) continue;
                        ArrayList<ItemStack> editorItems = new ArrayList<ItemStack>();
                        if (prizeSection.contains("Editor-Items") && (list = prizeSection.getList("Editor-Items")) != null) {
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Object key = iterator.next();
                                editorItems.add((ItemStack)key);
                            }
                        }
                        list = prizeSection.getStringList("Tiers").iterator();
                        while (list.hasNext()) {
                            String tier = (String)list.next();
                            for (Tier key : crate.getTiers()) {
                                if (!key.getName().equalsIgnoreCase(tier)) continue;
                                tierPrizes.add(key);
                            }
                        }
                        Prize alternativePrize = null;
                        ConfigurationSection alternativeSection = prizeSection.getConfigurationSection("Alternative-Prize");
                        if (alternativeSection != null && (isEnabled = alternativeSection.getBoolean("Toggle"))) {
                            alternativePrize = new Prize(prizeSection.getString("DisplayName", ""), prizeSection.getName(), alternativeSection);
                        }
                        prizes.add(new Prize(prizeSection, editorItems, tierPrizes, crate.getFileName(), alternativePrize));
                    }
                }
                crate.setPrize(prizes);
                this.inventoryManager.openPreview(crate);
            }
            catch (Exception exception) {
                String fileName = crate.getFileName();
                this.brokeCrates.add(fileName);
                if (!MiscUtils.isLogging()) break block10;
                this.logger.warn("There was an error while loading the {} file.", (Object)fileName, (Object)exception);
            }
        }
    }

    public void loadCustomItems() {
        String pluginName;
        PluginManager manager = this.server.getPluginManager();
        switch (pluginName = this.fusion.getItemsPlugin().toLowerCase()) {
            case "nexo": {
                manager.registerEvents((Listener)new NexoInteractListener(), (Plugin)this.plugin);
                break;
            }
            case "oraxen": {
                manager.registerEvents((Listener)new OraxenInteractListener(), (Plugin)this.plugin);
                break;
            }
            default: {
                if (Plugins.nexo.isEnabled()) {
                    manager.registerEvents((Listener)new NexoInteractListener(), (Plugin)this.plugin);
                }
                if (!Plugins.oraxen.isEnabled()) break;
                manager.registerEvents((Listener)new OraxenInteractListener(), (Plugin)this.plugin);
            }
        }
    }

    public void loadHolograms() {
        String pluginName;
        switch (pluginName = this.config.getProperty(ConfigKeys.hologram_plugin).toLowerCase()) {
            case "decentholograms": {
                if (!Plugins.decent_holograms.isEnabled()) {
                    return;
                }
                if (this.holograms != null && this.holograms.getName().equalsIgnoreCase("DecentHolograms")) {
                    return;
                }
                this.holograms = new DecentHologramsSupport();
                break;
            }
            case "fancyholograms": {
                if (!Plugins.fancy_holograms.isEnabled()) {
                    return;
                }
                this.holograms = new FancyHologramsSupport();
                break;
            }
            case "cmi": {
                this.fusion.log("warn", "<red>CMI Support is currently not available. It'll likely come back eventually.", new Object[0]);
                this.fusion.log("warn", "<red>You will have to use another holograms plugin like FancyHolograms.", new Object[0]);
                break;
            }
            case "none": {
                break;
            }
            default: {
                if (Plugins.decent_holograms.isEnabled()) {
                    if (this.holograms != null) break;
                    this.holograms = new DecentHologramsSupport();
                    break;
                }
                if (!Plugins.fancy_holograms.isEnabled()) break;
                this.holograms = new FancyHologramsSupport();
            }
        }
        if (MiscUtils.isLogging()) {
            if (this.holograms == null) {
                List.of("There was no hologram plugin found on the server. If you are using CMI", "Please make sure you enabled the hologram module in modules.yml", "You can run /crazycrates reload if using CMI otherwise restart your server.").forEach(arg_0 -> ((ComponentLogger)this.logger).warn(arg_0));
                return;
            }
            this.logger.info("{} support has been enabled.", (Object)this.holograms.getName());
        }
    }

    public List<String> getCrateNames(boolean keepExtension) {
        return this.instance.getCrateFiles(keepExtension);
    }

    public List<String> getCrateNames() {
        return this.instance.getCrateFiles(false);
    }

    public void loadCrates() {
        String[] schems;
        if (this.config.getProperty(ConfigKeys.update_examples_folder).booleanValue()) {
            ArrayList<FileAction> actions = new ArrayList<FileAction>();
            actions.add(FileAction.DELETE_FILE);
            actions.add(FileAction.EXTRACT_FOLDER);
            FileUtils.extract("guis", this.dataPath.resolve("examples"), actions);
            FileUtils.extract("logs", this.dataPath.resolve("examples"), actions);
            FileUtils.extract("crates", this.dataPath.resolve("examples"), actions);
            FileUtils.extract("schematics", this.dataPath.resolve("examples"), actions);
            actions.remove((Object)FileAction.EXTRACT_FOLDER);
            List.of("config.yml", "data.yml", "locations.yml", "messages.yml", "editor.yml").forEach(file -> FileUtils.extract(file, this.dataPath.resolve("examples"), actions));
        }
        this.giveNewPlayersKeys = false;
        this.purge();
        if (this.holograms != null) {
            this.holograms.purge(false);
        }
        if (MiscUtils.isLogging()) {
            this.logger.info("Loading all crate information...");
        }
        Path crates = this.dataPath.resolve("crates");
        for (String crateName : this.getCrateNames(true)) {
            try {
                PermissionDefault permissionDefault;
                boolean isTiersEmpty;
                PaperCustomFile customFile = this.fileManager.getPaperCustomFile(crates.resolve(crateName));
                if (customFile == null || !customFile.isLoaded()) continue;
                YamlConfiguration file2 = (YamlConfiguration)customFile.getConfiguration();
                CrateType crateType = CrateType.getFromName(file2.getString("Crate.CrateType", "CSGO"));
                ArrayList<Prize> prizes = new ArrayList<Prize>();
                ArrayList<Tier> tiers = new ArrayList<Tier>();
                String previewName = file2.contains("Crate.Preview.Name") ? file2.getString("Crate.Preview.Name", " ") : file2.getString("Crate.Name", " ");
                int maxMassOpen = file2.getInt("Crate.Max-Mass-Open", 10);
                int requiredKeys = file2.getInt("Crate.RequiredKeys", 0);
                ConfigurationSection section = file2.getConfigurationSection("Crate.Tiers");
                if (file2.contains("Crate.Tiers") && section != null) {
                    for (String tier : section.getKeys(false)) {
                        String path = "Crate.Tiers." + tier;
                        ConfigurationSection tierSection = file2.getConfigurationSection(path);
                        if (tierSection == null) continue;
                        tiers.add(new Tier(tier, tierSection));
                    }
                }
                boolean bl = isTiersEmpty = crateType == CrateType.cosmic || crateType == CrateType.casino;
                if (isTiersEmpty && tiers.isEmpty()) {
                    this.brokeCrates.add(crateName);
                    if (!MiscUtils.isLogging()) continue;
                    this.logger.warn("No tiers were found for {}.yml file.", (Object)crateName);
                    continue;
                }
                ConfigurationSection prizesSection = file2.getConfigurationSection("Crate.Prizes");
                if (prizesSection != null) {
                    for (String prize : prizesSection.getKeys(false)) {
                        boolean isEnabled;
                        Object keys;
                        ConfigurationSection prizeSection = prizesSection.getConfigurationSection(prize);
                        ArrayList<Tier> tierPrizes = new ArrayList<Tier>();
                        Prize alternativePrize = null;
                        if (prizeSection == null) continue;
                        ArrayList<ItemStack> editorItems = new ArrayList<ItemStack>();
                        if (prizeSection.contains("Editor-Items") && (keys = prizeSection.getList("Editor-Items")) != null) {
                            Iterator iterator = keys.iterator();
                            while (iterator.hasNext()) {
                                Object key = iterator.next();
                                editorItems.add((ItemStack)key);
                            }
                        }
                        keys = prizeSection.getStringList("Tiers").iterator();
                        while (keys.hasNext()) {
                            String tier = (String)keys.next();
                            for (Tier key : tiers) {
                                if (!key.getName().equalsIgnoreCase(tier)) continue;
                                tierPrizes.add(key);
                            }
                        }
                        ConfigurationSection alternativeSection = prizeSection.getConfigurationSection("Alternative-Prize");
                        if (alternativeSection != null && (isEnabled = alternativeSection.getBoolean("Toggle"))) {
                            alternativePrize = new Prize(prizeSection.getString("DisplayName", "<lang:item.minecraft." + prizeSection.getString("DisplayItem", "stone").toLowerCase() + ">"), prizeSection.getName(), alternativeSection);
                        }
                        prizes.add(new Prize(prizeSection, editorItems, tierPrizes, crateName, alternativePrize));
                    }
                }
                int newPlayersKeys = file2.getInt("Crate.StartingKeys", 0);
                if (!this.giveNewPlayersKeys && newPlayersKeys > 0) {
                    this.giveNewPlayersKeys = true;
                }
                List prizeMessage = file2.contains("Crate.Prize-Message") ? file2.getStringList("Crate.Prize-Message") : Collections.emptyList();
                List prizeCommands = file2.contains("Crate.Prize-Commands") ? file2.getStringList("Crate.Prize-Commands") : Collections.emptyList();
                CrateHologram holo = new CrateHologram(file2.getBoolean("Crate.Hologram.Toggle"), file2.getDouble("Crate.Hologram.Height", 0.0), file2.getInt("Crate.Hologram.Range", 8), file2.getString("Crate.Hologram.Color", "transparent"), file2.getInt("Crate.Hologram.Update-Interval", -1), file2.getStringList("Crate.Hologram.Message"));
                this.addCrate(new Crate(crateName, previewName, crateType, this.getKey((FileConfiguration)file2), file2.getString("Crate.PhysicalKey.Name", "Crate.PhysicalKey.Name is missing from " + crateName), prizes, file2, newPlayersKeys, tiers, maxMassOpen, requiredKeys, prizeMessage, prizeCommands, holo));
                String strippedName = crateName.replace(".yml", "");
                boolean isNewSystemEnabled = this.config.getProperty(ConfigKeys.use_new_permission_system);
                String node = isNewSystemEnabled ? "crazycrates.deny.open." + strippedName : "crazycrates.open." + strippedName;
                String description = isNewSystemEnabled ? "Prevents you from opening " + strippedName : "Allows you to open " + strippedName;
                PermissionDefault permissionDefault2 = permissionDefault = isNewSystemEnabled ? PermissionDefault.FALSE : PermissionDefault.TRUE;
                if (this.pluginManager.getPermission(node) != null) continue;
                Permission permission = new Permission(node, description, permissionDefault);
                this.pluginManager.addPermission(permission);
            }
            catch (Exception exception) {
                this.brokeCrates.add(crateName);
                if (!MiscUtils.isLogging()) continue;
                this.logger.warn("There was an error while loading the {} file.", (Object)crateName, (Object)exception);
            }
        }
        this.addCrate(new Crate("Menu"));
        if (MiscUtils.isLogging()) {
            this.logger.warn("All crate information has been loaded, Loading physical crate locations!");
        }
        YamlConfiguration locations = FileKeys.locations.getConfiguration();
        int loadedAmount = 0;
        int brokeAmount = 0;
        ConfigurationSection section = locations.getConfigurationSection("Locations");
        if (section != null) {
            for (String locationName : section.getKeys(false)) {
                try {
                    String worldName = locations.getString("Locations." + locationName + ".World");
                    if (worldName == null) {
                        return;
                    }
                    if (worldName.isBlank()) {
                        return;
                    }
                    World world = this.server.getWorld(worldName);
                    int x = locations.getInt("Locations." + locationName + ".X");
                    int y = locations.getInt("Locations." + locationName + ".Y");
                    int z = locations.getInt("Locations." + locationName + ".Z");
                    Location location = new Location(world, (double)x, (double)y, (double)z);
                    Crate crate = this.getCrateFromName(locations.getString("Locations." + locationName + ".Crate"));
                    if (world != null && crate != null) {
                        this.crateLocations.add(new CrateLocation(locationName, crate, location));
                        if (this.holograms != null) {
                            this.holograms.createHologram(location, crate, locationName);
                        }
                        ++loadedAmount;
                        continue;
                    }
                    this.brokeLocations.add(new BrokeLocation(locationName, crate, x, y, z, worldName));
                    ++brokeAmount;
                }
                catch (Exception exception) {}
            }
        }
        if (MiscUtils.isLogging()) {
            if (loadedAmount > 0 || brokeAmount > 0) {
                if (brokeAmount <= 0) {
                    this.logger.info("All physical crate locations have been loaded.");
                } else {
                    this.logger.info("Loaded {} physical crate locations.", (Object)loadedAmount);
                    this.logger.info("Failed to load {} physical crate locations.", (Object)brokeAmount);
                }
            }
            this.logger.info("Searching for schematics to load.");
        }
        if ((schems = new File(String.valueOf(this.plugin.getDataFolder()) + "/schematics/").list()) != null) {
            boolean isLogging = MiscUtils.isLogging();
            for (String schematicName : schems) {
                if (!schematicName.endsWith(".nbt")) continue;
                this.crateSchematics.add(new CrateSchematic(schematicName, new File(String.valueOf(this.plugin.getDataFolder()) + "/schematics/" + schematicName)));
                if (!isLogging) continue;
                this.logger.info("{} was successfully found and loaded.", (Object)schematicName);
            }
        }
        if (MiscUtils.isLogging()) {
            this.logger.info("All schematics were found and loaded.");
        }
        this.cleanDataFile();
        this.inventoryManager.loadButtons();
    }

    public void openCrate(@NotNull Player player, @NotNull Crate crate, @NotNull KeyType keyType, @NotNull Location location, boolean virtualCrate, boolean checkHand, EventType eventType) {
        this.openCrate(player, crate, keyType, location, virtualCrate, checkHand, false, eventType);
    }

    public void openCrate(@NotNull Player player, @NotNull Crate crate, @NotNull KeyType keyType, @NotNull Location location, boolean virtualCrate, boolean checkHand, boolean isSilent, EventType eventType) {
        CrateBuilder crateBuilder;
        SettingsManager config = ConfigManager.getConfig();
        if (crate.getCrateType() == CrateType.menu) {
            if (config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
                new CrateMainMenu(player, this.config.getProperty(ConfigKeys.inventory_name), this.config.getProperty(ConfigKeys.inventory_rows)).open();
                return;
            }
            Messages.feature_disabled.sendMessage((CommandSender)player);
            return;
        }
        String fancyName = crate.getCrateName();
        switch (crate.getCrateType()) {
            case csgo: {
                crateBuilder = new CsgoCrate(crate, player, 27);
                break;
            }
            case casino: {
                crateBuilder = new CasinoCrate(crate, player, 27);
                break;
            }
            case wonder: {
                crateBuilder = new WonderCrate(crate, player, 45);
                break;
            }
            case wheel: {
                crateBuilder = new WheelCrate(crate, player, 54);
                break;
            }
            case roulette: {
                crateBuilder = new RouletteCrate(crate, player, 27);
                break;
            }
            case war: {
                crateBuilder = new WarCrate(crate, player, 9);
                break;
            }
            case cosmic: {
                crateBuilder = new CosmicCrate(crate, player, 27);
                break;
            }
            case quad_crate: {
                if (this.isVirtualCrate(player, crate, virtualCrate, fancyName)) {
                    return;
                }
                crateBuilder = new QuadCrate(crate, player, location);
                break;
            }
            case fire_cracker: {
                if (this.cratesInUse.containsValue(location)) {
                    Messages.crate_in_use.sendMessage((CommandSender)player, "{crate}", fancyName);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                if (this.isVirtualCrate(player, crate, virtualCrate, fancyName)) {
                    return;
                }
                crateBuilder = new FireCrackerCrate(crate, player, 45, location);
                break;
            }
            case crate_on_the_go: {
                if (this.isVirtualCrate(player, crate, virtualCrate, fancyName)) {
                    return;
                }
                crateBuilder = new CrateOnTheGo(crate, player);
                break;
            }
            case quick_crate: {
                if (this.cratesInUse.containsValue(location)) {
                    Messages.crate_in_use.sendMessage((CommandSender)player, "{crate}", fancyName);
                    this.removePlayerFromOpeningList(player);
                    return;
                }
                if (this.isVirtualCrate(player, crate, virtualCrate, fancyName)) {
                    return;
                }
                crateBuilder = new QuickCrate(crate, player, location);
                break;
            }
            default: {
                crateBuilder = new CsgoCrate(crate, player, 27);
                if (!MiscUtils.isLogging()) break;
                List.of(crate.getFileName() + " has an invalid crate type. Your Value: " + crate.getFile().getString("Crate.CrateType", "CSGO"), "We will use " + CrateType.csgo.getName() + " until you change the crate type.", "Valid Crate Types: CSGO/Casino/Cosmic/QuadCrate/QuickCrate/Roulette/CrateOnTheGo/FireCracker/Wonder/Wheel/War").forEach(arg_0 -> ((ComponentLogger)this.logger).warn(arg_0));
            }
        }
        ((CrateBuilder)crateBuilder).open(keyType, checkHand, isSilent, eventType);
    }

    private boolean isVirtualCrate(@NotNull Player player, final @NotNull Crate crate, boolean virtualCrate, final @NotNull String fancyName) {
        if (virtualCrate) {
            Messages.cant_be_a_virtual_crate.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{cratetype}", crate.getCrateType().getName());
                    this.put("{crate}", fancyName);
                }
            });
            this.removePlayerFromOpeningList(player);
            return true;
        }
        return false;
    }

    public void addCrateInUse(@NotNull Player player, @NotNull Location location) {
        this.cratesInUse.put(player.getUniqueId(), location);
    }

    public Location getCrateInUseLocation(@NotNull Player player) {
        return this.cratesInUse.get(player.getUniqueId());
    }

    public boolean isCrateInUse(@NotNull Player player) {
        return this.cratesInUse.containsKey(player.getUniqueId());
    }

    public void removeCrateInUse(@NotNull Player player) {
        this.cratesInUse.remove(player.getUniqueId());
    }

    public Map<UUID, Location> getCratesInUse() {
        return Collections.unmodifiableMap(this.cratesInUse);
    }

    public void endCrate(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        if (this.currentTasks.containsKey(uuid)) {
            this.currentTasks.get(uuid).cancel();
            this.currentTasks.remove(uuid);
        }
    }

    public void endQuadCrate(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        if (this.currentQuadTasks.containsKey(uuid)) {
            for (ScheduledTask task : this.currentQuadTasks.get(uuid)) {
                task.cancel();
            }
            this.currentQuadTasks.remove(uuid);
        }
    }

    public void addQuadCrateTask(@NotNull Player player, @NotNull ScheduledTask task) {
        UUID uuid = player.getUniqueId();
        if (!this.currentQuadTasks.containsKey(uuid)) {
            this.currentQuadTasks.put(uuid, new ArrayList());
        }
        this.currentQuadTasks.get(uuid).add(task);
    }

    public boolean hasQuadCrateTask(@NotNull Player player) {
        return this.currentQuadTasks.containsKey(player.getUniqueId());
    }

    public void addCrateTask(@NotNull Player player, @NotNull ScheduledTask task) {
        this.currentTasks.put(player.getUniqueId(), task);
    }

    public void addRepeatingCrateTask(@NotNull Player player, @NotNull TimerTask task, long delay, long period) {
        this.timerTasks.put(player.getUniqueId(), task);
        this.plugin.getTimer().scheduleAtFixedRate(task, delay, period);
    }

    public void removeCrateTask(@NotNull Player player) {
        TimerTask task = this.timerTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    public void addCrateTask(@NotNull Player player, @NotNull TimerTask task, long delay) {
        this.timerTasks.put(player.getUniqueId(), task);
        this.plugin.getTimer().schedule(task, delay);
    }

    public final ScheduledTask getCrateTask(@NotNull Player player) {
        return this.currentTasks.get(player.getUniqueId());
    }

    public final boolean hasCrateTask(@NotNull Player player) {
        return this.currentTasks.containsKey(player.getUniqueId());
    }

    public void addPlayerToOpeningList(@NotNull Player player, @NotNull Crate crate) {
        this.playerOpeningCrates.put(player.getUniqueId(), crate);
    }

    public void removePlayerFromOpeningList(@NotNull Player player) {
        this.playerOpeningCrates.remove(player.getUniqueId());
    }

    public boolean isInOpeningList(@NotNull Player player) {
        return this.playerOpeningCrates.containsKey(player.getUniqueId());
    }

    public final Crate getOpeningCrate(@NotNull Player player) {
        return this.playerOpeningCrates.get(player.getUniqueId());
    }

    public void addPlayerKeyType(@NotNull Player player, @NotNull KeyType keyType) {
        this.playerKeys.put(player.getUniqueId(), keyType);
    }

    public void removePlayerKeyType(@NotNull Player player) {
        this.playerKeys.remove(player.getUniqueId());
    }

    public final boolean hasPlayerKeyType(@NotNull Player player) {
        return this.playerKeys.containsKey(player.getUniqueId());
    }

    @Nullable
    public final KeyType getPlayerKeyType(@NotNull Player player) {
        return this.playerKeys.get(player.getUniqueId());
    }

    public void purge() {
        this.crates.clear();
        this.brokeCrates.clear();
        this.crateLocations.clear();
        this.crateSchematics.clear();
    }

    public void setNewPlayerKeys(@NotNull Player player) {
        if (this.giveNewPlayersKeys) {
            String uuid = player.getUniqueId().toString();
            if (!player.hasPlayedBefore()) {
                this.getUsableCrates().stream().filter(Crate::doNewPlayersGetKeys).forEach(crate -> {
                    FileKeys.data.getConfiguration().set("Players." + uuid + "." + crate.getFileName(), (Object)crate.getNewPlayerKeys());
                    FileKeys.data.save();
                });
            }
        }
    }

    public void addCrate(@NotNull Crate crate) {
        this.crates.add(crate);
    }

    public void addLocation(@NotNull CrateLocation crateLocation) {
        this.crateLocations.add(crateLocation);
    }

    public void removeCrate(@NotNull Crate crate) {
        this.crates.remove(crate);
    }

    public boolean hasCrate(@NotNull Crate crate) {
        return this.crates.contains(crate);
    }

    public void addCrateByLocation(@NotNull Player player, final @NotNull Location location) {
        if (!player.hasPermission("crazycrates.editor")) {
            this.removeEditorCrate(player);
            Messages.force_editor_exit.sendMessage((CommandSender)player, "{reason}", "lacking the permission crazycrates.editor");
            return;
        }
        final Crate crate = this.getEditorCrate(player);
        if (crate == null) {
            this.removeEditorCrate(player);
            Messages.force_editor_exit.sendMessage((CommandSender)player, "{reason}", "Crate does not exist.");
            return;
        }
        if (crate.getCrateType() == CrateType.menu && !this.config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
            Messages.cannot_set_type.sendMessage((CommandSender)player);
            return;
        }
        if (this.isCrateLocation(location)) {
            if (this.editor.getProperty(EditorKeys.overwrite_old_crate_locations).booleanValue()) {
                final CrateLocation crateLocation = this.getCrateLocation(location);
                if (crateLocation == null) {
                    return;
                }
                this.removeLocation(crateLocation);
                this.addCrateLocation(location, crate);
                Messages.physical_crate_overridden.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("{id}", crateLocation.getID());
                        this.put("{crate}", crate.getCrateName());
                    }
                });
                this.spawnItem(location, ItemType.EMERALD.createItemStack());
                return;
            }
            Messages.physical_crate_already_exists.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    CrateLocation crateLocation = CrateManager.this.getCrateLocation(location);
                    this.put("{id}", crateLocation != null ? crateLocation.getID() : "N/A");
                    this.put("{crate}", crateLocation != null ? crateLocation.getCrate().getCrateName() : "N/A");
                }
            });
            this.spawnItem(location, ItemType.REDSTONE.createItemStack());
            return;
        }
        this.addCrateLocation(location, crate);
        Messages.created_physical_crate.sendMessage((CommandSender)player, "{crate}", crate.getCrateName());
        this.spawnItem(location, ItemType.EMERALD.createItemStack());
    }

    private void spawnItem(@NotNull Location location, @NotNull ItemStack itemStack) {
        World world = location.getWorld();
        final ItemDisplay itemDisplay = (ItemDisplay)world.spawn(location.toCenterLocation().add(0.0, 1.0, 0.0), ItemDisplay.class, entity -> entity.setItemStack(itemStack));
        itemDisplay.setPersistent(false);
        itemDisplay.setBillboard(Display.Billboard.CENTER);
        itemDisplay.setDisplayHeight(0.5f);
        itemDisplay.setDisplayWidth(0.5f);
        final Matrix4f scale = new Matrix4f().scale(0.5f);
        new FoliaScheduler(this, this.plugin, null, (Entity)itemDisplay){

            @Override
            public void run() {
                if (!itemDisplay.isValid()) {
                    this.cancel();
                    return;
                }
                itemDisplay.setTransformationMatrix(scale.rotateY((float)Math.toRadians(180.0) + 0.1f));
                itemDisplay.setInterpolationDelay(0);
                itemDisplay.setInterpolationDuration(20);
            }
        }.runAtFixedRate(1L, 20L);
        new FoliaScheduler(this, this.plugin, location){

            @Override
            public void run() {
                if (!itemDisplay.isValid()) {
                    this.cancel();
                    return;
                }
                itemDisplay.remove();
            }
        }.runDelayed(100L);
    }

    public void addCrateLocation(@NotNull Location location, @Nullable Crate crate) {
        if (crate == null) {
            return;
        }
        YamlConfiguration locations = FileKeys.locations.getConfiguration();
        Object id = "1";
        int i = 1;
        while (locations.contains("Locations." + i)) {
            id = "" + (i + 1);
            ++i;
        }
        for (CrateLocation crateLocation : this.getCrateLocations()) {
            if (!crateLocation.getLocation().equals((Object)location)) continue;
            id = crateLocation.getID();
            break;
        }
        locations.set("Locations." + (String)id + ".Crate", (Object)crate.getFileName());
        locations.set("Locations." + (String)id + ".World", (Object)location.getWorld().getName());
        locations.set("Locations." + (String)id + ".X", (Object)location.getBlockX());
        locations.set("Locations." + (String)id + ".Y", (Object)location.getBlockY());
        locations.set("Locations." + (String)id + ".Z", (Object)location.getBlockZ());
        FileKeys.locations.save();
        this.addLocation(new CrateLocation((String)id, crate, location));
        if (this.holograms != null) {
            this.holograms.createHologram(location, crate, (String)id);
        }
    }

    public void removeCrateLocation(@NotNull String id) {
        FileKeys.locations.getConfiguration().set("Locations." + id, null);
        FileKeys.locations.save();
        CrateLocation location = null;
        for (CrateLocation crateLocation : this.getCrateLocations()) {
            if (!crateLocation.getID().equalsIgnoreCase(id)) continue;
            location = crateLocation;
            break;
        }
        if (location != null) {
            this.removeLocation(location);
            if (this.holograms != null && location.getCrate().getHologram().isEnabled()) {
                this.holograms.removeHologram(location.getID());
            }
        }
    }

    @NotNull
    public final List<Crate> getUsableCrates() {
        ArrayList<Crate> crateList = new ArrayList<Crate>(this.crates);
        crateList.removeIf(crate -> crate.getCrateType() == CrateType.menu);
        return crateList;
    }

    @NotNull
    public final List<Crate> getCrates() {
        return Collections.unmodifiableList(this.crates);
    }

    @Nullable
    public final Crate getCrateFromName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (name.isEmpty()) {
            return null;
        }
        Crate crate = null;
        for (Crate key : this.crates) {
            if (!key.getFileName().equalsIgnoreCase(name)) continue;
            crate = key;
            break;
        }
        return crate;
    }

    @NotNull
    public final Optional<Crate> getCrateByName(@NotNull String name) {
        if (name.isEmpty()) {
            return Optional.empty();
        }
        Crate crate = null;
        for (Crate key : this.crates) {
            if (!key.getFileName().equalsIgnoreCase(name)) continue;
            crate = key;
            break;
        }
        return Optional.ofNullable(crate);
    }

    public final boolean isCrateLocation(@NotNull Location location) {
        for (CrateLocation crateLocation : this.getCrateLocations()) {
            String arg2;
            String arg1 = MiscUtils.location(crateLocation.getLocation());
            if (!arg1.equals(arg2 = MiscUtils.location(location))) continue;
            return true;
        }
        return false;
    }

    public final boolean isKey(@NotNull ItemStack item) {
        return this.getCrateFromKey(item) != null;
    }

    @Nullable
    public final Crate getCrateFromKey(@NotNull ItemStack item) {
        return this.getCrateFromName(ItemUtils.getKey(item.getPersistentDataContainer()));
    }

    @Nullable
    public final CrateLocation getCrateLocation(@NotNull Location location) {
        CrateLocation crateLocation = null;
        String asString = MiscUtils.location(location);
        for (CrateLocation key : this.crateLocations) {
            String locationAsString = MiscUtils.location(key.getLocation());
            if (!locationAsString.equals(asString)) continue;
            crateLocation = key;
            break;
        }
        return crateLocation;
    }

    @Nullable
    public final Crate getCrateFromLocation(@NotNull Location location) {
        Crate crate = null;
        String asString = MiscUtils.location(location);
        for (CrateLocation key : this.crateLocations) {
            String locationAsString = MiscUtils.location(key.getLocation());
            if (!locationAsString.equals(asString)) continue;
            crate = key.getCrate();
            break;
        }
        return crate;
    }

    @Nullable
    public final CrateSchematic getCrateSchematic(@NotNull String name) {
        if (name.isEmpty()) {
            return null;
        }
        for (CrateSchematic schematic : this.crateSchematics) {
            if (!schematic.schematicName().equalsIgnoreCase(name)) continue;
            return schematic;
        }
        return null;
    }

    public final boolean isDisplayReward(@NotNull Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            ItemStack itemStack = item.getItemStack();
            if (itemStack.getType() == Material.AIR) {
                return false;
            }
            return itemStack.getPersistentDataContainer().has(ItemKeys.crate_prize.getNamespacedKey());
        }
        return false;
    }

    public final boolean isKeyFromCrate(@Nullable ItemStack item, @Nullable Crate crate) {
        if (item == null || crate == null) {
            return false;
        }
        if (crate.getCrateType() == CrateType.menu) {
            return false;
        }
        if (item.getType() == Material.AIR) {
            return false;
        }
        PersistentDataContainerView container = item.getPersistentDataContainer();
        if (!container.has(ItemKeys.crate_key.getNamespacedKey())) {
            return false;
        }
        return crate.getFileName().equals(ItemUtils.getKey(container));
    }

    @Nullable
    public final HologramManager getHolograms() {
        return this.holograms;
    }

    @NotNull
    public final List<CrateLocation> getCrateLocations() {
        return Collections.unmodifiableList(this.crateLocations);
    }

    public void removeLocation(@NotNull CrateLocation crateLocation) {
        this.crateLocations.remove(crateLocation);
    }

    @NotNull
    public final List<String> getBrokeCrates() {
        return Collections.unmodifiableList(this.brokeCrates);
    }

    @NotNull
    public final List<BrokeLocation> getBrokeLocations() {
        return Collections.unmodifiableList(this.brokeLocations);
    }

    public void removeBrokeLocation(@NotNull List<BrokeLocation> crateLocation) {
        this.brokeLocations.removeAll(crateLocation);
    }

    @NotNull
    public final List<CrateSchematic> getCrateSchematics() {
        return Collections.unmodifiableList(this.crateSchematics);
    }

    private LegacyItemBuilder getKey(@NotNull FileConfiguration file) {
        String name = file.getString("Crate.PhysicalKey.Name", "");
        String customModelData = file.getString("Crate.PhysicalKey.Custom-Model-Data", "");
        String namespace = file.getString("Crate.PhysicalKey.Model.Namespace", "");
        String id = file.getString("Crate.PhysicalKey.Model.Id", "");
        List lore = file.getStringList("Crate.PhysicalKey.Lore");
        boolean glowing = file.getBoolean("Crate.PhysicalKey.Glowing", true);
        boolean hideFlags = file.getBoolean("Crate.PhysicalKey.HideItemFlags", false);
        LegacyItemBuilder itemBuilder = file.contains("Crate.PhysicalKey.Data") ? new LegacyItemBuilder(this.plugin).fromBase64(file.getString("Crate.PhysicalKey.Data", "")) : (LegacyItemBuilder)new LegacyItemBuilder(this.plugin).withType(file.getString("Crate.PhysicalKey.Item", "tripwire_hook").toLowerCase());
        return (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)itemBuilder.setDisplayName(name)).setDisplayLore(lore)).setGlowing(glowing)).setItemModel(namespace, id)).setHidingItemFlags(hideFlags)).setCustomModelData(customModelData);
    }

    private void cleanDataFile() {
        YamlConfiguration data = FileKeys.data.getConfiguration();
        if (!data.contains("Players")) {
            return;
        }
        boolean isLogging = MiscUtils.isLogging();
        if (isLogging) {
            this.logger.info("Cleaning up the data.yml file.");
        }
        ArrayList<String> removePlayers = new ArrayList<String>();
        ConfigurationSection section = data.getConfigurationSection("Players");
        if (section == null) {
            return;
        }
        for (String uuid2 : section.getKeys(false)) {
            if (data.contains("Players." + uuid2 + ".tracking")) {
                return;
            }
            boolean hasKeys = false;
            ArrayList<String> crates = new ArrayList<String>();
            for (Crate crate2 : this.getUsableCrates()) {
                String fileName = crate2.getFileName();
                if (!data.contains("Players." + uuid2) || !data.contains("Players." + uuid2 + "." + fileName)) continue;
                int keys = data.getInt("Players." + uuid2 + "." + fileName, 0);
                if (keys <= 0) {
                    crates.add(fileName);
                    continue;
                }
                hasKeys = true;
            }
            if (hasKeys) {
                crates.forEach(crate -> data.set("Players." + uuid2 + "." + crate, null));
                continue;
            }
            removePlayers.add(uuid2);
        }
        if (!removePlayers.isEmpty()) {
            if (isLogging) {
                this.logger.info("{} player's data has been marked to be removed.", (Object)removePlayers.size());
            }
            removePlayers.forEach(uuid -> data.set("Players." + uuid, null));
            if (isLogging) {
                this.logger.info("All empty player data has been removed.");
            }
        }
        if (isLogging) {
            this.logger.info("The data.yml file has been cleaned.");
        }
        FileKeys.data.save();
    }

    public void addPicker(@NotNull Player player, boolean value) {
        this.canPick.put(player.getUniqueId(), value);
    }

    public final boolean containsPicker(@NotNull Player player) {
        return this.canPick.containsKey(player.getUniqueId());
    }

    public boolean isPicker(@NotNull Player player) {
        return this.canPick.getOrDefault(player.getUniqueId(), false);
    }

    public void removePicker(@NotNull Player player) {
        this.canPick.remove(player.getUniqueId());
    }

    public void addCloser(@NotNull Player player, boolean value) {
        this.canClose.put(player.getUniqueId(), value);
    }

    public final boolean containsCloser(@NotNull Player player) {
        return this.canClose.containsKey(player.getUniqueId());
    }

    public void removeCloser(@NotNull Player player) {
        this.canClose.remove(player.getUniqueId());
    }

    public void addHands(@NotNull Player player, boolean checkHand) {
        this.checkHands.put(player.getUniqueId(), checkHand);
    }

    public void removeHands(@NotNull Player player) {
        this.checkHands.remove(player.getUniqueId());
    }

    public final boolean getHand(@NotNull Player player) {
        return this.checkHands.get(player.getUniqueId());
    }

    public void addReward(@NotNull Player player, @NotNull Entity entity) {
        this.allRewards.add(entity);
        this.rewards.put(player.getUniqueId(), entity);
    }

    public void removeReward(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        if (this.rewards.get(uuid) != null) {
            this.allRewards.remove(this.rewards.get(uuid));
            this.rewards.get(uuid).remove();
            this.rewards.remove(uuid);
        }
    }

    public void endQuickCrate(@NotNull Player player, final @NotNull Location location, @Nullable Crate crate, boolean useQuickCrateAgain) {
        CrateLocation crateLocation;
        if (this.hasCrateTask(player)) {
            this.getCrateTask(player).cancel();
            this.removeCrateTask(player);
        }
        this.removeReward(player);
        new FoliaScheduler(this, this.plugin, location){

            @Override
            public void run() {
                ChestManager.closeChest(location.getBlock(), false);
            }
        }.runNow();
        this.removeCrateInUse(player);
        this.removePlayerFromOpeningList(player);
        if (!useQuickCrateAgain && this.holograms != null && crate != null && crate.getHologram().isEnabled() && (crateLocation = this.getCrateLocation(location)) != null) {
            this.holograms.createHologram(location, crate, crateLocation.getID());
        }
    }

    public void removeCrateByLocation(@NotNull Player player, @NotNull Location location, boolean isAlreadyChecked) {
        CrateLocation crateLocation;
        if (!player.hasPermission("crazycrates.editor")) {
            this.removeEditorCrate(player);
            Messages.force_editor_exit.sendMessage((CommandSender)player, "{reason}", "lacking the permission crazycrates.editor");
            return;
        }
        if ((isAlreadyChecked || this.isCrateLocation(location)) && (crateLocation = this.getCrateLocation(location)) != null) {
            String id = crateLocation.getID();
            this.removeCrateLocation(id);
            Messages.removed_physical_crate.sendMessage((CommandSender)player, "{id}", id);
        }
    }

    public boolean isKey(@NotNull Player player, @NotNull EquipmentSlot equipmentSlot) {
        return this.isKey(player.getInventory().getItem(equipmentSlot));
    }

    public void purgeRewards() {
        if (!this.allRewards.isEmpty()) {
            this.allRewards.stream().filter(Objects::nonNull).forEach(Entity::remove);
        }
    }

    public final Tier getTier(@NotNull Crate crate, @NotNull ItemStack item) {
        NamespacedKey key;
        PersistentDataContainerView container = item.getPersistentDataContainer();
        if (!container.has(key = ItemKeys.crate_tier.getNamespacedKey())) {
            return null;
        }
        return crate.getTier((String)container.get(key, PersistentDataType.STRING));
    }

    public void addSlot(@NotNull Player player, final int rawSlot) {
        UUID uuid = player.getUniqueId();
        if (this.slots.containsKey(uuid)) {
            ArrayList<Integer> slots = this.slots.get(uuid);
            slots.add(rawSlot);
            this.slots.put(uuid, slots);
            return;
        }
        this.slots.put(uuid, new ArrayList<Integer>(){
            {
                this.add(rawSlot);
            }
        });
    }

    public final ArrayList<Integer> getSlots(@NotNull Player player) {
        return this.slots.get(player.getUniqueId());
    }

    public final boolean containsSlot(@NotNull Player player) {
        return this.slots.containsKey(player.getUniqueId());
    }

    public void removeSlot(@NotNull Player player) {
        this.slots.remove(player.getUniqueId());
    }
}

