/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotatedCommand {
    private final String command;
    private final List<String> alias = new ArrayList<String>();
    private final String description;

    public AnnotatedCommand() {
        this(null, null, null);
    }

    public AnnotatedCommand(@Nullable List<String> alias) {
        this(null, alias, null);
    }

    public AnnotatedCommand(@Nullable String command) {
        this(command, null, null);
    }

    public AnnotatedCommand(@Nullable String command, @Nullable String description) {
        this(command, null, description);
    }

    public AnnotatedCommand(@Nullable String command, @Nullable List<String> alias, @Nullable String description) {
        this.command = command;
        this.description = description;
        if (alias != null) {
            this.alias.addAll(alias);
        }
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    @NotNull
    public List<String> getAlias() {
        return this.alias;
    }

    @NotNull
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }
}

